/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.formula.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.formula.builder.BaseFormulaNodeItemBuilder;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.BizMessage;
import kd.sit.sitbp.common.api.TaxItemService;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.CalDataTypeEnum;
import kd.sit.sitbp.common.enums.CalFailTypeEnum;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.DefaultBizMessage;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxCalContext;
import kd.sit.sitbp.common.model.TaxCalUnit;
import kd.sit.sitbp.common.model.TaxDataWrapper;
import kd.sit.sitbp.common.util.BizServiceFactory;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxItemFormulaNodeItemBuilder
extends BaseFormulaNodeItemBuilder {
    private static final Log LOGGER = LogFactory.getLog(TaxItemFormulaNodeItemBuilder.class);
    private static final int SEQ_NO = 70;
    private static final String UC_PREFIX = "TI";
    private final TaxItemService taxItemService = (TaxItemService)BizServiceFactory.lookup((String)"TaxItemService");

    @Override
    public String uniCodePrefix() {
        return UC_PREFIX;
    }

    @Override
    public int seq(Long country, String appId, Long category, Map<String, Object> cond) {
        return 70;
    }

    @Override
    public boolean match(Long country, String appId, Long category, Map<String, Object> cond) {
        return true;
    }

    @Override
    public List<TreeNodeItem> rootWithAllNode(Long country, String appId, Long category, Map<String, Object> cond) {
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>(16);
        QFilter qFilter = (QFilter)cond.get("itemQfilter");
        resultList.add(this.build(UC_PREFIX, UC_PREFIX, "", ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee-TI", (String)"TaxCalFormulaEdit_1", (String)"sit-sitcs-business", (Object[])new Object[0])));
        this.assembleTaxItemNode(country, category, resultList, qFilter);
        return resultList;
    }

    @Override
    public void genCalItemVO(DynamicObject formulaDynamicObj, Set<String> itemKeys, Map<String, CalItemVO> uniqueCodeCalItemMap, TaxCalContext taxCalContext) {
        Map itemEntityMap = taxCalContext.getItemEntityMap();
        for (String obj : itemKeys) {
            Long itemId = Long.valueOf(obj);
            TaxItemEntity itemEntity = (TaxItemEntity)itemEntityMap.get(itemId);
            if (itemEntity == null) {
                long formulaId = formulaDynamicObj.getLong("id");
                taxCalContext.logInfo(formulaId + " formula genCalItemVO fail for item not exists");
                taxCalContext.formulaFail((BizMessage)new DefaultBizMessage(CalFailTypeEnum.ITEM_NOT_EXIST.getCode(), ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee{0}\u4e0d\u5b58\u5728\u4efb\u52a1\u5185", (String)"TaxItemFormulaNodeItemBuilder_1", (String)"sit-sitbp-business", (Object[])new Object[]{taxCalContext.taxItemNames(new Long[]{itemId})})), Long.valueOf(formulaId));
                return;
            }
            String uniCode = this.uniCodeResolver().uniCode(obj);
            CalItemVO fileVO = new CalItemVO();
            fileVO.setDataType(CalDataTypeEnum.getEnumById((long)itemEntity.getDatatypeId()));
            fileVO.setDataLength(Integer.valueOf(itemEntity.getDataLength()));
            fileVO.setScale(Integer.valueOf(itemEntity.getDataPrecisionScale()));
            fileVO.setUniqueCode(uniCode);
            fileVO.setId(uniCode);
            uniqueCodeCalItemMap.put(uniCode, fileVO);
        }
    }

    @Override
    public void resolveParams(CalAllParamVO paramVO, Set<String> itemKeys, TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Long catId, String paramId, TaxCalUnit taxCalUnit) {
        Map params = (Map)paramVO.getParamIdToParamMap().get(paramId);
        Map itemEntityMap = taxCalContext.getItemEntityMap();
        for (String itemKey : itemKeys) {
            Long itemId = (Long)BaseDataConverter.convert((Object)itemKey, Long.class);
            TaxDataWrapper taxData = taxCalUnit.getTaxData();
            DynamicObject item = taxData.getItem(itemId, catId);
            TaxItemEntity taxItemEntity = (TaxItemEntity)itemEntityMap.get(itemId);
            String dataKey = taxCalUnit.getSrcDataKey();
            LOGGER.info("Trace by Quinn: {} - {}", new Object[]{"resolveParams", itemKey, dataKey});
            if (taxItemEntity == null) {
                taxCalContext.doBizFailByDataKey(dataKey, CalFailTypeEnum.ITEM_NOT_EXIST, ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u6ca1\u6709\u5305\u542b\u4e2a\u7a0e\u9879\u76ee\u3010{0}\u3011", (String)"TaxCalFormulaEdit_2", (String)"sit-sitcs-business", (Object[])new Object[]{itemId}));
                break;
            }
            String uCode = this.uniCodeResolver().uniCode(itemKey);
            LOGGER.info("Trace by Quinn: {} - {}", (Object)"resolveParams", (Object)uCode);
            if (item == null || item.get("calvalue") == null) {
                TaxCalUnit resItem = (TaxCalUnit)taxCalContext.bizDataOf(dataKey);
                String defaultValue = taxItemEntity.getDefaultValue();
                if (resItem != null && !CalTaxTypeEnum.fromTaxById((long)taxItemEntity.getCaltaxtypeId())) {
                    taxCalContext.doBizFailByDataKey(dataKey, CalFailTypeEnum.ITEM_HAS_NO_VALUE, ResManager.loadKDString((String)"\u53c2\u4e0e\u8ba1\u7b97\u7684\u4e2a\u7a0e\u9879\u76ee\u3010{0}\u3011\u6ca1\u6709\u8d4b\u503c\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\u3010{1}\u3011", (String)"TaxCalFormulaEdit_3", (String)"sit-sitcs-business", (Object[])new Object[]{LocaleString.fromMap((Map)taxItemEntity.getName()).toString(), defaultValue}));
                }
                LOGGER.info("Trace by Quinn: {} - {}", (Object)"resolveParams.defaultValue", (Object)defaultValue);
                params.put(uCode, defaultValue);
                continue;
            }
            Object itemValue = this.getItemValue(taxItemEntity, item);
            LOGGER.info("Trace by Quinn: {} - {}", (Object)"resolveParams.defaultValue", itemValue);
            params.put(uCode, itemValue);
        }
    }

    @Override
    public void queryCalElements(TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Map<String, TaxCalUnit> taxCalUnitMap, Set<String> items) {
        DynamicObject[] taxDataBasics;
        String appId = taxCalContext.getAppId();
        HashMap taxCalUnitOfFile = Maps.newHashMapWithExpectedSize((int)taxCalUnitMap.size());
        for (Map.Entry<String, TaxCalUnit> entry : taxCalUnitMap.entrySet()) {
            TaxCalUnit value = entry.getValue();
            taxCalUnitOfFile.put(value.getTaxFileId(), value);
        }
        QFilter yearMonthFilter = new QFilter("yearmonth", "=", (Object)taskEntity.yearMonth());
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taskEntity.getId());
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter taxFileFilter = new QFilter("taxfile.boid", "in", taxCalUnitOfFile.keySet());
        PropertiesQueryInfo info = new PropertiesQueryInfo(appId + "_taxdatabasic");
        for (DynamicObject taxDataBasic : taxDataBasics = SitDataServiceHelper.commonQuery(info, new QFilter[]{yearMonthFilter, taxFileFilter, taxTaskFilter, statusFilter})) {
            long taxFileId = taxDataBasic.getLong("taxfile.boid");
            DynamicObject[] calUnit = (DynamicObject[])taxCalUnitOfFile.get(taxFileId);
            calUnit.setTaxDataBasic(taxDataBasic);
        }
        PropertiesQueryInfo rawDataBasicInfo = new PropertiesQueryInfo(appId + "_taxrawdatabasic");
        QFilter bizKeyFilter = new QFilter("1", "=", (Object)1).and(yearMonthFilter).and(taxFileFilter).and(taxTaskFilter);
        QFilter rawDataBasicFilter = new QFilter("rawdatakey", "in", taxCalUnitMap.keySet()).or(bizKeyFilter);
        DynamicObject[] taxRawDataBasic = SitDataServiceHelper.commonQuery(rawDataBasicInfo, new QFilter[]{rawDataBasicFilter, statusFilter}, "createtime desc");
        ArrayList rawBasicIds = Lists.newArrayListWithCapacity((int)taxRawDataBasic.length);
        String msgTpl = ResManager.loadKDString((String)"\u6e90\u6570\u636e\u5df2\u7ecf\u5b58\u5728\u4e8e\u4e2a\u7a0e\u4efb\u52a1{0}\u4e2a\u7a0e\u6863\u6848{1}\u4e4b\u4e2d", (String)"TaxItemFormulaNodeItemBuilder_0", (String)"sit-sitbp-business", (Object[])new Object[0]);
        for (DynamicObject dynamicObject : taxRawDataBasic) {
            long taxFileId = dynamicObject.getLong("taxfile.boid");
            TaxCalUnit calUnit = (TaxCalUnit)taxCalUnitOfFile.get(taxFileId);
            if (calUnit == null || dynamicObject.getLong("taxtask.id") != taskEntity.getId().longValue()) {
                CalFailTypeEnum.FailInstance msg = CalFailTypeEnum.RAW_DATA_IN_OTHER_TASK.of(MessageFormat.format(msgTpl, dynamicObject.getString("taxtask.number"), dynamicObject.getString("taxfile.number")));
                taxCalContext.calUnitFailByDataKey((BizMessage)msg, dynamicObject.getString("rawdatakey"));
                continue;
            }
            calUnit.addTaxRawDataBasic(dynamicObject);
            rawBasicIds.add(dynamicObject.getLong("id"));
        }
        if (!CollectionUtils.isEmpty((Collection)rawBasicIds)) {
            DynamicObject[] taxRawData;
            QFilter basicFilter = new QFilter("taxdatabasic.id", "in", (Object)rawBasicIds);
            PropertiesQueryInfo rawDataInfo = new PropertiesQueryInfo(appId + "_taxrawdata");
            rawDataInfo.subProp("entryentity", new String[]{"entryyearmonth", "originalValue", "taxitem", "datadirect", "itemvalue", "calvalue", "diffvalue"});
            for (DynamicObject taxDatum : taxRawData = SitDataServiceHelper.commonQuery(rawDataInfo, new QFilter[]{yearMonthFilter, basicFilter, statusFilter})) {
                long taxFileId = taxDatum.getLong("taxfile.boid");
                long rawCatId = taxDatum.getLong("taxcategory.id");
                TaxCalUnit calUnit = (TaxCalUnit)taxCalUnitOfFile.get(taxFileId);
                calUnit.addTaxRawData(taxDatum);
                calUnit.addCatIds(new Long[]{rawCatId});
            }
        }
        ArrayList basicIds = Lists.newArrayListWithCapacity((int)taxCalUnitMap.size());
        for (Map.Entry<String, TaxCalUnit> entry : taxCalUnitMap.entrySet()) {
            DynamicObject basicData;
            TaxCalUnit taxCalUnit = entry.getValue();
            TaxDataWrapper taxDataWrapper = taxCalUnit.getTaxData();
            if (taxDataWrapper == null || (basicData = taxDataWrapper.getBasicData()) == null) continue;
            basicIds.add(basicData.getLong("id"));
        }
        QFilter basicFilter = new QFilter("taxdatabasic.id", "in", (Object)basicIds);
        if (taskEntity.isLocalCal() || taxCalContext.isMergeRawData()) {
            DynamicObject[] dynamicObjectArray;
            PropertiesQueryInfo dataInfo = new PropertiesQueryInfo(appId + "_taxdata");
            dataInfo.subProp("entryentity", new String[]{"entryyearmonth", "taxitem", "datadirect", "itemvalue", "calvalue", "diffvalue"});
            for (DynamicObject taxDatum : dynamicObjectArray = SitDataServiceHelper.commonQuery(dataInfo, new QFilter[]{yearMonthFilter, basicFilter, statusFilter})) {
                long taxFileId = taxDatum.getLong("taxfile.boid");
                long catId = taxDatum.getLong("taxcategory.id");
                TaxCalUnit calUnit = (TaxCalUnit)taxCalUnitOfFile.get(taxFileId);
                calUnit.addTaxData(taxDatum);
                calUnit.addCatIds(new Long[]{catId});
            }
        }
        if (!taskEntity.isLocalCal()) {
            return;
        }
        QFilter catFilter = new QFilter("taxcategory.id", "in", taskEntity.getCalRuleIdMap().keySet());
        String string = appId + "_taxdeduct";
        PropertiesQueryInfo queryInfo = new PropertiesQueryInfo(string);
        queryInfo.subProp("entryentity", new String[]{"entryyearmonth", "taxitem", "datadirect", "itemvalue", "calvalue", "diffvalue"});
        String fieldsOfTaxData = SitDataServiceHelper.toQueryProperties(queryInfo, SitDataServiceHelper.DEFAULT_FILTER);
        HRBaseServiceHelper dataService = new HRBaseServiceHelper(string);
        Object[] taxDeducts = dataService.query(fieldsOfTaxData, new QFilter[]{yearMonthFilter, statusFilter, basicFilter, catFilter});
        if (!ArrayUtils.isEmpty((Object[])taxDeducts)) {
            for (Object prepareData : taxDeducts) {
                long taxFileId = prepareData.getLong("taxfile.boid");
                DynamicObjectCollection entryEntity = prepareData.getDynamicObjectCollection("entryentity");
                if (entryEntity != null) {
                    for (DynamicObject object : entryEntity) {
                        object.set("calvalue", object.get("itemvalue"));
                        object.set("diffvalue", (Object)0);
                    }
                }
                TaxCalUnit taxCalUnit = (TaxCalUnit)taxCalUnitOfFile.get(taxFileId);
                Set catIds = taxCalUnit.getCatIds();
                long prepareCat = prepareData.getLong("taxcategory.id");
                if (catIds == null || !catIds.contains(prepareCat) || !YesOrNoEnum.isYes((String)((String)taxCalUnit.getExtraParam("prepareStatus")))) continue;
                taxCalUnit.addPrepareData(Long.valueOf(prepareCat), (DynamicObject)prepareData);
            }
        }
    }

    private void assembleTaxItemNode(long countryId, long taxCategoryId, List<TreeNodeItem> resultList, QFilter qFilter) {
        if (countryId != 0L && taxCategoryId != 0L) {
            Map taxItems = this.taxItemService.loadTaxItems(countryId, taxCategoryId, 0L, false, new QFilter[]{qFilter});
            for (Map.Entry entry : taxItems.entrySet()) {
                TaxItemEntity value = (TaxItemEntity)entry.getValue();
                String uniCode = this.uniCodeResolver().uniCode(value.getId() + "");
                String name = LocaleString.fromMap((Map)value.getName()).getLocaleValue();
                TreeNodeItem item = this.build(UC_PREFIX, uniCode, UC_PREFIX, name, uniCode, CalDataTypeEnum.getEnumById((long)value.getDatatypeId()));
                if (!"C".equals(value.getStatus()) || !"1".equals(value.getEnable())) {
                    item.setShow(false);
                }
                resultList.add(item);
            }
        }
    }

    private Object getItemValue(TaxItemEntity taxItemEntity, DynamicObject item) {
        Object itemValue;
        if (taxItemEntity != null) {
            DataTypeEnum dataTypeEnum = CalDataTypeEnum.getEnumById((long)taxItemEntity.getDatatypeId());
            switch (dataTypeEnum) {
                case MONEY: 
                case NUM: {
                    itemValue = BaseDataConverter.convert((Object)item.get("calvalue"), BigDecimal.class);
                    break;
                }
                case INT: {
                    itemValue = BaseDataConverter.convert((Object)item.get("calvalue"), Integer.class);
                    break;
                }
                case DATE: {
                    itemValue = BaseDataConverter.convert((Object)item.get("calvalue"), Date.class);
                    break;
                }
                default: {
                    itemValue = BaseDataConverter.toString((Object)item.get("calvalue"));
                    break;
                }
            }
        } else {
            itemValue = BaseDataConverter.toString((Object)item.get("calvalue"));
        }
        return itemValue;
    }
}

