/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.formula.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.sit.sitbp.business.formula.builder.EntityFieldFormulaNodeItemBuilder;
import kd.sit.sitbp.common.api.SitAppService;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.TaxCalContext;
import kd.sit.sitbp.common.model.TaxCalUnit;
import kd.sit.sitbp.common.util.FormulaCalUtils;

public class TaxTaskFormulaNodeItemBuilder
extends EntityFieldFormulaNodeItemBuilder {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskFormulaNodeItemBuilder.class);
    private static final int SEQ_NO = 50;
    private static final String UC_PREFIX = "TK";

    @Override
    public String uniCodePrefix() {
        return UC_PREFIX;
    }

    @Override
    public int seq(Long country, String appId, Long category, Map<String, Object> cond) {
        return 50;
    }

    @Override
    public boolean match(Long country, String appId, Long category, Map<String, Object> cond) {
        return true;
    }

    @Override
    public List<TreeNodeItem> rootWithAllNode(Long country, String appId, Long category, Map<String, Object> cond) {
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>(16);
        resultList.add(this.build(UC_PREFIX, UC_PREFIX, "TFBS", ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u4fe1\u606f-TK", (String)"TaxCalFormulaEdit_5", (String)"sit-sitcs-business", (Object[])new Object[0])));
        this.assembleTaxTaskNode(appId, resultList, country);
        return resultList;
    }

    @Override
    public void genCalItemVO(DynamicObject formulaDynamicObj, Set<String> taxTaskKey, Map<String, CalItemVO> uniqueCodeCalItemMap, TaxCalContext taxCalContext) {
        HashMap<String, MainEntityType> typeMap = new HashMap<String, MainEntityType>(16);
        String appId = taxCalContext.getAppId();
        String metaTag = appId + "_taxtaskquery";
        for (String obj : taxTaskKey) {
            CalItemVO fileVO = TaxTaskFormulaNodeItemBuilder.assembleCalVO(metaTag, obj, typeMap);
            String uniCode = this.uniCodeResolver().uniCode(obj);
            fileVO.setUniqueCode(uniCode);
            uniqueCodeCalItemMap.put(uniCode, fileVO);
        }
    }

    @Override
    public void resolveParams(CalAllParamVO paramVO, Set<String> itemKeys, TaxCalContext taxCalContext, TaxTaskEntity taskEntity, Long catId, String paramId, TaxCalUnit taxCalUnit) {
        DynamicObject taxTask = taskEntity.taxTask();
        if (taxTask == null) {
            String appId = taxCalContext.getAppId();
            SitAppService sitAppService = SitAppService.lookUpSitAppService((String)appId);
            sitAppService.queryRuntimeTask(taskEntity);
            taxTask = taskEntity.taxTask();
        }
        Map params = (Map)paramVO.getParamIdToParamMap().get(paramId);
        for (String fileKey : itemKeys) {
            String uniCode = this.uniCodeResolver().uniCode(fileKey);
            Object value = taxTask.get(fileKey);
            LOGGER.info("Trace by Quinn: {} - {} - {}", new Object[]{"resolveParams", uniCode, value});
            params.put(uniCode, value);
        }
    }

    private void assembleTaxTaskNode(String appId, List<TreeNodeItem> treeNodeItems, Long country) {
        QueryEntityType taxFileQuery = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)(appId + "_taxtaskquery"));
        MainEntityType mainEntityType = taxFileQuery.getMainEntityType();
        String mainEntityTypeName = mainEntityType.getName();
        for (QuerySelectField selectField : taxFileQuery.getSelectFields()) {
            String aliasType;
            String alias = selectField.getAlias();
            int index = alias.indexOf(46);
            if (index > 0 && (aliasType = alias.substring(0, index)).equals(mainEntityTypeName)) {
                alias = alias.substring(index + 1);
            }
            String name = selectField.getDisplayName();
            String uniCode = this.uniCodeResolver().uniCode(alias);
            treeNodeItems.add(this.build(UC_PREFIX, uniCode, UC_PREFIX, name, uniCode, FormulaCalUtils.getCalDataType((String)(appId + "_taxtask"), (String)selectField.getAlias(), (Long)country, (String)appId)));
        }
    }

    private static CalItemVO assembleCalVO(String metaTag, String fields, Map<String, MainEntityType> typeMap) {
        MainEntityType mainEntityType = typeMap.computeIfAbsent(metaTag, key -> MetadataServiceHelper.getDataEntityType((String)metaTag));
        int index = fields.indexOf(46);
        if (index < 0) {
            Object property = mainEntityType.getAllFields().get(fields);
            CalItemVO calItemVO = new CalItemVO();
            if (property instanceof TextProp) {
                calItemVO.setName(((TextProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.TEXT);
                calItemVO.setDataLength(Integer.valueOf(((TextProp)property).getMaxLenth()));
            } else if (property instanceof IntegerProp) {
                calItemVO.setName(((IntegerProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((IntegerProp)property).getScale()));
            } else if (property instanceof BigIntProp) {
                calItemVO.setName(((BigIntProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.INT);
                calItemVO.setScale(Integer.valueOf(((BigIntProp)property).getScale()));
            } else if (property instanceof DecimalProp) {
                calItemVO.setName(((DecimalProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.NUM);
                calItemVO.setScale(Integer.valueOf(((DecimalProp)property).getScale()));
            } else if (property instanceof DateTimeProp) {
                calItemVO.setName(((DateTimeProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.DATE);
            } else if (property instanceof BooleanProp) {
                calItemVO.setName(((BooleanProp)property).getName());
                calItemVO.setDataType(DataTypeEnum.BOOLEAN);
            }
            return calItemVO;
        }
        Object property = mainEntityType.getAllFields().get(fields.substring(0, index));
        if (property instanceof BasedataProp) {
            return TaxTaskFormulaNodeItemBuilder.assembleCalVO(((BasedataProp)property).getBaseEntityId(), fields.substring(index + 1), typeMap);
        }
        return new CalItemVO();
    }
}

