/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.formula.sinsurbuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.sitbp.entity.SInsurFormulaConditionDTO;
import kd.sdk.sit.sitbp.entity.SInsurFormulaEntity;
import kd.sdk.sit.sitbp.service.spi.SInsurFormulaNodeItemBuilder;
import kd.sit.sitbp.business.formula.sinsurbuilder.SInsurDefaultFormulaNodeItemBuilder;
import kd.sit.sitbp.common.entity.SInsurCalItemEntity;
import kd.sit.sitbp.common.util.SInsurFormulaCalUtils;

public abstract class SInsurBaseFormulaNodeItemBuilder
implements SInsurFormulaNodeItemBuilder {
    public static final List<String> SPECIAL_CHAR_LIST = Arrays.asList("[", "]", "\u3010", "\u3011");
    protected static final Log LOGGER = LogFactory.getLog(SInsurBaseFormulaNodeItemBuilder.class);
    private static final Map<String, SInsurFormulaNodeItemBuilder> NODE_ITEM_BUILDERS = new HashMap<String, SInsurFormulaNodeItemBuilder>(16);

    public static List<TreeNodeItem> getTreeNodeItem(List<SInsurFormulaConditionDTO> sInsurFormulaConditionDTOs) {
        HashMap<String, SInsurFormulaConditionDTO> sInsurFormulaConditionDTOMap = new HashMap<String, SInsurFormulaConditionDTO>(8);
        if (sInsurFormulaConditionDTOs != null) {
            sInsurFormulaConditionDTOs.forEach(sInsurFormulaConditionDTO -> {
                if (HRStringUtils.isNotEmpty((String)sInsurFormulaConditionDTO.getUnPreFix())) {
                    sInsurFormulaConditionDTOMap.put(sInsurFormulaConditionDTO.getUnPreFix(), (SInsurFormulaConditionDTO)sInsurFormulaConditionDTO);
                }
            });
        }
        return SInsurBaseFormulaNodeItemBuilder.getFormulaCfgRootNode(sInsurFormulaConditionDTOMap);
    }

    public static List<TreeNodeItem> getFormulaCfgRootNode(Map<String, SInsurFormulaConditionDTO> sInsurFormulaConditionDTOMap) {
        boolean isInvalid;
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_siformulacfg");
        DynamicObject cfgDy = helper.loadDynamicObject(new QFilter("number", "=", (Object)"1010_S"));
        boolean bl = isInvalid = cfgDy == null || cfgDy.getDynamicObjectCollection("entryentity").isEmpty();
        if (isInvalid) {
            return treeNodeItems;
        }
        DynamicObjectCollection entryEntity = cfgDy.getDynamicObjectCollection("entryentity");
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject entity = (DynamicObject)iterator.next();
            SInsurFormulaEntity formulaEntity = SInsurBaseFormulaNodeItemBuilder.getFormulaEntity(entity);
            if (formulaEntity == null) continue;
            if (SInsurFormulaEntity.NodeType.ROOT_NODE == formulaEntity.getNodeType() || SInsurFormulaEntity.NodeType.COMMON_PARENT_NODE == formulaEntity.getNodeType()) {
                treeNodeItems.add(SInsurBaseFormulaNodeItemBuilder.build(formulaEntity.getNodeNum(), formulaEntity.getNodeNum(), formulaEntity.getParentNode(), formulaEntity.getNodeName()));
                continue;
            }
            if (SInsurFormulaEntity.NodeType.LABLE_NODE != formulaEntity.getNodeType()) continue;
            ArrayList<SInsurFormulaEntity> tmpSInsurFormulaEntities = new ArrayList<SInsurFormulaEntity>(10);
            while (iterator.hasNext()) {
                SInsurFormulaEntity tmpFormulaEntity = SInsurBaseFormulaNodeItemBuilder.getFormulaEntity((DynamicObject)iterator.next());
                if (tmpFormulaEntity == null) continue;
                if (SInsurFormulaEntity.NodeType.LABLE_NODE == tmpFormulaEntity.getNodeType()) {
                    treeNodeItems.addAll(SInsurBaseFormulaNodeItemBuilder.handleLastNodeList(formulaEntity, tmpSInsurFormulaEntities, sInsurFormulaConditionDTOMap));
                    formulaEntity = tmpFormulaEntity;
                    tmpSInsurFormulaEntities.clear();
                    continue;
                }
                tmpSInsurFormulaEntities.add(tmpFormulaEntity);
            }
            treeNodeItems.addAll(SInsurBaseFormulaNodeItemBuilder.handleLastNodeList(formulaEntity, tmpSInsurFormulaEntities, sInsurFormulaConditionDTOMap));
            tmpSInsurFormulaEntities.clear();
        }
        return treeNodeItems;
    }

    private static SInsurFormulaEntity getFormulaEntity(DynamicObject entity) {
        String showfields;
        boolean isCurrInvalid;
        String nodeName = entity.getString("nodename");
        String nodeNum = entity.getString("fieldvalue");
        boolean isVisible = entity.getBoolean("isvisible");
        String nodeType = entity.getString("nodetype");
        boolean bl = isCurrInvalid = !isVisible || HRStringUtils.isEmpty((String)nodeNum) || HRStringUtils.isEmpty((String)nodeName) || HRStringUtils.isEmpty((String)nodeType);
        if (isCurrInvalid) {
            return null;
        }
        String parentNodeValue = entity.getString("parentnodevalue");
        String entityNumber = entity.getString("entitynumber");
        String dataType = entity.getString("datatype");
        SInsurFormulaEntity sInsurFormulaEntity = new SInsurFormulaEntity(nodeName, nodeNum, Boolean.valueOf(isVisible), parentNodeValue, nodeType, null, entityNumber, dataType);
        if (entity.getDynamicObjectType().getProperties().containsKey((Object)"showfields") && (showfields = entity.getString("showfields")) != null && showfields.trim().length() > 0) {
            sInsurFormulaEntity.setShowFields(showfields.trim());
        }
        return sInsurFormulaEntity;
    }

    protected static List<TreeNodeItem> handleLastNodeList(SInsurFormulaEntity labelFormulaEntity, List<SInsurFormulaEntity> childSInsurFormulaEntities, Map<String, SInsurFormulaConditionDTO> sInsurFormulaConditionDTOMap) {
        SInsurFormulaNodeItemBuilder sInsurFormulaNodeItemBuilder = NODE_ITEM_BUILDERS.get(labelFormulaEntity.getNodeNum());
        if (sInsurFormulaNodeItemBuilder == null || !labelFormulaEntity.getVisible().booleanValue()) {
            return Collections.emptyList();
        }
        return sInsurFormulaNodeItemBuilder.rootWithAllNode(labelFormulaEntity, childSInsurFormulaEntities, sInsurFormulaConditionDTOMap);
    }

    public List<TreeNodeItem> rootWithAllNode(SInsurFormulaEntity parentFormulaEntity, List<SInsurFormulaEntity> childSInsurFormulaEntities, Map<String, SInsurFormulaConditionDTO> sInsurFormulaConditionDtoMap) {
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        treeNodeItems.add(SInsurBaseFormulaNodeItemBuilder.build(parentFormulaEntity.getNodeNum(), parentFormulaEntity.getNodeNum(), parentFormulaEntity.getParentNode(), parentFormulaEntity.getNodeName()));
        SInsurFormulaConditionDTO sInsurFormulaConditionDTO = this.getSInsurFormulaConditionDTO(sInsurFormulaConditionDtoMap);
        this.allocateInsuranceItemNode(treeNodeItems, parentFormulaEntity, childSInsurFormulaEntities, sInsurFormulaConditionDTO);
        return treeNodeItems;
    }

    protected SInsurFormulaConditionDTO getSInsurFormulaConditionDTO(Map<String, SInsurFormulaConditionDTO> sInsurFormulaConditionDtoMap) {
        SInsurFormulaConditionDTO sInsurFormulaConditionDTO = sInsurFormulaConditionDtoMap.get(this.uniCodePrefix());
        if (sInsurFormulaConditionDTO == null) {
            sInsurFormulaConditionDTO = sInsurFormulaConditionDtoMap.getOrDefault("$", new SInsurFormulaConditionDTO());
            sInsurFormulaConditionDTO = new SInsurFormulaConditionDTO(sInsurFormulaConditionDTO.getInsurTypeId(), sInsurFormulaConditionDTO.getCountryId(), sInsurFormulaConditionDTO.getAppId(), sInsurFormulaConditionDTO.getCreateOrgId(), this.uniCodePrefix());
        }
        return sInsurFormulaConditionDTO;
    }

    private void allocateInsuranceItemNode(List<TreeNodeItem> treeNodeItems, SInsurFormulaEntity parentFormulaEntity, List<SInsurFormulaEntity> childSInsurFormulaEntities, SInsurFormulaConditionDTO sInsurFormulaConditionDTO) {
        if (childSInsurFormulaEntities.isEmpty()) {
            return;
        }
        for (SInsurFormulaEntity childSInsurFormulaEntity : childSInsurFormulaEntities) {
            String uniCode;
            if (!childSInsurFormulaEntity.getVisible().booleanValue()) continue;
            DataTypeEnum dataType = childSInsurFormulaEntity.getDataType();
            if (dataType != null) {
                uniCode = this.uniCodeResolver().uniCode(childSInsurFormulaEntity.getNodeNum());
                TreeNodeItem treeNodeItem = this.build(parentFormulaEntity.getNodeNum(), uniCode, parentFormulaEntity.getNodeNum(), childSInsurFormulaEntity.getNodeName(), uniCode, dataType);
                treeNodeItems.add(treeNodeItem);
                continue;
            }
            if (parentFormulaEntity.getEntityNumber() == null) continue;
            uniCode = this.uniCodeResolver().uniCode(parentFormulaEntity.getEntityNumber() + "." + childSInsurFormulaEntity.getNodeNum());
            SInsurCalItemEntity calDataType = SInsurFormulaCalUtils.getCalDataType((String)parentFormulaEntity.getEntityNumber(), (String)childSInsurFormulaEntity.getNodeNum(), (String)childSInsurFormulaEntity.getShowFields(), (SInsurFormulaConditionDTO)sInsurFormulaConditionDTO);
            if (calDataType == null || calDataType.getCalItemVO() == null) {
                LOGGER.error("SInsurBaseFormulaNodeItemBuilder.allocateInsuranceItemNode, entity number is {}, nodeNum is {}.", (Object)parentFormulaEntity.getEntityNumber(), (Object)childSInsurFormulaEntity.getNodeName());
                continue;
            }
            TreeNodeItem treeNodeItem = this.build(parentFormulaEntity.getNodeNum(), uniCode, parentFormulaEntity.getNodeNum(), childSInsurFormulaEntity.getNodeName(), uniCode, calDataType);
            if (treeNodeItem == null) continue;
            treeNodeItems.add(treeNodeItem);
        }
    }

    public static Map<String, SInsurFormulaNodeItemBuilder> getInstances() {
        return NODE_ITEM_BUILDERS;
    }

    public static SInsurBaseFormulaNodeItemBuilder getInstance(String prefix) {
        return (SInsurBaseFormulaNodeItemBuilder)NODE_ITEM_BUILDERS.get(prefix);
    }

    public static TreeNodeItem build(String itemCategory, String id, String parentId, String name) {
        return new TreeNodeItem(itemCategory, id, parentId, name);
    }

    public TreeNodeItem build(String itemCategory, String id, String parentId, String name, String uniqueCode, DataTypeEnum dataType) {
        return new CalItem(itemCategory, id, parentId, name, uniqueCode, dataType);
    }

    public TreeNodeItem build(String itemCategory, String id, String parentId, String name, String uniqueCode, SInsurCalItemEntity sinsurCalItemEntity) {
        if (sinsurCalItemEntity == null || sinsurCalItemEntity.getCalItemVO() == null) {
            return null;
        }
        CalItem calItem = new CalItem(itemCategory, id, parentId, name, uniqueCode, sinsurCalItemEntity.getCalItemVO().getDataType());
        if (sinsurCalItemEntity.getItemType() != null) {
            calItem.setItemType(sinsurCalItemEntity.getItemType());
            calItem.setEntityNumber(sinsurCalItemEntity.getEntityNumber());
            calItem.setPropertyField(sinsurCalItemEntity.getPropertyField());
            calItem.setOrders("number asc");
            if (sinsurCalItemEntity.getqFilters() != null) {
                calItem.setqFilters(sinsurCalItemEntity.getqFilters());
            }
        }
        return calItem;
    }

    public static boolean isContainSpecialChar(String name, List<String> specialCharList) {
        if (name == null || CollectionUtils.isEmpty(specialCharList)) {
            return false;
        }
        name = name.trim();
        boolean flag = false;
        for (String specialChar : specialCharList) {
            if (name.indexOf(specialChar) == -1) continue;
            flag = true;
            break;
        }
        return flag;
    }

    static {
        ServiceLoader<SInsurFormulaNodeItemBuilder> serviceLoader = ServiceLoader.load(SInsurFormulaNodeItemBuilder.class);
        for (SInsurFormulaNodeItemBuilder next : serviceLoader) {
            NODE_ITEM_BUILDERS.put(next.uniCodePrefix(), next);
        }
        NODE_ITEM_BUILDERS.put("$", SInsurDefaultFormulaNodeItemBuilder.DEFAULT);
    }
}

