/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.formula.sinsurbuilder;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.sitbp.entity.SInsurFormulaConditionDTO;
import kd.sdk.sit.sitbp.entity.SInsurFormulaEntity;
import kd.sit.sitbp.business.formula.sinsurbuilder.SInsurBaseFormulaNodeItemBuilder;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.CalDataTypeEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class SInsurItemFormulaNodeItemBuilder
extends SInsurBaseFormulaNodeItemBuilder {
    public String uniCodePrefix() {
        return "II";
    }

    public boolean match(Long country, String appId, Long category, Map<String, Object> cond) {
        return true;
    }

    @Override
    public List<TreeNodeItem> rootWithAllNode(SInsurFormulaEntity parentFormulaEntity, List<SInsurFormulaEntity> childSInsurFormulaEntities, Map<String, SInsurFormulaConditionDTO> sInsurFormulaConditionDtoMap) {
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        treeNodeItems.add(SInsurItemFormulaNodeItemBuilder.build(parentFormulaEntity.getNodeNum(), parentFormulaEntity.getNodeNum(), parentFormulaEntity.getParentNode(), parentFormulaEntity.getNodeName()));
        SInsurFormulaConditionDTO sInsurFormulaConditionDTO = this.getSInsurFormulaConditionDTO(sInsurFormulaConditionDtoMap);
        this.assembleInsuranceItemNode(treeNodeItems, sInsurFormulaConditionDTO);
        return treeNodeItems;
    }

    private void assembleInsuranceItemNode(List<TreeNodeItem> resultList, SInsurFormulaConditionDTO sInsurFormulaConditionDTO) {
        QFilter filter;
        String selectProperties = BaseDataHisHelper.getSelectProperties("sitbs_insuranceitem");
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_insuranceitem");
        DynamicObject[] insuranceItemDys = helper.query(selectProperties, (filter = new QFilter("1", "=", (Object)1)).toArray(), "group.number asc,number asc");
        if (insuranceItemDys == null || insuranceItemDys.length == 0) {
            return;
        }
        filter = new QFilter("country", "=", (Object)sInsurFormulaConditionDTO.getCountryId());
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        sInsurFormulaConditionDTO.getNodeNumAndRefQFiltersMap().values().stream().flatMap(qfilters -> Optional.ofNullable(qfilters).orElseGet(() -> Collections.emptyList()).stream()).forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        DynamicObjectCollection authorizedInsuranceItemDys = helper.queryOriginalCollection("id", filter.toArray());
        Set<Object> authorizedItemIds = new HashSet(16);
        if (authorizedInsuranceItemDys != null) {
            authorizedItemIds = authorizedInsuranceItemDys.stream().map(authorizedItemDy -> authorizedItemDy.getLong("id")).collect(Collectors.toSet());
        }
        for (DynamicObject insuranceItemDy : insuranceItemDys) {
            String name = insuranceItemDy.getString("name");
            Long pkId = insuranceItemDy.getLong("id");
            String uniCode = this.uniCodeResolver().uniCode(String.valueOf(pkId));
            CalItem item = new CalItem("II", uniCode, "II", name, uniCode, CalDataTypeEnum.getEnumById((long)insuranceItemDy.getLong("datatype.id")));
            item.setShow(authorizedItemIds.contains(pkId));
            resultList.add((TreeNodeItem)item);
        }
    }

    private Object getItemValue(TaxItemEntity taxItemEntity, DynamicObject item) {
        Object itemValue;
        if (taxItemEntity != null) {
            DataTypeEnum dataTypeEnum = CalDataTypeEnum.getEnumById((long)taxItemEntity.getDatatypeId());
            switch (dataTypeEnum) {
                case MONEY: 
                case NUM: {
                    itemValue = BaseDataConverter.convert((Object)item.get("calvalue"), BigDecimal.class);
                    break;
                }
                case INT: {
                    itemValue = BaseDataConverter.convert((Object)item.get("calvalue"), Integer.class);
                    break;
                }
                case DATE: {
                    itemValue = BaseDataConverter.convert((Object)item.get("calvalue"), Date.class);
                    break;
                }
                default: {
                    itemValue = BaseDataConverter.toString((Object)item.get("calvalue"));
                    break;
                }
            }
        } else {
            itemValue = BaseDataConverter.toString((Object)item.get("calvalue"));
        }
        return itemValue;
    }
}

