/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.handler;

import java.util.Map;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class BaseProcessHandler
implements ProcessHandler {
    private static final Log LOGGER = LogFactory.getLog(BaseProcessHandler.class);
    private IFormView view;

    public void open(IFormView formView, String caption, Map<String, Object> param) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sitbp_basicprocess");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(caption);
        if (param != null) {
            showParameter.getCustomParams().putAll(param);
            Object closeCallBack = param.get("closeCallBack");
            showParameter.setCloseCallBack((CloseCallBack)closeCallBack);
        }
        formView.showForm(showParameter);
        formView.getPageCache().put("processPageId", showParameter.getPageId());
        this.view = formView.getView(showParameter.getPageId());
    }

    public void update(long totalWeight, long dealWeight, long totalNum, long dealNum, long failNum, String msg) {
        if (this.view != null) {
            this.view.getPageCache().put("totalNum", totalNum + "");
            this.view.getPageCache().put("dealNum", dealNum + "");
            this.view.getPageCache().put("failNum", failNum + "");
            this.view.getPageCache().put("successNum", (dealNum - failNum < 0L ? 0L : dealNum - failNum) + "");
            this.view.getPageCache().put("progress", dealWeight * 100L / totalWeight + "");
            this.view.getPageCache().saveChanges();
        }
    }

    public void close(Map<String, Object> cond) {
        LOGGER.info("BaseProcessHandler close start");
        if (this.view != null) {
            LOGGER.info("BaseProcessHandler close view not is null.");
            this.view.getPageCache().put("finish", "1");
            if (cond == null) {
                return;
            }
            for (Map.Entry<String, Object> entry : cond.entrySet()) {
                this.view.getPageCache().put(entry.getKey(), BaseDataConverter.toString((Object)entry.getValue()));
            }
        }
        LOGGER.info("BaseProcessHandler close end");
    }
}

