/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class SITLogServiceHelper {
    private static final Log logger = LogFactory.getLog(SITLogServiceHelper.class);

    public static void addLog(IFormView formView, String opName, String opDescription) {
        if (formView instanceof ListView) {
            AppInfo appInfo;
            AppLogInfo appLogInfo = new AppLogInfo();
            String appNumber = formView.getFormShowParameter().getAppId();
            String appId = " ";
            if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
                appId = appInfo.getId();
            }
            appLogInfo.setBizAppID(appId);
            appLogInfo.setBizObjID(((ListView)formView).getBillFormId());
            appLogInfo.setOpName(opName);
            appLogInfo.setOpDescription(opDescription);
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        } else {
            LogServiceHelper.addLog((IFormView)formView, (String)opName, (String)opDescription);
        }
    }

    public static void addLog(String appId, String entityName, String opName, String opDescription) {
        if (!(HRStringUtils.isEmpty((String)appId) || HRStringUtils.isEmpty((String)entityName) || HRStringUtils.isEmpty((String)opName) || HRStringUtils.isEmpty((String)opDescription))) {
            String appNumber = " ";
            switch (appId) {
                case "sitbs": {
                    appNumber = "17/+7RIW4SCJ";
                    break;
                }
                case "hcsi": {
                    appNumber = "2AXKDRPJUQ77";
                    break;
                }
                case "itc": {
                    appNumber = "17/+CT1QBPNP";
                    break;
                }
            }
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID(appNumber);
            appLogInfo.setBizObjID(entityName);
            appLogInfo.setOpName(opName);
            appLogInfo.setOpDescription(opDescription);
            try {
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            }
            catch (Exception e) {
                logger.error("SITLogServiceHelper.addLog: ", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }
}

