/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.dataprovider;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.DataProvider;

public class StaticDataProvider
implements DataProvider {
    private final Map<String, DataBatch<?>> dataListMapNew;
    private final Map<String, Integer> doing = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> done = new ConcurrentHashMap<String, Integer>();

    public StaticDataProvider(Map<String, DataBatch<?>> dataListMapNew) {
        this.dataListMapNew = dataListMapNew;
    }

    public boolean hasNextData(String dataKey) {
        return this.dataListMapNew.containsKey(dataKey) || this.doing.containsKey(dataKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBatch<?> getNextData(String dataKey) {
        DataBatch<?> remove;
        StaticDataProvider staticDataProvider = this;
        synchronized (staticDataProvider) {
            remove = this.dataListMapNew.remove(dataKey);
        }
        if (remove != null) {
            this.doing.put(dataKey, 0);
        } else if (!this.doing.containsKey(dataKey)) {
            this.done.put(dataKey, 0);
        }
        return remove;
    }

    public synchronized void completeBatch(DataBatch<?> dataBatch) {
        this.doing.remove(dataBatch.getDataKey());
        this.done.put(dataBatch.getDataKey(), dataBatch.getStartIndex());
    }

    public boolean isDone(String dataKey) {
        return this.done.containsKey(dataKey);
    }
}

