/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.helper.dataprovider.BaseDataBatch;
import kd.sit.sitbp.business.helper.dataprovider.StaticDataProvider;
import kd.sit.sitbp.business.helper.excel.cellstyle.CellStyleFactory;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.valuewrapper.ValueWrapper;
import kd.sit.sitbp.business.util.SITURLHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.DataProvider;
import kd.sit.sitbp.common.stream.StreamUtil;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper {
    private static final Log LOGGER = LogFactory.getLog(ExcelHelper.class);

    private ExcelHelper() {
    }

    public static Workbook writeData(WorkbookInfo workbookInfo, List<?> dataList, ExportResult exportResult) {
        return ExcelHelper.writeData(workbookInfo, dataList, 0, exportResult);
    }

    public static Workbook writeData(WorkbookInfo workbookInfo, List<?> dataList, int startIndex, ExportResult exportResult) {
        return ExcelHelper.writeData(workbookInfo, dataList, startIndex, null, exportResult);
    }

    public static Workbook writeData(WorkbookInfo workbookInfo, Map<String, DataBatch<?>> dataListMap, ExportResult exportResult) {
        return ExcelHelper.writeData(workbookInfo, dataListMap, null, exportResult);
    }

    public static Workbook writeData(WorkbookInfo workbookInfo, List<?> dataList, int startIndex, InputStream inputStream, ExportResult exportResult) {
        List<SheetInfo> sheetInfoList = workbookInfo.getSheetInfoList();
        if (CollectionUtils.isEmpty(sheetInfoList)) {
            exportResult.addMessage(ResManager.loadKDString((String)"\u6a21\u677f[Sheet\u914d\u7f6e]\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelHelper_0", (String)"sit-sitbp-business", (Object[])new Object[0]));
            return null;
        }
        BaseDataBatch dataBatch = new BaseDataBatch(dataList, startIndex, "defaultData");
        ConcurrentHashMap dataListMap = new ConcurrentHashMap(2);
        dataListMap.put("defaultData", dataBatch);
        return ExcelHelper.writeData(workbookInfo, dataListMap, inputStream, exportResult);
    }

    public static Workbook writeData(WorkbookInfo workbookInfo, Map<String, DataBatch<?>> dataListMap, InputStream inputStream, ExportResult exportResult) {
        ConcurrentHashMap dataListMapNew = new ConcurrentHashMap(8);
        Map<String, List<?>> dataListMap1 = workbookInfo.getDataListMap();
        if (dataListMap1 != null) {
            for (Map.Entry<String, List<?>> entry : dataListMap1.entrySet()) {
                dataListMapNew.put(entry.getKey(), new BaseDataBatch(entry.getValue(), 0, entry.getKey()));
            }
        }
        if (dataListMap != null) {
            dataListMapNew.putAll(dataListMap);
        }
        return ExcelHelper.writeData(workbookInfo, new StaticDataProvider(dataListMapNew), inputStream, exportResult);
    }

    public static Workbook writeData(WorkbookInfo workbookInfo, DataProvider dataProvider, ExportResult exportResult) {
        return ExcelHelper.writeData(workbookInfo, dataProvider, null, exportResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Workbook writeData(WorkbookInfo workbookInfo, DataProvider dataProvider, InputStream inputStream, ExportResult exportResult) {
        if (inputStream == null && workbookInfo.hasResource()) {
            inputStream = workbookInfo.getResource();
        }
        if (workbookInfo.isNeedTemplate() && inputStream == null) {
            LOGGER.error("Workbook of {} need template, but inputStream is null", (Object)workbookInfo.fullName());
            exportResult.addMessage(ResManager.loadKDString((String)"\u6a21\u677f\u914d\u7f6e\u9700\u8981\u6307\u5b9a\u8d44\u6e90\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelHelper_1", (String)"sit-sitbp-business", (Object[])new Object[0]));
            return null;
        }
        List<SheetInfo> sheetInfoList = workbookInfo.getSheetInfoList();
        if (CollectionUtils.isEmpty(sheetInfoList)) {
            LOGGER.error("Sheet of WB {} is empty", (Object)workbookInfo.fullName());
            exportResult.addMessage(ResManager.loadKDString((String)"\u6a21\u677f[Sheet\u914d\u7f6e]\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelHelper_0", (String)"sit-sitbp-business", (Object[])new Object[0]));
            return null;
        }
        Class<ExcelHelper> clazz = ExcelHelper.class;
        // MONITORENTER : kd.sit.sitbp.business.helper.excel.ExcelHelper.class
        Workbook wb = ExcelHelper.newWorkbook(inputStream, workbookInfo);
        // MONITOREXIT : clazz
        CountDownLatch latch = new CountDownLatch(sheetInfoList.size());
        RequestContext ctx = RequestContext.get();
        for (int i = 0; i < sheetInfoList.size(); ++i) {
            Map<String, CellStyle> bodyCellStyleMap;
            SheetInfo sheetInfo = sheetInfoList.get(i);
            Class<ExcelHelper> clazz2 = ExcelHelper.class;
            // MONITORENTER : kd.sit.sitbp.business.helper.excel.ExcelHelper.class
            Sheet sheet = ExcelHelper.newSheet(wb, sheetInfo);
            // MONITOREXIT : clazz2
            if (sheetInfo.isNeedFillHead()) {
                bodyCellStyleMap = ExcelHelper.fillHead(sheet, sheetInfo);
                if (MapUtils.isEmpty(bodyCellStyleMap)) {
                    exportResult.addMessage(MessageFormat.format(ResManager.loadKDString((String)"{0}\u6807\u9898\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelHelper_5", (String)"sit-sitbp-business", (Object[])new Object[0]), sheetInfo.getName()));
                }
                sheetInfo.setBodyCellStyleMap(bodyCellStyleMap);
                sheetInfo.setNeedFillHead(false);
            } else {
                bodyCellStyleMap = sheetInfo.getBodyCellStyleMap();
            }
            RequestContext.copyAndSet((RequestContext)ctx);
            ExcelHelper.fillContent(dataProvider, exportResult, latch, sheetInfo, sheet, bodyCellStyleMap);
        }
        try {
            boolean await = latch.await(3L, TimeUnit.MINUTES);
            if (!await) {
                exportResult.addMessage(ResManager.loadKDString((String)"\u4fe1\u606f\u91cf\u8fc7\u5927\uff0c\u4e0b\u8f7d\u8d85\u65f6\u3002", (String)"ExcelHelper_2", (String)"sit-sitbp-business", (Object[])new Object[0]));
                return null;
            }
        }
        catch (InterruptedException ignored) {
            exportResult.addMessage(ResManager.loadKDString((String)"\u4e0b\u8f7d\u8fc7\u7a0b\u88ab\u6253\u65ad\uff0c\u4fe1\u606f\u53ef\u80fd\u4e0d\u5b8c\u6574\uff0c\u5efa\u8bae\u91cd\u65b0\u4e0b\u8f7d\u3002", (String)"ExcelHelper_3", (String)"sit-sitbp-business", (Object[])new Object[0]));
            return null;
        }
        LOGGER.warn(exportResult.dealNum() + " Total Dealed by Quinn");
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workbook writeData(WorkbookInfo workbookInfo, DataBatch dataBatch, ExportResult exportResult) {
        if (workbookInfo.isNeedTemplate() && workbookInfo.getResource() == null) {
            LOGGER.error("Workbook of {} need template, but inputStream is null", (Object)workbookInfo.fullName());
            exportResult.addMessage(ResManager.loadKDString((String)"\u6a21\u677f\u914d\u7f6e\u9700\u8981\u6307\u5b9a\u8d44\u6e90\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelHelper_1", (String)"sit-sitbp-business", (Object[])new Object[0]));
            return null;
        }
        SheetInfo sheetInfo = workbookInfo.getSheetInfo(dataBatch.getDataKey());
        if (sheetInfo == null) {
            LOGGER.error("Sheet of WB {} is empty", (Object)workbookInfo.fullName());
            exportResult.addMessage(ResManager.loadKDString((String)"\u6a21\u677f[Sheet\u914d\u7f6e]\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelHelper_0", (String)"sit-sitbp-business", (Object[])new Object[0]));
            return null;
        }
        Class<ExcelHelper> clazz = ExcelHelper.class;
        synchronized (ExcelHelper.class) {
            Workbook wb = ExcelHelper.newWorkbook(workbookInfo.getResource(), workbookInfo);
            if (wb == null) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            Class<ExcelHelper> clazz2 = ExcelHelper.class;
            synchronized (ExcelHelper.class) {
                Map<String, CellStyle> bodyCellStyleMap;
                Sheet sheet = ExcelHelper.newSheet(wb, sheetInfo);
                if (sheet == null) {
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
                if (sheetInfo.isNeedFillHead()) {
                    bodyCellStyleMap = ExcelHelper.fillHead(sheet, sheetInfo);
                    if (MapUtils.isEmpty(bodyCellStyleMap)) {
                        exportResult.addMessage(MessageFormat.format(ResManager.loadKDString((String)"{0}\u6807\u9898\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExcelHelper_5", (String)"sit-sitbp-business", (Object[])new Object[0]), sheetInfo.getName()));
                    }
                    sheetInfo.setBodyCellStyleMap(bodyCellStyleMap);
                    sheetInfo.setNeedFillHead(false);
                } else {
                    bodyCellStyleMap = sheetInfo.getBodyCellStyleMap();
                }
                ExcelHelper.fillContent(sheet, sheetInfo, dataBatch, bodyCellStyleMap, exportResult);
                return wb;
            }
        }
    }

    private static Map<String, CellStyle> fillHead(Sheet sheet, SheetInfo sheetInfo) {
        HeadCellBar headCellBar = sheetInfo.getHeadCellBar();
        if (headCellBar == null) {
            return null;
        }
        int row = sheetInfo.getHeadRow();
        int headSize = headCellBar.size();
        Workbook workbook = sheet.getWorkbook();
        CellStyle defaultHeadCellStyle = CellStyleFactory.generateCellStyle(workbook, null, headCellBar.getHeadCellStyleName());
        CellStyle defaultBodyCellStyle = CellStyleFactory.generateCellStyle(sheet.getWorkbook(), null, headCellBar.getBodyCellStyleName());
        List<HeadCellInfo> headCellInfoList = headCellBar.getHeadCellInfoList();
        HashMap<String, CellStyle> result = new HashMap<String, CellStyle>(headSize);
        for (HeadCellInfo cellInfo : headCellInfoList) {
            Boolean useTemplate;
            if (cellInfo.isContent()) {
                if (cellInfo.needBodySpecialStyle()) {
                    CellStyle bodyCellStyle = CellStyleFactory.generateCellStyle(workbook, cellInfo.getBodyStyleParam(), cellInfo.getBodyStyleName(), headCellBar.getBodyCellStyleName());
                    result.put(cellInfo.getPosFlag(), bodyCellStyle);
                    sheet.setDefaultColumnStyle(cellInfo.getColNum(), bodyCellStyle);
                } else {
                    result.put(cellInfo.getPosFlag(), defaultBodyCellStyle);
                    sheet.setDefaultColumnStyle(cellInfo.getColNum(), defaultBodyCellStyle);
                }
            }
            if ((useTemplate = (Boolean)GlobalParam.getOrDefault((String)"useTemplate", (Object)Boolean.FALSE)) != null && useTemplate.booleanValue() || !headCellBar.isHeadShouldWritten()) continue;
            int realRow = row + cellInfo.getRowNum();
            CellStyle headCellStyle = defaultHeadCellStyle;
            if (cellInfo.needHeadSpecialStyle()) {
                headCellStyle = CellStyleFactory.generateCellStyle(workbook, cellInfo.getHeadStyleParam(), cellInfo.getHeadStyleName(), headCellBar.getHeadCellStyleName());
            }
            Cell cell = ExcelHelper.newCell(sheet, realRow, cellInfo.getColNum(), cellInfo.getRowSpan(), cellInfo.getColSpan(), cellInfo, headCellBar.isHorizontal(), headCellStyle);
            String headValueWrapper = cellInfo.getHeadValueWrapper();
            if (StringUtils.isEmpty((CharSequence)headValueWrapper)) {
                cell.setCellValue(cellInfo.getI18nDesc());
            } else {
                cell.setCellValue(ValueWrapper.wrapWith(cellInfo.getI18nDesc(), String.class, headValueWrapper));
            }
            String comment = cellInfo.getComment();
            if (!StringUtils.isEmpty((CharSequence)comment)) {
                ExcelHelper.addCellComment(cell, comment);
            }
            ExcelHelper.setWidthAndHeight(sheet, headCellBar, cellInfo, realRow);
            List<String> dropDownVals = cellInfo.getDropDownVals();
            if (CollectionUtils.isEmpty(dropDownVals)) continue;
            ExcelHelper.setCellValidation(sheet, cell, dropDownVals);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillContent(DataProvider dataProvider, ExportResult exportResult, CountDownLatch latch, SheetInfo sheetInfo, Sheet finalSheet, Map<String, CellStyle> bodyCellStyleMap) {
        try {
            RequestContext ctx = RequestContext.get();
            while (dataProvider.hasNextData(sheetInfo.getDataKey())) {
                DataBatch dataBatch = dataProvider.getNextData(sheetInfo.getDataKey());
                if (dataBatch != null && dataBatch.hasData()) {
                    RequestContext.copyAndSet((RequestContext)ctx);
                    try {
                        ExcelHelper.fillContent(finalSheet, sheetInfo, dataBatch, bodyCellStyleMap, exportResult);
                        continue;
                    }
                    catch (Exception e) {
                        exportResult.addMessage(ResManager.loadKDString((String)"\u6570\u636e\u586b\u5145\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ExcelHelper_6", (String)"sit-sitbp-business", (Object[])new Object[0]));
                        LOGGER.warn("Error occurs when fillContent", (Throwable)e);
                        continue;
                    }
                    finally {
                        dataProvider.completeBatch(dataBatch);
                        continue;
                    }
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when fillSheet", (Throwable)e);
            exportResult.addMessage(ResManager.loadKDString((String)"\u6570\u636e\u586b\u5145\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ExcelHelper_6", (String)"sit-sitbp-business", (Object[])new Object[0]));
        }
        finally {
            latch.countDown();
        }
    }

    private static void fillContent(Sheet sheet, SheetInfo sheetInfo, DataBatch dataBatch, Map<String, CellStyle> bodyCellStyleMap, ExportResult exportResult) {
        int baseRow;
        List<HeadCellInfo> contentHeadList;
        HeadCellBar headCellBar = sheetInfo.getHeadCellBar();
        List dataList = dataBatch.getDataList();
        if (headCellBar == null || CollectionUtils.isEmpty((Collection)dataList) || CollectionUtils.isEmpty(contentHeadList = headCellBar.getContentHeadCellInfoList())) {
            return;
        }
        int currRow = baseRow = dataBatch.getStartIndex() + sheetInfo.getBodyRow();
        int contentRowHeight = headCellBar.getContentRowHeight();
        HashMap<Integer, Integer> startRowOfCol = new HashMap<Integer, Integer>(4);
        Object notEqualValue = new Object();
        int dataSize = dataList.size();
        for (int i = 0; i < dataSize; ++i) {
            Object data = dataList.get(i);
            for (HeadCellInfo headCellInfo : contentHeadList) {
                try {
                    int colNum = headCellInfo.getColNum();
                    String valueProp = headCellInfo.getValueProp();
                    Object currValue = BaseDataConverter.getValueByProp(data, (String)valueProp);
                    CellStyle bodyCellStyle = bodyCellStyleMap.get(headCellInfo.getPosFlag());
                    if (headCellInfo.isMergeRowWithSameValue()) {
                        Object latestValue = i < dataSize - 1 ? BaseDataConverter.getValueByProp(dataList.get(i + 1), (String)valueProp) : notEqualValue;
                        if (ObjectUtils.nullSafeEquals((Object)currValue, (Object)latestValue)) continue;
                        Integer startRow = (Integer)startRowOfCol.get(colNum);
                        int startRowNew = startRow == null ? baseRow : startRow;
                        Cell cell = ExcelHelper.newCell(sheet, startRowNew, colNum, currRow - startRowNew + 1, headCellInfo.getColSpan(), headCellInfo, headCellBar.isHorizontal(), bodyCellStyle);
                        ExcelHelper.setCellValue(cell, currValue, headCellInfo);
                        startRowOfCol.put(colNum, currRow + 1);
                        continue;
                    }
                    Cell cell = ExcelHelper.newCell(sheet, currRow, colNum, 1, headCellInfo.getColSpan(), headCellInfo, headCellBar.isHorizontal(), bodyCellStyle);
                    ExcelHelper.setCellValue(cell, currValue, headCellInfo);
                }
                catch (Exception e) {
                    LOGGER.warn(JSONObject.toJSONString((Object)headCellInfo) + " error By Quinn " + JSONObject.toJSONString(data), (Throwable)e);
                }
            }
            if (contentRowHeight > 0) {
                if (headCellBar.isHorizontal()) {
                    sheet.getRow(currRow).setHeight((short)contentRowHeight);
                } else {
                    sheet.setColumnWidth(currRow, contentRowHeight);
                }
            }
            ++currRow;
            exportResult.incrementAndGet();
        }
    }

    private static void setCellValidation(Sheet sheet, Cell cell, List<String> dropDownVals) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        int lastCellNum = cell.getColumnIndex();
        CellRangeAddressList addressList = new CellRangeAddressList(cell.getRowIndex() + 1, 10000, lastCellNum, lastCellNum);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(dropDownVals.toArray(new String[dropDownVals.size()]));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    private static void setWidthAndHeight(Sheet sheet, HeadCellBar headCellBar, HeadCellInfo cellInfo, int realRow) {
        int width = cellInfo.getWidth();
        short height = cellInfo.getHeight();
        if (headCellBar.isHorizontal()) {
            if (width > 0) {
                sheet.setColumnWidth(cellInfo.getColNum(), width);
            }
            if (height > 0) {
                sheet.getRow(realRow).setHeight(height);
            }
        } else {
            if (width > 0) {
                sheet.getRow(cellInfo.getColNum()).setHeight(((Short)BaseDataConverter.convert((Object)width, Short.class, (Object)0)).shortValue());
            }
            if (height > 0) {
                sheet.setColumnWidth(realRow, (int)height);
            }
        }
    }

    private static Cell newCell(Sheet sheet, int rowNum, int colNum, int rowSpan, int colSpan, HeadCellInfo headCellInfo, boolean horizontal, CellStyle cellStyle) {
        Cell cell;
        Row row;
        if (!horizontal) {
            int temp = rowNum;
            rowNum = colNum;
            colNum = temp;
            temp = rowSpan;
            rowSpan = colSpan;
            colSpan = temp;
        }
        if ((row = sheet.getRow(rowNum)) == null) {
            row = sheet.createRow(rowNum);
        }
        if ((cell = row.getCell(colNum)) == null) {
            cell = row.createCell(colNum);
        }
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
            if (rowSpan > 1 || colSpan > 1) {
                CellRangeAddress region = new CellRangeAddress(rowNum, rowNum + rowSpan - 1, colNum, colNum + colSpan - 1);
                sheet.addMergedRegion(region);
                ExcelHelper.setRangeStyle(region, cellStyle, sheet);
            }
        }
        return cell;
    }

    private static void setCellValue(Cell cell, Object value, HeadCellInfo cellInfo) {
        String dataType = cellInfo.getDataType();
        if (cellInfo.getBodyValueWrapperObj() != null) {
            value = cellInfo.getBodyValueWrapperObj().wrap(value);
        } else if (StringUtils.isNotEmpty((CharSequence)cellInfo.getBodyValueWrapper())) {
            value = ValueWrapper.wrapWith(value, BaseDataConverter.mainClassOf((String)dataType), cellInfo.getBodyValueWrapper());
        }
        if (StringUtils.isEmpty((CharSequence)dataType)) {
            cell.setCellValue(BaseDataConverter.toString((Object)value));
        } else {
            switch (dataType) {
                case "DATE": 
                case "DATE_TIME": {
                    Date convert = (Date)BaseDataConverter.convert((Object)value, Date.class);
                    if (convert == null) break;
                    cell.setCellValue(convert);
                    break;
                }
                case "LOCAL_DATE": {
                    LocalDate convert1 = (LocalDate)BaseDataConverter.convert((Object)value, LocalDate.class);
                    if (convert1 == null) break;
                    cell.setCellValue(convert1);
                    break;
                }
                case "LOCAL_DATE_TIME": {
                    LocalDateTime convert2 = (LocalDateTime)BaseDataConverter.convert((Object)value, LocalDateTime.class);
                    if (convert2 == null) break;
                    cell.setCellValue(convert2);
                    break;
                }
                case "LONG": 
                case "INTEGER": 
                case "SHORT": 
                case "DOUBLE": 
                case "BIG_DECIMAL": {
                    Double convert3 = (Double)BaseDataConverter.convert((Object)value, Double.class);
                    if (convert3 == null) break;
                    cell.setCellValue(convert3.doubleValue());
                    break;
                }
                case "BOOLEAN": {
                    Boolean convert4 = (Boolean)BaseDataConverter.convert((Object)value, Boolean.class);
                    if (convert4 == null) break;
                    cell.setCellValue(convert4.booleanValue());
                    break;
                }
                default: {
                    String string = BaseDataConverter.toString((Object)value);
                    if (string == null) break;
                    cell.setCellValue(string);
                }
            }
        }
    }

    private static void setRangeStyle(CellRangeAddress region, CellStyle cellStyle, Sheet sheet) {
        RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)cellStyle.getBottomBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)cellStyle.getTopBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)cellStyle.getLeftBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)cellStyle.getRightBorderColor(), (CellRangeAddress)region, (Sheet)sheet);
    }

    private static void addCellComment(Cell cell, String comment) {
        Comment cellComment = cell.getCellComment();
        if (cellComment == null) {
            Drawing drawing = cell.getSheet().createDrawingPatriarch();
            ClientAnchor clientAnchor = cell.getSheet().getWorkbook().getCreationHelper().createClientAnchor();
            clientAnchor.setDx1(0);
            clientAnchor.setDy1(0);
            clientAnchor.setDx2(0);
            clientAnchor.setDy2(0);
            clientAnchor.setCol1(cell.getColumnIndex());
            clientAnchor.setRow1(cell.getRowIndex());
            clientAnchor.setCol2(cell.getColumnIndex() + 1);
            clientAnchor.setRow2(cell.getRowIndex() + 1);
            cellComment = drawing.createCellComment(clientAnchor);
            cellComment.setVisible(false);
            cell.setCellComment(cellComment);
        }
        RichTextString richTextString = cell.getSheet().getWorkbook().getCreationHelper().createRichTextString(comment);
        cellComment.setString(richTextString);
        cellComment.setAuthor("kd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Workbook newWorkbook(InputStream inputStream, WorkbookInfo workbookInfo) {
        SXSSFWorkbook sXSSFWorkbook;
        SXSSFWorkbook workbook;
        block22: {
            block20: {
                SXSSFWorkbook sXSSFWorkbook2;
                block21: {
                    if (workbookInfo.getWorkbook() != null) {
                        return workbookInfo.getWorkbook();
                    }
                    workbook = null;
                    if (inputStream == null) {
                        workbook = new SXSSFWorkbook(1);
                        workbookInfo.setWorkbook((Workbook)workbook);
                        return workbook;
                    }
                    GlobalParam.set((String)"useTemplate", (Object)Boolean.TRUE);
                    workbook = WorkbookFactory.create((InputStream)inputStream);
                    if (!(workbook instanceof XSSFWorkbook)) break block20;
                    workbookInfo.ofVersion2007();
                    workbook = new SXSSFWorkbook((XSSFWorkbook)workbook, 10);
                    workbookInfo.setWorkbook((Workbook)workbook);
                    sXSSFWorkbook2 = workbook;
                    if (inputStream == null) break block21;
                    StreamUtil.closeSafely((InputStream[])new InputStream[]{inputStream});
                }
                if (workbook != null) {
                    try {
                        workbook.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return sXSSFWorkbook2;
            }
            try {
                workbookInfo.ofVersion2003();
                workbookInfo.setWorkbook((Workbook)workbook);
                sXSSFWorkbook = workbook;
                if (inputStream == null) break block22;
            }
            catch (IOException e) {
                SXSSFWorkbook sXSSFWorkbook3;
                block23: {
                    try {
                        LOGGER.error("Template file read fail when ExcelHelper.newWorkbook", (Throwable)e);
                        workbook = new SXSSFWorkbook(workbookInfo.getRowAccessWindowSize());
                        workbookInfo.setWorkbook((Workbook)workbook);
                        sXSSFWorkbook3 = workbook;
                        if (inputStream == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            StreamUtil.closeSafely((InputStream[])new InputStream[]{inputStream});
                        }
                        if (workbook != null) {
                            try {
                                workbook.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    StreamUtil.closeSafely((InputStream[])new InputStream[]{inputStream});
                }
                if (workbook != null) {
                    try {
                        workbook.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return sXSSFWorkbook3;
            }
            StreamUtil.closeSafely((InputStream[])new InputStream[]{inputStream});
        }
        if (workbook != null) {
            try {
                workbook.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sXSSFWorkbook;
    }

    private static Sheet newSheet(Workbook wb, SheetInfo sheetInfo) {
        if (sheetInfo.getSheet() != null) {
            return sheetInfo.getSheet();
        }
        Sheet sheet = wb.getSheet(sheetInfo.getName());
        if (sheet == null) {
            sheet = wb.createSheet();
            int sheetIndex = wb.getSheetIndex(sheet);
            wb.setSheetName(sheetIndex, sheetInfo.getName());
        }
        if (sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)sheet).setRandomAccessWindowSize(-1);
        }
        sheetInfo.setSheet(sheet);
        return sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String writeFile(Workbook wb, String fileName) {
        String string;
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            StreamUtil.closeSafely((OutputStream)outStream, (InputStream)inStream);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when writeFile", (Throwable)e);
            String string2 = null;
            return string2;
        }
        try {
            wb.close();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
        finally {
            StreamUtil.closeSafely((OutputStream)outStream, inStream);
            try {
                wb.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeZipFile(Map<String, Workbook> wbMap, String fileName) {
        String string;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        try {
            for (Map.Entry<String, Workbook> entry : wbMap.entrySet()) {
                zos.putNextEntry(new ZipEntry(entry.getKey()));
                entry.getValue().write((OutputStream)zos);
                zos.closeEntry();
            }
            zos.finish();
            string = StreamUtil.writeFile((String)fileName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (IOException e) {
            String string2;
            try {
                LOGGER.warn("Error occurs when writeZipFile", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
                for (Workbook wb : wbMap.values()) {
                    try {
                        wb.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
            for (Workbook wb : wbMap.values()) {
                try {
                    wb.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
        StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
        for (Workbook wb : wbMap.values()) {
            try {
                wb.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeZipFileAndGetSafeURL(String appNumber, String entityNumber, Map<String, Workbook> wbMap, String fileName) {
        String uploadUrl = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        try {
            for (Map.Entry<String, Workbook> entry : wbMap.entrySet()) {
                zos.putNextEntry(new ZipEntry(entry.getKey()));
                entry.getValue().write((OutputStream)zos);
                zos.closeEntry();
            }
            zos.finish();
            uploadUrl = StreamUtil.storeFile((String)fileName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (IOException e) {
            String string;
            try {
                LOGGER.warn("Error occurs when writeZipFileAndGetSafeURL", (Throwable)e);
                string = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
                for (Workbook wb : wbMap.values()) {
                    try {
                        wb.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
            for (Workbook wb : wbMap.values()) {
                try {
                    wb.close();
                }
                catch (Exception exception) {}
            }
            return string;
        }
        StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
        for (Workbook wb : wbMap.values()) {
            try {
                wb.close();
            }
            catch (Exception exception) {}
        }
        return SITURLHelper.getSafeUrl(appNumber, entityNumber, uploadUrl);
    }

    /*
     * Exception decompiling
     */
    public static String storeFile(Workbook wb, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String storeFileAndGetSafeURL(String appNumber, String entityNumber, Workbook wb, String fileName) {
        String uploadUrl = ExcelHelper.storeFile(wb, fileName);
        return SITURLHelper.getSafeUrl(appNumber, entityNumber, uploadUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeZipFile(Map<String, Workbook> wbMap, String fileName) {
        String string;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        try {
            for (Map.Entry<String, Workbook> entry : wbMap.entrySet()) {
                zos.putNextEntry(new ZipEntry(entry.getKey()));
                entry.getValue().write((OutputStream)zos);
                zos.closeEntry();
            }
            zos.finish();
            string = StreamUtil.storeFile((String)fileName, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (IOException e) {
            String string2;
            try {
                LOGGER.warn("Error occurs when storeZipFile", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
                for (Workbook wb : wbMap.values()) {
                    try {
                        wb.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
            for (Workbook wb : wbMap.values()) {
                try {
                    wb.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
        StreamUtil.closeSafely((OutputStream[])new OutputStream[]{zos, outputStream});
        for (Workbook wb : wbMap.values()) {
            try {
                wb.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }
}

