/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.cellstyle;

import java.util.Map;
import kd.bos.extension.ExtensionFactory;
import kd.sit.sitbp.business.helper.excel.cellstyle.BaseCellStyleGenerator;
import kd.sit.sitbp.business.helper.excel.cellstyle.CellStyleGeneratorSupplier;
import kd.sit.sitbp.business.helper.excel.cellstyle.CustomParamCellStyleGenerator;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleFactory {
    private static final ExtensionFactory<CellStyleGeneratorSupplier> SUPPLIER_MAP = ExtensionFactory.getExtensionFacotry(CellStyleGeneratorSupplier.class);

    public static CellStyle generateCellStyle(Workbook wb, Map<String, Object> param, String generatorName) {
        BaseCellStyleGenerator prevGenerator;
        CellStyle cellStyle = wb.createCellStyle();
        if (!StringUtils.isEmpty((CharSequence)generatorName) && (prevGenerator = CellStyleFactory.getGeneratorByName(generatorName, param)) != null) {
            prevGenerator.decorate(cellStyle, wb);
        }
        if (!MapUtils.isEmpty(param)) {
            new CustomParamCellStyleGenerator().ofParams(param).decorate(cellStyle, wb);
        }
        return cellStyle;
    }

    public static CellStyle cloneCellStyle(Workbook wb, CellStyle fromStyle, Map<String, Object> param, String ... generatorNames) {
        CellStyle toStyle = wb.createCellStyle();
        toStyle.setAlignment(fromStyle.getAlignment());
        toStyle.setBorderBottom(fromStyle.getBorderBottom());
        toStyle.setBorderLeft(fromStyle.getBorderLeft());
        toStyle.setBorderRight(fromStyle.getBorderRight());
        toStyle.setBorderTop(fromStyle.getBorderTop());
        toStyle.setTopBorderColor(fromStyle.getTopBorderColor());
        toStyle.setBottomBorderColor(fromStyle.getBottomBorderColor());
        toStyle.setRightBorderColor(fromStyle.getRightBorderColor());
        toStyle.setLeftBorderColor(fromStyle.getLeftBorderColor());
        toStyle.setFillBackgroundColor(fromStyle.getFillBackgroundColor());
        toStyle.setFillForegroundColor(fromStyle.getFillForegroundColor());
        toStyle.setDataFormat(fromStyle.getDataFormat());
        toStyle.setFillPattern(fromStyle.getFillPattern());
        toStyle.setFont(wb.getFontAt(fromStyle.getFontIndexAsInt()));
        toStyle.setHidden(fromStyle.getHidden());
        toStyle.setIndention(fromStyle.getIndention());
        toStyle.setLocked(fromStyle.getLocked());
        toStyle.setRotation(fromStyle.getRotation());
        toStyle.setVerticalAlignment(fromStyle.getVerticalAlignment());
        toStyle.setWrapText(fromStyle.getWrapText());
        CellStyleFactory.decorate(wb, toStyle, param, generatorNames);
        return toStyle;
    }

    public static CellStyle generateCellStyle(Workbook wb, Map<String, Object> param, String ... generatorNames) {
        CellStyle cellStyle = wb.createCellStyle();
        CellStyleFactory.decorate(wb, cellStyle, param, generatorNames);
        return cellStyle;
    }

    public static void decorate(Workbook wb, CellStyle cellStyle, Map<String, Object> param, String[] generatorNames) {
        if (generatorNames != null) {
            for (String name : generatorNames) {
                BaseCellStyleGenerator prevGenerator;
                if (StringUtils.isEmpty((CharSequence)name) || (prevGenerator = CellStyleFactory.getGeneratorByName(name, param)) == null) continue;
                prevGenerator.decorate(cellStyle, wb);
            }
        }
        if (param != null && param.size() > 0) {
            new CustomParamCellStyleGenerator().ofParams(param).decorate(cellStyle, wb);
        }
    }

    private static BaseCellStyleGenerator getGeneratorByName(String name, Map<String, Object> param) {
        CellStyleGeneratorSupplier extension;
        try {
            extension = (CellStyleGeneratorSupplier)SUPPLIER_MAP.getExtension(name);
        }
        catch (Exception e) {
            return null;
        }
        BaseCellStyleGenerator supply = extension.supply();
        if (supply instanceof CustomParamCellStyleGenerator) {
            ((CustomParamCellStyleGenerator)supply).ofParams(param);
        }
        return supply;
    }

    public static Font cloneFont(Font font, Workbook wb, Map<String, Object> fontParams) {
        Font newFont = wb.createFont();
        newFont.setBold(font.getBold());
        newFont.setColor(font.getColor());
        newFont.setItalic(font.getItalic());
        newFont.setCharSet(font.getCharSet());
        newFont.setTypeOffset(font.getTypeOffset());
        newFont.setFontHeight(font.getFontHeight());
        newFont.setFontName(font.getFontName());
        newFont.setStrikeout(font.getStrikeout());
        newFont.setUnderline(font.getUnderline());
        if (fontParams != null && fontParams.size() > 0) {
            for (Map.Entry<String, Object> entry : fontParams.entrySet()) {
                switch (entry.getKey()) {
                    case "bold": {
                        newFont.setBold(((Boolean)BaseDataConverter.convert((Object)entry.getValue(), Boolean.class, (Object)font.getBold())).booleanValue());
                        break;
                    }
                    case "color": {
                        newFont.setColor(((Short)BaseDataConverter.convert((Object)entry.getValue(), Short.class, (Object)font.getColor())).shortValue());
                        break;
                    }
                    case "italic": {
                        newFont.setItalic(((Boolean)BaseDataConverter.convert((Object)entry.getValue(), Boolean.class, (Object)font.getItalic())).booleanValue());
                        break;
                    }
                    case "charSet": {
                        newFont.setCharSet(((Integer)BaseDataConverter.convert((Object)entry.getValue(), Integer.class, (Object)font.getCharSet())).intValue());
                        break;
                    }
                    case "typeOffset": {
                        newFont.setTypeOffset(((Short)BaseDataConverter.convert((Object)entry.getValue(), Short.class, (Object)font.getTypeOffset())).shortValue());
                        break;
                    }
                    case "fontHeight": {
                        newFont.setFontHeight(((Short)BaseDataConverter.convert((Object)entry.getValue(), Short.class, (Object)font.getFontHeight())).shortValue());
                        break;
                    }
                    case "fontName": {
                        newFont.setFontName((String)BaseDataConverter.convert((Object)entry.getValue(), String.class, (Object)font.getFontName()));
                        break;
                    }
                    case "strikeout": {
                        newFont.setStrikeout(((Boolean)BaseDataConverter.convert((Object)entry.getValue(), Boolean.class, (Object)font.getStrikeout())).booleanValue());
                        break;
                    }
                    case "underline": {
                        newFont.setUnderline(((Byte)BaseDataConverter.convert((Object)entry.getValue(), Byte.class, (Object)font.getUnderline())).byteValue());
                        break;
                    }
                }
            }
        }
        return newFont;
    }
}

