/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.cellstyle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.sit.sitbp.business.helper.excel.cellstyle.BaseCellStyleGenerator;
import kd.sit.sitbp.business.helper.excel.cellstyle.CellStyleFactory;
import kd.sit.sitbp.business.helper.excel.cellstyle.CellStyleGeneratorSupplier;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class CustomParamCellStyleGenerator
extends BaseCellStyleGenerator {
    private Map<String, Object> params;
    private Map<String, Object> fontParams;

    public CustomParamCellStyleGenerator ofParams(Map<String, Object> params) {
        this.params = params;
        if (params != null) {
            this.fontParams = new HashMap<String, Object>(params.size());
            HashSet<String> specKey = new HashSet<String>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("font.")) continue;
                this.fontParams.put(key.substring(5), entry.getValue());
                specKey.add(key);
            }
            params.keySet().removeAll(specKey);
        }
        return this;
    }

    @Override
    protected void doDecorate(CellStyle cellStyle, Workbook wb) {
        if (this.params == null) {
            return;
        }
        Object dataFormat = this.params.get("dataFormat");
        if (dataFormat instanceof String) {
            DataFormat format = wb.createDataFormat();
            cellStyle.setDataFormat(format.getFormat((String)dataFormat));
        }
        if (this.fontParams != null && this.fontParams.size() > 0) {
            Font font = wb.getFontAt(cellStyle.getFontIndexAsInt());
            Font newFont = CellStyleFactory.cloneFont(font, wb, this.fontParams);
            cellStyle.setFont(newFont);
        }
    }

    public static class Supplier
    implements CellStyleGeneratorSupplier {
        @Override
        public BaseCellStyleGenerator supply() {
            return new CustomParamCellStyleGenerator();
        }
    }
}

