/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.cellstyle;

import kd.sit.sitbp.business.helper.excel.cellstyle.BaseCellStyleGenerator;
import kd.sit.sitbp.business.helper.excel.cellstyle.CellStyleGeneratorSupplier;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class DateTimeColumnCellStyleGenerator
extends BaseCellStyleGenerator {
    @Override
    protected void doDecorate(CellStyle cellStyle, Workbook wb) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "yyyy-MM-dd HH:mm:ss";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    public static class Supplier
    implements CellStyleGeneratorSupplier {
        private static final DateTimeColumnCellStyleGenerator INST = new DateTimeColumnCellStyleGenerator();

        @Override
        public BaseCellStyleGenerator supply() {
            return INST;
        }
    }
}

