/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.cellstyle;

import kd.sit.sitbp.business.helper.excel.cellstyle.BaseCellStyleGenerator;
import kd.sit.sitbp.business.helper.excel.cellstyle.BodyColumnCellStyleGenerator;
import kd.sit.sitbp.business.helper.excel.cellstyle.CellStyleGeneratorSupplier;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class ImportHeadColumnCellStyleGenerator
extends BaseCellStyleGenerator {
    public ImportHeadColumnCellStyleGenerator() {
        this.ofGenerator(new BodyColumnCellStyleGenerator());
    }

    @Override
    protected void doDecorate(CellStyle cellStyle, Workbook wb) {
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        Font font = wb.createFont();
        font.setBold(true);
        cellStyle.setFont(font);
        cellStyle.setHidden(true);
    }

    public static class Supplier
    implements CellStyleGeneratorSupplier {
        private static final ImportHeadColumnCellStyleGenerator INST = new ImportHeadColumnCellStyleGenerator();

        @Override
        public BaseCellStyleGenerator supply() {
            return INST;
        }
    }
}

