/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.model;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class ExportResult {
    private AtomicInteger dealNum;
    private CopyOnWriteArrayList<String> messageList;

    public ExportResult(Integer dealNum) {
        this.dealNum = new AtomicInteger(dealNum);
        this.messageList = new CopyOnWriteArrayList();
    }

    public void reset(int num) {
        this.dealNum.set(num);
    }

    public int dealNum() {
        return this.dealNum.intValue();
    }

    public String generateMessage(int length) {
        StringBuilder query = new StringBuilder();
        for (String msg : this.messageList) {
            query.append(msg);
            if (query.length() <= length) continue;
            query.delete(length - 1, query.length());
            return query.toString();
        }
        return query.toString();
    }

    public int incrementAndGet() {
        return this.dealNum.incrementAndGet();
    }

    public void addMessage(String message) {
        this.messageList.add(message);
    }

    public AtomicInteger getDealNum() {
        return this.dealNum;
    }

    public void setDealNum(AtomicInteger dealNum) {
        this.dealNum = dealNum;
    }

    public CopyOnWriteArrayList<String> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(CopyOnWriteArrayList<String> messageList) {
        this.messageList = messageList;
    }
}

