/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.inte.api.IInteService;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.helper.valuewrapper.ValueWrapper;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;
import org.apache.commons.collections.MapUtils;

public class WorkbookBillList
implements WorkbookInfoGenerator {
    @Override
    public WorkbookInfo generate(Map<String, Object> param) {
        Map sheetInfos = (Map)param.get("sheetInfos");
        if (MapUtils.isEmpty((Map)sheetInfos)) {
            return null;
        }
        HashMap ignoreFields = (HashMap)param.get("ignoreFields");
        if (ignoreFields == null) {
            ignoreFields = new HashMap(0);
        }
        WorkbookInfo workbookInfo = new WorkbookInfo();
        String fileName = MapUtils.getString(param, (Object)"fileName");
        workbookInfo.setFileName(fileName);
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        long currUserId = RequestContext.get().getCurrUserId();
        String dateFormat = service.getDateFormat(Long.valueOf(currUserId));
        Map timeFormatMap = service.getTimeFormat(Long.valueOf(currUserId));
        String timeFormat = timeFormatMap == null ? "HH:mm:ss" : (String)timeFormatMap.get("timeFormat");
        ArrayList<SheetInfo> sheetInfoList = new ArrayList<SheetInfo>(sheetInfos.size());
        for (Map.Entry entry : sheetInfos.entrySet()) {
            HashMap<String, Map> mapMap;
            SheetInfo sheetInfo = new SheetInfo();
            sheetInfoList.add(sheetInfo);
            sheetInfo.setName((String)entry.getKey());
            sheetInfo.setDataKey((String)entry.getKey());
            List ignoreField = (List)ignoreFields.get(entry.getKey());
            if (ignoreField == null) {
                ignoreField = Collections.emptyList();
            }
            BillList billList = (BillList)entry.getValue();
            sheetInfo.setBodyRow(1);
            String setting = UserConfigServiceHelper.getSetting((long)currUserId, (String)billList.getBillFormId());
            if (!StringUtils.isEmpty((CharSequence)setting)) {
                List columnsConfig = SerializationUtils.fromJsonStringToList((String)setting, Map.class);
                mapMap = new HashMap(columnsConfig.size());
                for (Object col : columnsConfig) {
                    Map map = (Map)col;
                    mapMap.put(BaseDataConverter.toString(map.get("listFieldKey")), map);
                }
            } else {
                mapMap = new HashMap<String, Map>(0);
            }
            List showListColumns = billList.getShowListColumns();
            HeadCellBar headCellBar = new HeadCellBar();
            sheetInfo.setHeadCellBar(headCellBar);
            for (IListColumn field : showListColumns) {
                Integer visible;
                String listFieldKey = field.getListFieldKey();
                if (ignoreField.contains(listFieldKey)) continue;
                Map map = (Map)mapMap.get(listFieldKey);
                if (map != null) {
                    visible = (Integer)BaseDataConverter.convert(map.get("visible"), Integer.class);
                    if (Integer.valueOf(10).equals(visible) || Integer.valueOf(0).equals(visible)) continue;
                }
                if (field.getVisible() == 0 && (map == null || (visible = (Integer)BaseDataConverter.convert(map.get("visible"), Integer.class)) == null || Integer.valueOf(10).equals(visible) || Integer.valueOf(0).equals(visible))) continue;
                HeadCellInfo headCellInfo = new HeadCellInfo();
                headCellInfo.setDefaultDesc(field.getCaption().getLocaleValue());
                headCellInfo.setValueProp(listFieldKey);
                if (field instanceof DecimalListColumn) {
                    headCellInfo.setDataType(DataTypeEnum.BIG_DECIMAL.name());
                    headCellInfo.setBaseFormat(((DecimalListColumn)field).getDisplayFormatString());
                }
                if (null == field.getEntityName()) {
                    headCellBar.addHeadCellInfos(headCellInfo);
                    continue;
                }
                final IDataEntityProperty property = this.leafProperty(field.getEntityName(), listFieldKey);
                if (property instanceof DateTimeProp) {
                    headCellInfo.setDataType(DataTypeEnum.STRING.name());
                    headCellInfo.setBodyValueWrapperObj(new ValueWrapper<Object, Object>(){

                        @Override
                        public Class srcClass() {
                            return Date.class;
                        }

                        @Override
                        public Object wrap(Object value) {
                            return SITInteDateTimeUtil.formatDateByFieldProp((Date)((Date)BaseDataConverter.convert((Object)value, Date.class)), (DateTimeProp)((DateTimeProp)property));
                        }
                    });
                }
                headCellBar.addHeadCellInfos(headCellInfo);
            }
        }
        workbookInfo.setSheetInfoList(sheetInfoList);
        workbookInfo.ready();
        return workbookInfo;
    }

    private IDataEntityProperty leafProperty(String entityName, String propChain) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String[] props = propChain.split("\\.");
        for (int i = 0; i < props.length - 1; ++i) {
            IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)props[i]);
            if (!(property instanceof BasedataProp)) {
                return null;
            }
            entityType = ((BasedataProp)property).getComplexType();
        }
        return (IDataEntityProperty)entityType.getProperties().get((Object)props[props.length - 1]);
    }
}

