/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.model;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.stream.InputStreamLoader;
import kd.sit.sitbp.business.helper.stream.StreamLoaderName;
import org.apache.poi.ss.usermodel.Workbook;

public class WorkbookInfo
implements Serializable {
    private static final long serialVersionUID = -8825198748413003932L;
    public static final String EXTENSION_NAME_2003 = ".xls";
    public static final String EXTENSION_NAME_2007 = ".xlsx";
    private int rowAccessWindowSize = 120;
    private String extensionName = ".xlsx";
    private String fileName;
    private List<SheetInfo> sheetInfoList;
    private boolean ready;
    private boolean needTemplate;
    private Map<String, List<?>> dataListMap;
    private String resourceType;
    private String url;
    private Workbook workbook;

    public String fullName() {
        return this.fileName + this.extensionName;
    }

    public String fullName(String fileName) {
        return fileName + this.extensionName;
    }

    public boolean ready() {
        this.ready = true;
        for (SheetInfo sheetInfo : this.sheetInfoList) {
            if (sheetInfo.ready()) continue;
            this.ready = false;
            return false;
        }
        this.ready = true;
        return true;
    }

    public void setResource(StreamLoaderName streamLoaderName, String url) {
        if (streamLoaderName == null) {
            this.setResourceType(null);
            this.setUrl(null);
        } else {
            this.setResourceType(streamLoaderName.getSpiName());
            this.setUrl(url);
        }
    }

    public InputStream getResource() {
        return InputStreamLoader.loadWith(this.getResourceType(), this.getUrl());
    }

    public boolean hasResource() {
        return StringUtils.isNotEmpty((CharSequence)this.getResourceType()) && StringUtils.isNotEmpty((CharSequence)this.getUrl());
    }

    public WorkbookInfo ofVersion2007() {
        this.setExtensionName(EXTENSION_NAME_2007);
        return this;
    }

    public WorkbookInfo ofVersion2003() {
        this.setExtensionName(EXTENSION_NAME_2003);
        return this;
    }

    public SheetInfo getSheetInfo(String dataKey) {
        for (SheetInfo sheetInfo : this.sheetInfoList) {
            if (!Objects.equals(dataKey, sheetInfo.getDataKey())) continue;
            return sheetInfo;
        }
        return null;
    }

    public int getRowAccessWindowSize() {
        return this.rowAccessWindowSize;
    }

    public void setRowAccessWindowSize(int rowAccessWindowSize) {
        this.rowAccessWindowSize = rowAccessWindowSize;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<SheetInfo> getSheetInfoList() {
        return this.sheetInfoList;
    }

    public void setSheetInfoList(List<SheetInfo> sheetInfoList) {
        this.sheetInfoList = sheetInfoList;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public Map<String, List<?>> getDataListMap() {
        return this.dataListMap;
    }

    public void setDataListMap(Map<String, List<?>> dataListMap) {
        this.dataListMap = dataListMap;
    }

    public boolean isNeedTemplate() {
        return this.needTemplate;
    }

    public void setNeedTemplate(boolean needTemplate) {
        this.needTemplate = needTemplate;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }
}

