/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.excel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.BillList;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListGridView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.ListItemElement;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.collections.MapUtils;

public class WorkbookMultiHeadBillList
implements WorkbookInfoGenerator {
    @Override
    public WorkbookInfo generate(Map<String, Object> param) {
        Map sheetInfos = (Map)param.get("sheetInfos");
        if (MapUtils.isEmpty((Map)sheetInfos)) {
            return null;
        }
        HashMap ignoreFields = (HashMap)param.get("ignoreFields");
        if (ignoreFields == null) {
            ignoreFields = new HashMap(0);
        }
        WorkbookInfo workbookInfo = new WorkbookInfo();
        String fileName = MapUtils.getString(param, (Object)"fileName");
        workbookInfo.setFileName(fileName);
        ArrayList<SheetInfo> sheetInfoList = new ArrayList<SheetInfo>(sheetInfos.size());
        for (Map.Entry entry : sheetInfos.entrySet()) {
            HashMap<String, Map> mapMap;
            GlobalParam.remove((String)"ignoreField");
            GlobalParam.remove((String)"mapMap");
            SheetInfo sheetInfo = new SheetInfo();
            sheetInfoList.add(sheetInfo);
            sheetInfo.setName((String)entry.getKey());
            sheetInfo.setDataKey((String)entry.getKey());
            List ignoreField = (List)ignoreFields.get(entry.getKey());
            if (ignoreField == null) {
                ignoreField = Collections.emptyList();
            }
            GlobalParam.set((String)"ignoreField", ignoreField);
            BillList billList = (BillList)entry.getValue();
            String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)billList.getBillFormId());
            if (!StringUtils.isEmpty((CharSequence)setting)) {
                List columnsConfig = SerializationUtils.fromJsonStringToList((String)setting, Map.class);
                mapMap = new HashMap(columnsConfig.size());
                for (Object col : columnsConfig) {
                    Map map = (Map)col;
                    mapMap.put(BaseDataConverter.toString(map.get("listFieldKey")), map);
                }
            } else {
                mapMap = new HashMap<String, Map>(0);
            }
            GlobalParam.set((String)"mapMap", mapMap);
            List items = billList.getItems();
            ArrayList<ListItemElement> allListItemElements = new ArrayList<ListItemElement>(10);
            int row = 0;
            int columnSpan = 1;
            int rowSpan = 1;
            for (Control item : items) {
                if (!(item instanceof ListGridView)) continue;
                List parentItems = ((ListGridView)item).getItems();
                for (Control parentItem : parentItems) {
                    boolean ignore;
                    if (!(parentItem instanceof ListColumnGroup)) {
                        ignore = this.ignoreField(parentItem);
                        if (ignore) continue;
                        int tempCol = 0;
                        for (ListItemElement listItemElement : allListItemElements) {
                            if (listItemElement.getParentListItemElement() != null) continue;
                            tempCol = listItemElement.getHeadCellInfo().getColSpan() + tempCol;
                        }
                        ListItemElement listItemElement = new ListItemElement(parentItem);
                        allListItemElements.add(listItemElement);
                        HeadCellInfo headCellInfo = new HeadCellInfo();
                        String localeValue = ((AbstractListColumn)parentItem).getCaption().getLocaleValue();
                        String listFieldKey = ((AbstractListColumn)parentItem).getListFieldKey();
                        headCellInfo.setDefaultDesc(localeValue);
                        headCellInfo.setColNum(tempCol);
                        headCellInfo.setValueProp(listFieldKey);
                        headCellInfo.setRowNum(row);
                        headCellInfo.setColSpan(columnSpan);
                        headCellInfo.setRowSpan(rowSpan);
                        listItemElement.setHeadCellInfo(headCellInfo);
                        continue;
                    }
                    ignore = this.ignoreField(parentItem);
                    if (ignore) continue;
                    List childItems = ((ListColumnGroup)parentItem).getItems();
                    int tempCol = 0;
                    for (ListItemElement listItemElement : allListItemElements) {
                        if (listItemElement.getParentListItemElement() != null) continue;
                        tempCol = listItemElement.getHeadCellInfo().getColSpan() + tempCol;
                    }
                    ListItemElement parentListItemElement = new ListItemElement(parentItem);
                    allListItemElements.add(parentListItemElement);
                    HeadCellInfo headCellInfo = new HeadCellInfo();
                    String localeValue = ((ListColumnGroup)parentItem).getName().getLocaleValue();
                    headCellInfo.setDefaultDesc(localeValue);
                    headCellInfo.setColNum(tempCol);
                    headCellInfo.setRowNum(row);
                    headCellInfo.setColSpan(columnSpan);
                    headCellInfo.setRowSpan(rowSpan);
                    parentListItemElement.setHeadCellInfo(headCellInfo);
                    for (Control childItem : childItems) {
                        this.iterateChildItems(childItem, parentListItemElement, allListItemElements);
                    }
                }
            }
            int maxDeep = this.fixRowSpan(allListItemElements);
            sheetInfo.setBodyRow(maxDeep + 1);
            HeadCellBar headCellBar = new HeadCellBar();
            sheetInfo.setHeadCellBar(headCellBar);
            for (ListItemElement listItemElement : allListItemElements) {
                HeadCellInfo headCellInfo = listItemElement.getHeadCellInfo();
                headCellBar.addHeadCellInfos(headCellInfo);
            }
        }
        workbookInfo.setSheetInfoList(sheetInfoList);
        workbookInfo.ready();
        return workbookInfo;
    }

    private int fixRowSpan(List<ListItemElement> allListItemElements) {
        for (ListItemElement listItemElement : allListItemElements) {
            int nodeDeepth = this.getNodeDeepth(listItemElement, 0);
            listItemElement.setDeep(nodeDeepth);
        }
        int maxDeep = 0;
        for (ListItemElement listItemElement : allListItemElements) {
            maxDeep = Math.max(listItemElement.getDeep(), maxDeep);
        }
        for (ListItemElement listItemElement : allListItemElements) {
            if (listItemElement.getControl() instanceof ListColumnGroup) continue;
            listItemElement.getHeadCellInfo().setRowSpan(maxDeep - listItemElement.getDeep() + 1);
        }
        return maxDeep;
    }

    private int getNodeDeepth(ListItemElement listItemElement, int deep) {
        if (listItemElement.getParentListItemElement() == null) {
            return deep;
        }
        return this.getNodeDeepth(listItemElement.getParentListItemElement(), ++deep);
    }

    private void iterateChildItems(Control childItem, ListItemElement parentListItemElement, List<ListItemElement> allListItemElements) {
        if (this.ignoreField(childItem)) {
            return;
        }
        if (!(childItem instanceof ListColumnGroup)) {
            ListItemElement listItemElement = new ListItemElement(childItem);
            allListItemElements.add(listItemElement);
            HeadCellInfo headCellInfo = new HeadCellInfo();
            String localeValue = ((AbstractListColumn)childItem).getCaption().getLocaleValue();
            headCellInfo.setDefaultDesc(localeValue);
            String listFieldKey = ((AbstractListColumn)childItem).getListFieldKey();
            headCellInfo.setValueProp(listFieldKey);
            if (CollectionUtils.isEmpty(parentListItemElement.getChildListItemElements())) {
                headCellInfo.setColNum(parentListItemElement.getHeadCellInfo().getColNum());
            } else {
                headCellInfo.setColNum(parentListItemElement.getHeadCellInfo().getColNum() + parentListItemElement.getHeadCellInfo().getColSpan());
            }
            headCellInfo.setRowNum(parentListItemElement.getHeadCellInfo().getRowNum() + 1);
            headCellInfo.setColSpan(1);
            headCellInfo.setRowSpan(1);
            listItemElement.setHeadCellInfo(headCellInfo);
            listItemElement.setParentListItemElement(parentListItemElement);
            parentListItemElement.addChildListItemElement(listItemElement);
            if (listItemElement.getParentListItemElement() != null) {
                this.setItemColumnSpan(listItemElement, listItemElement.getParentListItemElement());
            }
        } else {
            List childItems = ((ListColumnGroup)childItem).getItems();
            ListItemElement childListItemElement = new ListItemElement(childItem);
            allListItemElements.add(childListItemElement);
            HeadCellInfo headCellInfo = new HeadCellInfo();
            String localeValue = ((ListColumnGroup)childItem).getName().getLocaleValue();
            headCellInfo.setDefaultDesc(localeValue);
            if (CollectionUtils.isEmpty(parentListItemElement.getChildListItemElements())) {
                headCellInfo.setColNum(parentListItemElement.getHeadCellInfo().getColNum());
            } else {
                headCellInfo.setColNum(parentListItemElement.getHeadCellInfo().getColNum() + parentListItemElement.getHeadCellInfo().getColSpan());
            }
            headCellInfo.setRowNum(parentListItemElement.getHeadCellInfo().getRowNum() + 1);
            headCellInfo.setColSpan(1);
            headCellInfo.setRowSpan(1);
            childListItemElement.setHeadCellInfo(headCellInfo);
            childListItemElement.setParentListItemElement(parentListItemElement);
            parentListItemElement.addChildListItemElement(childListItemElement);
            for (Control childControl : childItems) {
                this.iterateChildItems(childControl, childListItemElement, allListItemElements);
            }
        }
    }

    private void setItemColumnSpan(ListItemElement itemElement, ListItemElement parentListItemElement) {
        if (parentListItemElement != null) {
            if (parentListItemElement.getChildListItemElements().size() > 1) {
                int colSpan = parentListItemElement.getHeadCellInfo().getColSpan();
                parentListItemElement.getHeadCellInfo().setColSpan(colSpan + 1);
            } else if (parentListItemElement.getChildListItemElements().size() == 1 && itemElement.getControl() instanceof ListColumnGroup) {
                int colSpan = itemElement.getHeadCellInfo().getColSpan();
                parentListItemElement.getHeadCellInfo().setColSpan(colSpan);
            }
            if (parentListItemElement.getParentListItemElement() != null) {
                this.setItemColumnSpan(parentListItemElement, parentListItemElement.getParentListItemElement());
            }
        }
    }

    private boolean ignoreField(Control item) {
        List ignoreField = (List)GlobalParam.get((String)"ignoreField");
        Map mapMap = (Map)GlobalParam.get((String)"mapMap");
        if (!(item instanceof ListColumnGroup)) {
            String listFieldKey = ((AbstractListColumn)item).getListFieldKey();
            if (((AbstractListColumn)item).getVisible() == 0 || ignoreField.contains(listFieldKey)) {
                return true;
            }
            Map map = (Map)mapMap.get(listFieldKey);
            if (map != null) {
                Integer visible = (Integer)BaseDataConverter.convert(map.get("visible"), Integer.class);
                if (Integer.valueOf(10).equals(visible) || Integer.valueOf(0).equals(visible)) {
                    return true;
                }
            }
            return false;
        }
        String listFieldKey = ((ListColumnGroup)item).getKey();
        if (((ListColumnGroup)item).getVisible() == 0 || ignoreField.contains(listFieldKey)) {
            return true;
        }
        Map map = (Map)mapMap.get(listFieldKey);
        if (map != null) {
            Integer visible = (Integer)BaseDataConverter.convert(map.get("visible"), Integer.class);
            if (Integer.valueOf(10).equals(visible) || Integer.valueOf(0).equals(visible)) {
                return true;
            }
        }
        return false;
    }
}

