/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.field;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.helper.field.FieldPropertyDTO;
import kd.sit.sitbp.business.helper.field.SpecialFieldTypeHelper;

public class GetEntityDataHelper {
    private static final Log log = LogFactory.getLog(GetEntityDataHelper.class);

    private GetEntityDataHelper() {
    }

    public static List<Map<String, Object>> getEntityData(String entityName, String selectFields, QFilter filter, String orderBys) {
        HashMap<String, Map<String, FieldPropertyDTO>> resultFieldMap;
        DataEntityPropertyCollection properties;
        Set<String> entityProperties;
        boolean isInvalid;
        selectFields = StringUtils.trimAllWhitespace((String)selectFields);
        boolean bl = isInvalid = HRStringUtils.isEmpty((String)entityName) || HRStringUtils.isEmpty((String)selectFields) || filter == null;
        if (isInvalid) {
            log.info("GetEntityDataHelper.getEntityData: PARAMS_INVALID, entityName is {}, selectFields is {}, filter is {}", new Object[]{entityName, selectFields, filter == null ? "null" : filter.toString()});
            return new ArrayList<Map<String, Object>>(0);
        }
        String[] fields = selectFields.split(",");
        LinkedHashSet queryFields = Sets.newLinkedHashSet(Arrays.asList(fields));
        Map<String, List<String>> fieldGroupMap = GetEntityDataHelper.groupField(queryFields, entityProperties = (properties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties()).stream().filter(property -> property instanceof EntryProp).map(IMetadata::getName).collect(Collectors.toSet()), entityName);
        StringJoiner selectProperties = GetEntityDataHelper.filterInvalidProperties(fieldGroupMap, entityName, resultFieldMap = new HashMap<String, Map<String, FieldPropertyDTO>>(fieldGroupMap.size()));
        if (selectProperties.length() == 0) {
            log.info("GetEntityDataHelper.getEntityData: SQL_SELECT_FIELD_INVALID, selectProperties is {}.", (Object)selectProperties.toString());
            return new ArrayList<Map<String, Object>>(0);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        Object[] entityInfoDys = HRStringUtils.isNotEmpty((String)orderBys) ? helper.query(selectProperties.toString(), filter.toArray(), orderBys) : helper.query(selectProperties.toString(), filter.toArray());
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(entityInfoDys.length);
        if (ArrayUtils.isEmpty((Object[])entityInfoDys)) {
            return results;
        }
        for (Object personInfoDy : entityInfoDys) {
            LinkedHashMap<String, Object> resultData = new LinkedHashMap<String, Object>(16);
            GetEntityDataHelper.setResultMap(resultData, (Map)resultFieldMap.get(entityName), (DynamicObject)personInfoDy);
            for (String entityProperty : entityProperties) {
                Map fieldPropertyDTOMap = (Map)resultFieldMap.get(entityProperty);
                GetEntityDataHelper.setEntryEntityData((DynamicObject)personInfoDy, entityProperty, fieldPropertyDTOMap, resultData);
            }
            if (resultData.isEmpty()) continue;
            results.add(resultData);
        }
        return results;
    }

    private static void setEntryEntityData(DynamicObject entityInfoDy, String entityProperty, Map<String, FieldPropertyDTO> fieldPropertyDTOMap, Map<String, Object> resultData) {
        if (!CollectionUtils.isEmpty(fieldPropertyDTOMap) && !entityInfoDy.getDynamicObjectCollection(entityProperty).isEmpty()) {
            DynamicObjectCollection entryEntity = entityInfoDy.getDynamicObjectCollection(entityProperty);
            List entryEntityList = (List)resultData.computeIfAbsent(entityProperty, key -> new ArrayList(entryEntity.size()));
            for (DynamicObject entryEntityDy : entryEntity) {
                LinkedHashMap<String, Object> entityData = new LinkedHashMap<String, Object>(entryEntity.size());
                GetEntityDataHelper.setResultMap(entityData, fieldPropertyDTOMap, entryEntityDy);
                if (CollectionUtils.isEmpty(entityData)) continue;
                entryEntityList.add(entityData);
            }
        }
    }

    private static StringJoiner filterInvalidProperties(Map<String, List<String>> fieldGroupMap, String entityName, Map<String, Map<String, FieldPropertyDTO>> resultFieldMap) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        StringJoiner selectFields = new StringJoiner(",");
        for (Map.Entry<String, List<String>> fieldGroupEntry : fieldGroupMap.entrySet()) {
            boolean isMainInfo = HRStringUtils.equals((String)entityName, (String)fieldGroupEntry.getKey());
            List<String> tmpFields = fieldGroupEntry.getValue();
            if (tmpFields == null || tmpFields.isEmpty()) continue;
            MainEntityType dynamicObjectType = dataEntityType;
            if (!isMainInfo) {
                EntryProp iDataEntityProperty = (EntryProp)dataEntityType.getProperties().get((Object)fieldGroupEntry.getKey());
                dynamicObjectType = iDataEntityProperty.getDynamicCollectionItemPropertyType();
            }
            List<FieldPropertyDTO> fieldPropertyDTOS = SpecialFieldTypeHelper.filterInvalidProperties((DynamicObjectType)dynamicObjectType, new LinkedHashSet<String>(tmpFields));
            Map<String, FieldPropertyDTO> fieldAndFieldPropertyDTOMap = fieldPropertyDTOS.stream().filter(FieldPropertyDTO::isValidField).collect(Collectors.toMap(FieldPropertyDTO::getSrcFieldKey, fieldPropertyDTO -> fieldPropertyDTO, (oldVal, newVal) -> oldVal));
            Map tmpFieldAndFieldPropertyDTOMap = resultFieldMap.computeIfAbsent(fieldGroupEntry.getKey(), key -> new LinkedHashMap(tmpFields.size()));
            for (String tmpField : tmpFields) {
                FieldPropertyDTO fieldPropertyDTO2 = fieldAndFieldPropertyDTOMap.get(tmpField);
                if (fieldPropertyDTO2 == null) continue;
                String tmpSelectProp = isMainInfo || fieldPropertyDTO2.isBaseType() ? fieldPropertyDTO2.getFieldKey() : fieldGroupEntry.getKey() + "." + fieldPropertyDTO2.getFieldKey();
                selectFields.add(tmpSelectProp);
                tmpFieldAndFieldPropertyDTOMap.put(tmpField, fieldPropertyDTO2);
            }
        }
        return selectFields;
    }

    private static Map<String, List<String>> groupField(Set<String> queryFields, Set<String> entityProperties, String entityName) {
        LinkedHashMap<String, List<String>> fieldGroupMap = new LinkedHashMap<String, List<String>>(16);
        for (String queryField : queryFields) {
            String[] split;
            if (HRStringUtils.isEmpty((String)queryField) || (split = queryField.split("\\.")).length <= 0 || HRStringUtils.isEmpty((String)split[0])) continue;
            if (entityProperties.contains(split[0]) && split.length > 1) {
                GetEntityDataHelper.getEntryEntitySelectFields(fieldGroupMap, split);
                continue;
            }
            fieldGroupMap.computeIfAbsent(entityName, key -> new ArrayList(10)).add(queryField);
        }
        return fieldGroupMap;
    }

    private static void getEntryEntitySelectFields(Map<String, List<String>> fieldGroupMap, String[] split) {
        StringJoiner tmpSj = new StringJoiner(".");
        for (int i = 1; i < split.length; ++i) {
            if (HRStringUtils.isEmpty((String)split[i])) {
                return;
            }
            tmpSj.add(split[i]);
        }
        fieldGroupMap.computeIfAbsent(split[0], key -> new ArrayList(10)).add(tmpSj.toString());
    }

    private static void setResultMap(Map<String, Object> data, Map<String, FieldPropertyDTO> fieldPropertyDTOMap, DynamicObject infoDy) {
        if (fieldPropertyDTOMap != null && fieldPropertyDTOMap.size() > 0) {
            for (Map.Entry<String, FieldPropertyDTO> fieldPropertyDTOEntry : fieldPropertyDTOMap.entrySet()) {
                FieldPropertyDTO fieldPropertyDTO = fieldPropertyDTOEntry.getValue();
                if (fieldPropertyDTO == null) continue;
                Object value = fieldPropertyDTO.getData(infoDy);
                data.put(fieldPropertyDTO.getFieldKey(), value);
            }
        }
    }
}

