/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.field;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.helper.field.FieldPropertyDTO;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class SpecialFieldTypeHelper {
    private static final Log log = LogFactory.getLog(SpecialFieldTypeHelper.class);

    public static List<FieldPropertyDTO> filterInvalidProperties(DynamicObjectType dataEntityType, Set<String> allFieldKeySet) {
        List<FieldPropertyDTO> fieldPropertyDTOS = SpecialFieldTypeHelper.recombineFields(allFieldKeySet);
        SpecialFieldTypeHelper.filterValidProperties(dataEntityType, fieldPropertyDTOS);
        return fieldPropertyDTOS;
    }

    private static List<FieldPropertyDTO> recombineFields(Set<String> allFieldKeySet) {
        if (allFieldKeySet == null || allFieldKeySet.isEmpty()) {
            return new ArrayList<FieldPropertyDTO>(0);
        }
        List sortedFields = allFieldKeySet.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        ArrayList<FieldPropertyDTO> fieldPropertyDTOS = new ArrayList<FieldPropertyDTO>(sortedFields.size());
        for (String fieldKey : sortedFields) {
            String[] subFieldKeys;
            if (!HRStringUtils.isNotEmpty((String)(fieldKey = StringUtils.trimWhitespace((String)fieldKey)))) continue;
            FieldPropertyDTO fieldPropertyDTO = new FieldPropertyDTO(fieldKey);
            LinkedList<String> fieldKeyLinked = new LinkedList<String>();
            for (String subFieldKey : subFieldKeys = fieldKey.split("\\.")) {
                fieldKeyLinked.add(subFieldKey.trim());
            }
            fieldPropertyDTO.setFieldKeyLinked(fieldKeyLinked);
            fieldPropertyDTOS.add(fieldPropertyDTO);
        }
        return fieldPropertyDTOS;
    }

    private static void filterValidProperties(DynamicObjectType dynamicObjectType, List<FieldPropertyDTO> fieldPropertyDTOS) {
        if (CollectionUtils.isEmpty(fieldPropertyDTOS)) {
            return;
        }
        Map<String, IDataEntityProperty> fieldAndPropertyMap = SpecialFieldTypeHelper.getFieldAndPropertyMap((IDataEntityType)dynamicObjectType);
        for (FieldPropertyDTO fieldPropertyDTO : fieldPropertyDTOS) {
            LinkedList<String> fieldKeyLinked = fieldPropertyDTO.getFieldKeyLinked();
            IDataEntityProperty iDataEntityProperty = fieldAndPropertyMap.get(fieldKeyLinked.getFirst());
            if (iDataEntityProperty == null || iDataEntityProperty instanceof MulBasedataProp || iDataEntityProperty instanceof EntryProp || iDataEntityProperty instanceof SubEntryProp) {
                fieldPropertyDTO.setValidField(false);
                log.error("SpecialFieldTypeHelper.setDataType: iDataEntityProperty is {}", (Object)(iDataEntityProperty != null ? "MulBasedataProp" : null));
                continue;
            }
            if (iDataEntityProperty instanceof BasedataProp) {
                IDataEntityType complexType = ((BasedataProp)iDataEntityProperty).getComplexType();
                if (complexType == null || complexType.getProperties().isEmpty()) {
                    fieldPropertyDTO.setValidField(false);
                    continue;
                }
                fieldPropertyDTO.setBaseType(true);
                fieldKeyLinked.removeFirst();
                SpecialFieldTypeHelper.setFieldPropertyDTO(fieldPropertyDTO);
                SpecialFieldTypeHelper.setDataType(complexType, fieldPropertyDTO);
                continue;
            }
            DataTypeEnum baseType = SpecialFieldTypeHelper.getDataType(iDataEntityProperty);
            fieldPropertyDTO.setDataType(baseType);
        }
    }

    private static void setFieldPropertyDTO(FieldPropertyDTO fieldPropertyDTO) {
        LinkedList<String> fieldKeyLinked = fieldPropertyDTO.getFieldKeyLinked();
        if (fieldKeyLinked.isEmpty()) {
            fieldKeyLinked.add("id");
            String fieldKey = fieldPropertyDTO.getFieldKey();
            fieldPropertyDTO.setFieldKey(fieldKey + ".id");
        }
    }

    private static void setDataType(IDataEntityType iDataEntityType, FieldPropertyDTO fieldPropertyDTO) {
        Map<String, IDataEntityProperty> fieldAndPropertyMap = SpecialFieldTypeHelper.getFieldAndPropertyMap(iDataEntityType);
        LinkedList<String> fieldKeyLinked = fieldPropertyDTO.getFieldKeyLinked();
        while (!fieldKeyLinked.isEmpty()) {
            String firstFieldKey = fieldKeyLinked.getFirst();
            IDataEntityProperty iDataEntityProperty = fieldAndPropertyMap.get(firstFieldKey);
            if (iDataEntityProperty == null || iDataEntityProperty instanceof MulBasedataProp || iDataEntityProperty instanceof EntryProp || iDataEntityProperty instanceof SubEntryProp) {
                fieldPropertyDTO.setValidField(false);
                break;
            }
            if (iDataEntityProperty instanceof BasedataProp) {
                fieldKeyLinked.removeFirst();
                SpecialFieldTypeHelper.setFieldPropertyDTO(fieldPropertyDTO);
                fieldAndPropertyMap = SpecialFieldTypeHelper.getFieldAndPropertyMap(((BasedataProp)iDataEntityProperty).getComplexType());
                continue;
            }
            DataTypeEnum baseType = SpecialFieldTypeHelper.getDataType(iDataEntityProperty);
            fieldPropertyDTO.setDataType(baseType);
            break;
        }
    }

    private static Map<String, IDataEntityProperty> getFieldAndPropertyMap(IDataEntityType iDataEntityType) {
        List propertyList = iDataEntityType.getJsonSerializerProperties();
        return propertyList.stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (oldVal, newVal) -> oldVal));
    }

    private static DataTypeEnum getDataType(IDataEntityProperty iDataEntityProperty) {
        DataTypeEnum dataTypeEnum = null;
        Class propertyType = iDataEntityProperty.getPropertyType();
        if (propertyType.equals(BigDecimal.class)) {
            dataTypeEnum = DataTypeEnum.BIG_DECIMAL;
        } else if (propertyType.equals(String.class) || propertyType.equals(ILocaleString.class)) {
            dataTypeEnum = DataTypeEnum.STRING;
        } else if (propertyType.equals(Long.TYPE) || propertyType.equals(Long.class)) {
            dataTypeEnum = DataTypeEnum.LONG;
        } else if (propertyType.equals(Integer.class) || propertyType.equals(Integer.TYPE)) {
            dataTypeEnum = DataTypeEnum.INTEGER;
        } else if (propertyType.equals(Date.class)) {
            dataTypeEnum = DataTypeEnum.LOCAL_DATE;
        } else if (propertyType.equals(Boolean.class) || propertyType.equals(Boolean.TYPE)) {
            dataTypeEnum = DataTypeEnum.BOOLEAN;
        }
        return dataTypeEnum;
    }
}

