/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.helper.listpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.bos.list.CardListColumn;
import kd.bos.list.CheckBoxListColumn;
import kd.bos.list.ComboListColumn;
import kd.bos.list.DateListColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.TimeListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.VoucherNoListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.helper.listpage.ColumnEntity;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class ListPageHelper {
    private static final Log LOGGER = LogFactory.getLog(ListPageHelper.class);

    public static List<ColumnEntity> getColumnEntitiesOf(String entityName) {
        return ListPageHelper.getColumnEntitiesOf(entityName, true, false);
    }

    public static List<ColumnEntity> getColumnEntitiesOf(String entityName, boolean isVisible, boolean isLookUp) {
        Map metaInfo;
        if (HRStringUtils.isNotEmpty((String)entityName) && (metaInfo = FormMetadataCache.getListMeta((String)entityName)) != null && metaInfo.containsKey(BillList.class.getSimpleName())) {
            String strBillList = (String)metaInfo.get(BillList.class.getSimpleName());
            BillList billList = (BillList)ControlTypes.fromJsonString((String)strBillList);
            List billListItems = billList.getItems();
            if (CollectionUtils.isEmpty((Collection)billListItems)) {
                return new ArrayList<ColumnEntity>(0);
            }
            ArrayList<ColumnEntity> columnEntities = new ArrayList<ColumnEntity>(10);
            for (Control billListItem : billListItems) {
                if (!(billListItem instanceof Container) || !"gridview".equalsIgnoreCase(billListItem.getKey())) continue;
                HashMap<String, Boolean> userListColumnsVisibleMap = isVisible ? ListPageHelper.getUserListColumnsVisibleMap(entityName, isLookUp) : new HashMap(0);
                ListPageHelper.getListColumnEntities((Container)billListItem, columnEntities, userListColumnsVisibleMap);
            }
            return columnEntities;
        }
        return new ArrayList<ColumnEntity>(0);
    }

    private static void getListColumnEntities(Container parentControl, List<ColumnEntity> columnEntities, Map<String, Boolean> userListColumnsVisibleMap) {
        for (Control childControl : parentControl.getItems()) {
            if (childControl instanceof IListColumn) {
                boolean isValidListColumnType;
                IListColumn listColumn = (IListColumn)childControl;
                ColumnEntity columnEntity = new ColumnEntity();
                boolean bl = isValidListColumnType = listColumn instanceof CardListColumn || listColumn instanceof ListOperationColumn || listColumn instanceof VoucherNoListColumn || listColumn instanceof TemplateTextListColumn || listColumn instanceof DynamicTextListColumn || listColumn.getClass().getName().contains("PictureListColumn") || listColumn.getClass().getName().contains("AvatarListColumn") || HRStringUtils.isEmpty((String)listColumn.getListFieldKey()) || Boolean.FALSE.equals(userListColumnsVisibleMap.get(listColumn.getListFieldKey()));
                if (isValidListColumnType) {
                    LOGGER.info("ListPageHelper.getListColumnEntities: listColumn type is {}", (Object)listColumn.getClass().getName());
                    continue;
                }
                columnEntity.setListFieldKey(listColumn.getListFieldKey());
                columnEntity.setSeq(listColumn.getSeq());
                columnEntity.setListFieldName(listColumn.getCaption().getLocaleValue());
                if (listColumn instanceof DateListColumn || listColumn instanceof TimeListColumn) {
                    columnEntity.setDataType(DataTypeEnum.DATE);
                    String displayFormat = listColumn instanceof DateListColumn ? ((DateListColumn)listColumn).getDisplayFormatString() : "yyyy-MM-dd";
                    columnEntity.setDisplayFormatString(displayFormat);
                } else if (listColumn instanceof DecimalListColumn) {
                    columnEntity.setDataType(DataTypeEnum.BIG_DECIMAL);
                } else {
                    columnEntity.setDataType(DataTypeEnum.STRING);
                }
                Boolean isComboListColumn = listColumn instanceof ComboListColumn || listColumn instanceof CheckBoxListColumn;
                columnEntity.setComboListColumn(isComboListColumn);
                columnEntities.add(columnEntity);
                continue;
            }
            if (!(childControl instanceof Container)) continue;
            ListPageHelper.getListColumnEntities((Container)childControl, columnEntities, userListColumnsVisibleMap);
        }
    }

    public static Set<String> getUserListColumnsVisible(String entityName, boolean isLookUp) {
        Set<String> userListColumnsVisibleSet = ListPageHelper.getUserListColumnsVisibleMap(entityName, isLookUp).entrySet().stream().filter(entity -> Boolean.TRUE.equals(entity.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        userListColumnsVisibleSet.add("fseq");
        return userListColumnsVisibleSet;
    }

    public static Map<String, Boolean> getUserListColumnsVisibleMap(String entityName, boolean isLookUp) {
        LinkedHashMap<String, Boolean> userListColumnsVisibleMap = new LinkedHashMap<String, Boolean>(16);
        List listFieldsControlColumns = null;
        String listPageFieldCfg = null;
        if (HRStringUtils.isNotEmpty((String)entityName)) {
            listPageFieldCfg = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)entityName);
            if (StringUtils.isNotBlank((CharSequence)listPageFieldCfg)) {
                listFieldsControlColumns = SerializationUtils.fromJsonStringToList((String)listPageFieldCfg, Map.class);
            }
            if (listFieldsControlColumns != null) {
                for (Map stringObjectMap : listFieldsControlColumns) {
                    int visibleValue = Integer.parseInt(stringObjectMap.get("visible").toString());
                    boolean isVisible = ViewCommonUtil.getListColumnVisible((boolean)true, (boolean)isLookUp, (int)visibleValue);
                    userListColumnsVisibleMap.put(stringObjectMap.get("listFieldKey").toString(), isVisible);
                }
            }
        }
        if (listFieldsControlColumns == null) {
            LOGGER.error("ListPageHelper.getUserListColumnsVisibleMap: entityName is {} and listPageFieldCfg is {}", (Object)entityName, (Object)listPageFieldCfg);
        }
        return userListColumnsVisibleMap;
    }
}

