/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.history;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.sit.sitbp.common.util.SITDateTimeUtils;

public class BaseDataHisHelper {
    public static QFilter getHisCurrFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
    }

    public static void addHisCurrFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        filter.and(BaseDataHisHelper.getHisCurrFilter());
    }

    public static QFilter getHisVerFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
    }

    public static void addHisVerFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        filter.and(BaseDataHisHelper.getHisVerFilter());
    }

    public static boolean isCurrPage(IFormView view) {
        return !BaseDataHisHelper.isHisPage(view);
    }

    public static boolean isHisPage(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        Object fromPage = params.get("fromPage");
        if (fromPage != null) {
            return "fromHisAction".equals(fromPage);
        }
        return false;
    }

    public static boolean isCurrList(IFormView view) {
        return !BaseDataHisHelper.isHisList(view);
    }

    public static boolean isHisList(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        return "hisinfolist".equals(params.get("hisinfolist")) || "showhisversion".equals(params.get("option"));
    }

    public static void saveTempVersion(DynamicObject[] dataCol) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEntityNumber(dataCol[0].getDataEntityType().getName());
        hisVersionParamBo.setHisDyns(dataCol);
        hisVersionParamBo.setNeedValidateDate(false);
        HisVersionChangeService.getInstance().saveTempVersion(hisVersionParamBo);
    }

    public static HisResponse<VersionChangeRespData> saveTimeVersion(DynamicObject[] hisDyns, boolean effImmediately) {
        if (hisDyns == null || hisDyns.length == 0) {
            return null;
        }
        HisModelController hisModelController = new HisModelController();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(effImmediately);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        hisVersionParamBo.setEntityNumber(hisDyns[0].getDataEntityType().getName());
        HisResponse res = hisModelController.hisVersionChange(hisVersionParamBo);
        return res;
    }

    public static HisResponse<BatchVersionChangeRespData> batchHisVersionChange(DynamicObject[] hisDyns, boolean effImmediately) {
        HisModelController hisModelController = new HisModelController();
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>(10);
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(effImmediately);
        hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        hisVersionParamBo.setEntityNumber(hisDyns[0].getDataEntityType().getName());
        hisVersionParamBo.setCancel_notSupported(true);
        listHisVersionParamBo.add(hisVersionParamBo);
        return hisModelController.batchHisVersionChange(hisVersionParamListBo);
    }

    public static HisResponse<VersionChangeRespData> saveNoTimeVersion(DynamicObject[] hisDyns, boolean effImmediately) {
        if (hisDyns == null || hisDyns.length == 0) {
            return null;
        }
        HisModelController hisModelController = new HisModelController();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(effImmediately);
        hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        hisVersionParamBo.setEntityNumber(hisDyns[0].getDataEntityType().getName());
        HisResponse res = hisModelController.noLineTimeHisVersionChange(hisVersionParamBo);
        return res;
    }

    public static void openHisListPage(IFormView view, String formId, Long boId, boolean isLeftTree, String caption) {
        ListShowParameter showParam = new ListShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.setParentPageId(view.getPageId());
        showParam.setBillFormId(formId);
        if (isLeftTree) {
            showParam.setFormId("hsbp_templatetreelist");
        } else {
            showParam.setFormId("bos_list");
        }
        showParam.setCustomParam("option", (Object)"showhisversion");
        showParam.setCustomParam("hisinfolist", (Object)"hisinfolist");
        showParam.setCustomParam("notOpenDefaultHyperLink", (Object)"number");
        if (boId != null) {
            showParam.setCustomParam("boid", (Object)boId);
            QFilter qFilter1 = new QFilter("boid", "=", (Object)boId);
            showParam.getListFilterParameter().getQFilters().add(qFilter1);
        }
        QFilter qFilter2 = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        showParam.getListFilterParameter().getQFilters().add(qFilter2);
        if (caption != null) {
            showParam.setCaption(caption);
        }
        view.showForm((FormShowParameter)showParam);
    }

    public static String getSelectProperties(String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return BaseDataHisHelper.getSelectProperties(mainEntityType);
    }

    public static String getSelectProperties(MainEntityType mainEntityType) {
        List<String> allFields = BaseDataHisHelper.getAllFields(mainEntityType);
        Map entityTypes = mainEntityType.getAllEntities();
        for (EntityType entityType : entityTypes.values()) {
            if (!(entityType instanceof EntryType)) continue;
            allFields.add(entityType.getName() + "." + ((EntryType)entityType).getSeqProperty().getName());
        }
        return BaseDataHisHelper.join(allFields, ",");
    }

    private static String join(List<String> arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String obj : arr) {
            sb.append((Object)obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static List<String> getAllFields(MainEntityType mainEntityType) {
        ArrayList<String> fields = new ArrayList<String>();
        Map fieldTypeMap = mainEntityType.getAllFields();
        for (Map.Entry entry : fieldTypeMap.entrySet()) {
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (entityProperty instanceof BasedataProp) {
                fields.add(entityProperty.getName() + ".id");
            } else {
                fields.add(entityProperty.getName());
            }
            if (!(entityProperty instanceof LargeTextProp)) continue;
            fields.add(entityProperty.getName() + "_tag");
        }
        return fields;
    }

    public static Date getMaxBsled() {
        try {
            return SITDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
        }
        catch (ParseException parseException) {
            return SITDateTimeUtils.getTodayDateWithoutTime();
        }
    }

    public static List<String> getEntryEntitys(MainEntityType mainEntityType) {
        ArrayList<String> entitys = new ArrayList<String>();
        Map entityTypeMap = mainEntityType.getAllEntities();
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            if (!(entry.getValue() instanceof EntryType) || entry.getValue() instanceof SubEntryType) continue;
            entitys.add((String)entry.getKey());
        }
        return entitys;
    }

    public static Map<String, List<String>> getEntityFieldsMap(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        HashMap<String, List<String>> entityFieldsMap = new HashMap<String, List<String>>(entityTypeMap.size());
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            String entity = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            Map fieldsMap = entityType.getFields();
            ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
            for (Map.Entry entry01 : fieldsMap.entrySet()) {
                IDataEntityProperty entityProperty = (IDataEntityProperty)entry01.getValue();
                fields.add(entityProperty.getName());
            }
            entityFieldsMap.put(entity, fields);
        }
        return entityFieldsMap;
    }

    public static void removeDefaultHRQFilter(IFormView formView, List<QFilter> qFilters) {
        if (BaseDataHisHelper.isHisList(formView) && formView.getFormShowParameter().getCustomParam("removeHrDatastatusFilter") != null) {
            Iterator<QFilter> it = qFilters.iterator();
            while (it.hasNext()) {
                Set valSet;
                QFilter filter = it.next();
                if (filter == null) continue;
                Object valObj = filter.getValue();
                if (!"datastatus".equals(filter.getProperty()) || !"in".equals(filter.getCP()) || !(valObj instanceof Set) || (valSet = (Set)valObj).size() != 4 || !valSet.contains("0") || !valSet.contains("1") || !valSet.contains("2") || !valSet.contains("-3")) continue;
                it.remove();
            }
        }
    }

    public static void hideListButton(boolean hideVersionList, Map<String, Object> params, List<IListColumn> iListColumns, Set<String> needHideFieldKeys) {
        boolean needHide;
        if (CollectionUtils.isEmpty(needHideFieldKeys) || CollectionUtils.isEmpty(iListColumns)) {
            return;
        }
        boolean bl = needHide = !hideVersionList || !CollectionUtils.isEmpty(params) && ("hisinfolist".equals(params.get("hisinfolist")) || "showhisversion".equals(params.get("option")));
        if (needHide) {
            Iterator<IListColumn> iterator = iListColumns.iterator();
            while (iterator.hasNext()) {
                IListColumn next = iterator.next();
                String listFieldKey = next.getListFieldKey();
                if (!needHideFieldKeys.contains(listFieldKey)) continue;
                iterator.remove();
            }
        }
    }
}

