/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.importutil;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.StringUtils;

public class ImportFieldChangedService {
    public static final String IMPORT_TYPE = "importtype";
    public static final String IMPORT_TYPE_OVERRIDE = "override";
    public static final String IMPORT_TYPE_OVERRIDENEW = "overridenew";
    public static final String CHINA_NUMBER = "001";
    private Map<Long, DynamicObject> importDyMap = null;
    private Map<Long, DynamicObject> importDyMapForChina = null;

    private ImportFieldChangedService() {
    }

    private ImportFieldChangedService(Map<Long, DynamicObject> importDyMap) {
        this.importDyMap = importDyMap;
    }

    public static ImportFieldChangedService createInstance() {
        return new ImportFieldChangedService();
    }

    public static ImportFieldChangedService createInstanceForImport(OperateOption operateOption, ExtendedDataEntity[] dataEntities) {
        boolean currImportUpdateOrIncludeNew;
        if (operateOption == null || ArrayUtils.isEmpty((Object[])dataEntities)) {
            return null;
        }
        Map<Long, DynamicObject> currImportDyMap = null;
        String importType = operateOption.getVariableValue(IMPORT_TYPE, null);
        boolean bl = currImportUpdateOrIncludeNew = IMPORT_TYPE_OVERRIDE.equals(importType) || IMPORT_TYPE_OVERRIDENEW.equals(importType);
        if (currImportUpdateOrIncludeNew) {
            ExtendedDataEntity dataEntity = dataEntities[0];
            String entryName = dataEntity.getDataEntity().getDataEntityType().getName();
            Set pkIdSet = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getLong("id")).filter(pkId -> pkId != 0L).collect(Collectors.toSet());
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entryName);
            QFilter filter = new QFilter("id", "in", pkIdSet);
            DynamicObject[] dyInfo = helper.loadDynamicObjectArray(filter.toArray());
            currImportDyMap = Arrays.stream(dyInfo).collect(Collectors.toMap(key -> key.getLong("id"), dy -> dy));
        }
        return new ImportFieldChangedService(currImportDyMap);
    }

    public boolean checkFixedFieldChangedWhenImport(ExtendedDataEntity dataEntity, Collection<String> fixFields) {
        DynamicObject dynamicObjectInDb;
        boolean isInvalid = false;
        DynamicObject dyFromImport = dataEntity.getDataEntity();
        if (!CollectionUtils.isEmpty(this.importDyMap) && !CollectionUtils.isEmpty(fixFields) && (dynamicObjectInDb = this.importDyMap.get(dyFromImport.getLong("id"))) != null) {
            for (String fixField : fixFields) {
                if (HRStringUtils.equals((String)dynamicObjectInDb.getString(fixField), (String)dyFromImport.getString(fixField))) continue;
                isInvalid = true;
                break;
            }
        }
        return isInvalid;
    }

    public Map<Long, DynamicObject> getImportDyMapForChina() {
        if (CollectionUtils.isEmpty(this.importDyMapForChina) && !CollectionUtils.isEmpty(this.importDyMap)) {
            this.importDyMapForChina = new HashMap<Long, DynamicObject>(this.importDyMap);
            this.importDyMapForChina.entrySet().removeIf(longDynamicObjectEntry -> !StringUtils.equals((String)((DynamicObject)longDynamicObjectEntry.getValue()).getString("number"), (String)CHINA_NUMBER));
        }
        return this.importDyMapForChina;
    }
}

