/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.importutil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;
import org.apache.commons.lang3.StringUtils;

public class ImportOperationResultHelper {
    private static final Log log = LogFactory.getLog(ImportOperationResultHelper.class);

    private ImportOperationResultHelper() {
    }

    public static void dealOperationResult(OperationResult operationResult, Map<Long, Integer> pkIdAndRowNumMap, Map<Integer, List<String>> rowNumAndErrInfoMap) {
        HashSet<String> errorMsgs = new HashSet<String>(16);
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                long pkId = Long.parseLong(String.valueOf(operateInfo.getPkValue()));
                Integer rowNum = pkIdAndRowNumMap.get(pkId);
                if (rowNum == null) continue;
                List errMsgInfo = rowNumAndErrInfoMap.computeIfAbsent(rowNum, key -> new ArrayList(10));
                errMsgInfo.add(operateInfo.getMessage());
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg) && !msg.contains(SInsuranceInfoEnum.COMMON_IMPORT_CANCEL_OP.getErrInfo()) && !msg.contains(SInsuranceInfoEnum.COMMON_IMPORT_VALIDATE_DATA_ERR.getErrInfo())) {
                log.error("ImportOperationResultHelper.dealOperationResult: import operation error, info is : {}", (Object)msg);
                for (Integer rowNum : pkIdAndRowNumMap.values()) {
                    List errMsgInfo = rowNumAndErrInfoMap.computeIfAbsent(rowNum, key -> new ArrayList(10));
                    errMsgInfo.clear();
                    errMsgInfo.add(msg);
                }
                errorMsgs.add(msg);
                throw new KDBizException(StringUtils.join((Object[])errorMsgs.toArray(), (String)";"));
            }
        }
    }
}

