/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.meta;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MetaDataHelper {
    private static final Log logger = LogFactory.getLog(MetaDataHelper.class);

    private MetaDataHelper() {
    }

    public static void replaceOldInheritPath(String entityName, String currParentInheritPath) {
        QFilter filter;
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"bos_formmeta");
        DynamicObject formMetaDy = helper.loadDynamicObject((filter = new QFilter("number", "=", (Object)entityName)).toArray());
        if (formMetaDy == null) {
            logger.error("MetaDataHelper.replaceOldInheritPath: {} does not exists.", (Object)entityName);
            throw new KDBizException(entityName + " does not exists.");
        }
        String srcCfgMetaId = formMetaDy.getString("id");
        filter = new QFilter("parentid", "=", (Object)srcCfgMetaId);
        filter.and("masterid", "=", (Object)srcCfgMetaId);
        filter.and("isv", "!=", (Object)"kingdee");
        DynamicObject extFormMetaDy = helper.loadDynamicObject(filter.toArray());
        if (extFormMetaDy != null) {
            String srcInheritPath = formMetaDy.getString("inheritpath");
            if (!HRStringUtils.equals((String)currParentInheritPath, (String)srcInheritPath)) {
                logger.error("MetaDataHelper.replaceOldInheritPath: {} does not upgrade.", (Object)entityName);
                throw new KDBizException(entityName + " does not upgrade.");
            }
            String targetInheritPath = srcInheritPath + "," + srcCfgMetaId;
            String oldInheritPath = extFormMetaDy.getString("inheritpath");
            if (!HRStringUtils.equals((String)oldInheritPath, (String)targetInheritPath)) {
                try (TXHandle txHandle = TX.requiresNew();){
                    MetaDataHelper.resetChildParent(extFormMetaDy.getString("id"), oldInheritPath, targetInheritPath);
                }
                extFormMetaDy = helper.loadSingle((Object)extFormMetaDy.getString("id"));
                oldInheritPath = extFormMetaDy.getString("inheritpath");
                if (!HRStringUtils.equals((String)oldInheritPath, (String)targetInheritPath)) {
                    logger.error("MetaDataHelper.replaceOldInheritPath: inheritPath is error.");
                    throw new KDBizException("must update " + entityName + " meta file first!");
                }
            }
        }
    }

    public static void resetChildParent(String formId, String oldInheritPath, String newInheritPath) {
        String bizAppId = MetadataDao.getAppIdFromUnitrel((String)formId);
        String bizUnitId = MetadataDao.getUnitIdFromUnitrel((String)formId);
        try (TXHandle tx = TX.required();){
            String nowDateLong = String.valueOf(System.currentTimeMillis());
            List list = MetadataDao.getFormDeployFile((String)formId);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                Map<String, String> xmlMap = MetaDataHelper.getXmlMap(formId);
                String modifyDate = xmlMap.get("ModifyDate");
                String version = xmlMap.get("Version");
                for (DeployFile deployFile : list) {
                    String dymMetaNew = deployFile.getFileContent().replace(oldInheritPath, newInheritPath);
                    if (!StringUtils.isBlank((String)modifyDate)) {
                        dymMetaNew = dymMetaNew.replace(modifyDate, nowDateLong);
                    }
                    if (!StringUtils.isBlank((String)version)) {
                        dymMetaNew = dymMetaNew.replace(version, nowDateLong);
                    }
                    MetadataDao.deployMetadata((String)dymMetaNew, (String)bizUnitId, (String)bizAppId);
                }
            }
        }
        ArrayList<String> formIdList = new ArrayList<String>();
        formIdList.add(formId);
        MetadataDao.clearSubRuntimeMeta(formIdList);
        MetadataDao.rebuildRuntimeMetaById((String)formId);
    }

    public static String getInheritPath(String formId) {
        Map<String, String> xmlMap = MetaDataHelper.getXmlMap(formId);
        return xmlMap.get("InheritPath");
    }

    private static Map<String, String> getXmlMap(String formId) {
        List formDeployFile = MetadataDao.getFormDeployFile((String)formId);
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        try {
            return MetaDataHelper.xmlToMap(((DeployFile)formDeployFile.get(0)).getFileContent(), "utf-8");
        }
        catch (UnsupportedEncodingException | DocumentException ex) {
            logger.error("MetaDataHelper.getXmlMap: ", ex);
            return Collections.emptyMap();
        }
    }

    private static Map<String, String> xmlToMap(String xml, String charset) throws UnsupportedEncodingException, DocumentException {
        HashMap<String, String> respMap = new HashMap<String, String>(16);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(charset)));
        Element root = doc.getRootElement();
        MetaDataHelper.xmlToMap(root, respMap);
        return respMap;
    }

    private static Map<String, String> xmlToMap(Element tmpElement, Map<String, String> respMap) {
        if (tmpElement.isTextOnly()) {
            respMap.put(tmpElement.getName(), tmpElement.getText());
            return respMap;
        }
        Iterator iterator = tmpElement.elementIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            MetaDataHelper.xmlToMap(element, respMap);
        }
        return respMap;
    }
}

