/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.multiview;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.sit.sitbp.business.multiview.CombinePageCfgHelper;

public class CombinePageCfgCacheService {
    private static final Log logger = LogFactory.getLog(CombinePageCfgCacheService.class);
    private static final CombinePageCfgCacheService combinePageCfgCacheService = new CombinePageCfgCacheService();

    public static CombinePageCfgCacheService getInstance() {
        return combinePageCfgCacheService;
    }

    private CombinePageCfgCacheService() {
    }

    public void updateCfg(Long cfgId) {
        Map cfgMap = (Map)HRAppCache.get((String)"sitbs").get("sitbs_combinepagecfg", Map.class);
        if (null != cfgMap) {
            cfgMap.remove(String.valueOf(cfgId));
            HRAppCache.get((String)"sitbs").put("sitbs_combinepagecfg", (Object)cfgMap);
        }
    }

    public void updateCfg(Object[] cfgIdArr) {
        Map cfgMap = (Map)HRAppCache.get((String)"sitbs").get("sitbs_combinepagecfg", Map.class);
        if (null != cfgMap) {
            for (Object cfgId : cfgIdArr) {
                cfgMap.remove(String.valueOf(cfgId));
            }
            HRAppCache.get((String)"sitbs").put("sitbs_combinepagecfg", (Object)cfgMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> getCfg(Long cfgId) {
        logger.info("CombinePageCfgCacheService, invoke getCfg, cfgId is {}", (Object)cfgId);
        Map<String, Map<String, Object>> cfgMap = (HashMap)HRAppCache.get((String)"sitbs").get("sitbs_combinepagecfg", Map.class);
        Map<String, Object> cfgDetailMap = null;
        if (null == cfgMap) {
            cfgMap = new HashMap(16);
        }
        if (null != cfgMap.get(String.valueOf(cfgId))) return (Map)cfgMap.get(String.valueOf(cfgId));
        String key = "sitbs_combinepagecfg/" + String.valueOf(cfgId);
        DLock dLock = DLock.create((String)key);
        try {
            dLock.lock();
            logger.info("\u591a\u89c6\u56fe\u914d\u7f6e\u65b9\u6848id\uff1a{}\uff0c\u83b7\u5f97\u9501", (Object)cfgId);
            cfgMap = (Map)HRAppCache.get((String)"sitbs").get("sitbs_combinepagecfg", Map.class);
            if (null == cfgMap) {
                cfgMap = new HashMap(16);
            }
            if (null == cfgMap.get(String.valueOf(cfgId))) {
                cfgDetailMap = this.getCfgFromDB(cfgId);
                cfgMap.put(String.valueOf(cfgId), cfgDetailMap);
                logger.info("CombinePageCfgCacheService, getCfgFromDB, cfgDetailMap is {}", cfgDetailMap);
            }
        }
        finally {
            logger.info("\u591a\u89c6\u56fe\u914d\u7f6e\u65b9\u6848id\uff1a{}\uff0c\u91ca\u653e\u9501", (Object)cfgId);
            dLock.unlock();
            dLock.close();
        }
        HRAppCache.get((String)"sitbs").put("sitbs_combinepagecfg", cfgMap);
        return cfgDetailMap;
    }

    private Map<String, Object> getCfgFromDB(Long cfgId) {
        return CombinePageCfgHelper.getCfgInfo(cfgId);
    }

    public void clearCache() {
        HRAppCache.get((String)"sitbs").remove("sitbs_combinepagecfg");
    }

    public Long getPageCfgId(Long belongCountryId) {
        Map cfgMap = (Map)HRAppCache.get((String)"sitbs").get("sitbs_combinepagecfg", Map.class);
        if (null == cfgMap) {
            return CombinePageCfgHelper.getPageCfgIdByBelongCountryId(belongCountryId);
        }
        HashMap<Long, Long> belongCountryIdtoPageCfgIdMap = new HashMap<Long, Long>(16);
        for (Map.Entry Entry2 : cfgMap.entrySet()) {
            Long belongcountryId = Long.valueOf(String.valueOf(((Map)Entry2.getValue()).get("belongcountry")));
            belongCountryIdtoPageCfgIdMap.putIfAbsent(belongcountryId, Long.valueOf((String)Entry2.getKey()));
            if (!"C".equals(((Map)Entry2.getValue()).get("status"))) continue;
            belongCountryIdtoPageCfgIdMap.put(belongcountryId, Long.valueOf((String)Entry2.getKey()));
        }
        Long cfgId = (Long)belongCountryIdtoPageCfgIdMap.get(belongCountryId);
        if (null != cfgId) {
            return cfgId;
        }
        return CombinePageCfgHelper.getPageCfgIdByBelongCountryId(belongCountryId);
    }
}

