/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.multiview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.multiview.CombinePageCfgCacheService;

public class CombinePageCfgHelper {
    private static final Log logger = LogFactory.getLog(CombinePageCfgHelper.class);
    private static final String QUERY_COMBINEPAGECFG_FIELD = "id,number,name,status,enable,belongcountry,pageframereg,toppage,mainentry,mainentry.seq,mainpagereg,tabentry,tabentry.seq,tabpagereg,siderentry,siderentry.seq,siderpagereg";
    private static final String QUERY_PAGEREG_FIELD = "id,number,name,belongcountry,page,pagetype,area";

    public static Map<String, Object> getCfgInfo(Long cfgId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_combinepagecfg");
        DynamicObject cfgDy = helper.queryOne(QUERY_COMBINEPAGECFG_FIELD, new QFilter("id", "=", (Object)cfgId));
        HashMap<String, Object> dbInfo = new HashMap<String, Object>(16);
        dbInfo.put("number", cfgDy.getString("number"));
        dbInfo.put("name", cfgDy.getString("name"));
        DynamicObject belongCountry = cfgDy.getDynamicObject("belongcountry");
        Long belongCountryId = belongCountry.getLong("id");
        dbInfo.put("belongcountry", belongCountryId);
        String pageFrameId = cfgDy.getDynamicObject("pageframereg").getString("pageframe.id");
        dbInfo.put("pageframereg", pageFrameId);
        dbInfo.put("status", cfgDy.getString("status"));
        dbInfo.put("enable", cfgDy.getString("enable"));
        CombinePageCfgHelper.setPageRegCfg(dbInfo, cfgDy);
        return dbInfo;
    }

    private static void setPageRegCfg(Map<String, Object> dbInfo, DynamicObject cfgDy) {
        DynamicObject topPageDy = cfgDy.getDynamicObject("toppage");
        DynamicObjectCollection mainEntryDys = cfgDy.getDynamicObjectCollection("mainentry");
        DynamicObjectCollection tabEntryDys = cfgDy.getDynamicObjectCollection("tabentry");
        DynamicObjectCollection siderEntryDys = cfgDy.getDynamicObjectCollection("siderentry");
        HashMap<String, List<Map<String, Object>>> pageConfig = new HashMap<String, List<Map<String, Object>>>(16);
        List<Map<String, Object>> topPageInfo = CombinePageCfgHelper.getTopPageInfo(topPageDy);
        if (null != topPageInfo) {
            pageConfig.put("toppage", topPageInfo);
        } else {
            pageConfig.remove("toppage");
        }
        List<Map<String, Object>> mainPageInfo = CombinePageCfgHelper.getEntryEntityInfo(mainEntryDys, "main");
        if (null != mainPageInfo) {
            pageConfig.put("mainentry", mainPageInfo);
        } else {
            pageConfig.remove("mainentry");
        }
        List<Map<String, Object>> tabPageInfo = CombinePageCfgHelper.getEntryEntityInfo(tabEntryDys, "tab");
        if (null != tabPageInfo) {
            pageConfig.put("tabentry", tabPageInfo);
        } else {
            pageConfig.remove("tabentry");
        }
        List<Map<String, Object>> siderPageInfo = CombinePageCfgHelper.getEntryEntityInfo(siderEntryDys, "sider");
        if (null != siderPageInfo) {
            pageConfig.put("siderentry", siderPageInfo);
        } else {
            pageConfig.remove("siderentry");
        }
        Map<String, Map<String, Object>> pageRegRel = CombinePageCfgHelper.getPageRegRel(pageConfig);
        for (Map.Entry entryEntity : pageConfig.entrySet()) {
            List entryRowList = (List)entryEntity.getValue();
            for (Map rowData : entryRowList) {
                String regId = String.valueOf(rowData.get("pageregid"));
                Map<String, Object> pageInfo = pageRegRel.get(regId);
                if (null == pageInfo) continue;
                rowData.put("number", pageInfo.get("number"));
                rowData.put("name", pageInfo.get("name"));
                rowData.put("belongcountry", pageInfo.get("belongcountry"));
                rowData.put("page", pageInfo.get("page"));
                rowData.put("pagetype", pageInfo.get("pagetype"));
                rowData.put("area", pageInfo.get("area"));
            }
        }
        String pageJson = SerializationUtils.toJsonString(pageConfig);
        dbInfo.put("PageJson", pageJson);
    }

    private static List<Map<String, Object>> getTopPageInfo(DynamicObject topPageDy) {
        if (null == topPageDy) {
            return null;
        }
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(1);
        HashMap<String, String> rowData = new HashMap<String, String>(16);
        String topPageId = topPageDy.getString("id");
        rowData.put("pageregid", topPageId);
        entryList.add(rowData);
        return entryList;
    }

    private static List<Map<String, Object>> getEntryEntityInfo(DynamicObjectCollection entryDys, String entryKey) {
        if (null == entryDys || entryDys.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject entryDy : entryDys) {
            HashMap<String, Object> rowData = new HashMap<String, Object>(16);
            rowData.put("seq", entryDy.getInt("seq"));
            rowData.put("pageregid", entryDy.getString(entryKey + "pagereg" + "." + "id"));
            entryList.add(rowData);
        }
        return entryList;
    }

    private static Map<String, Map<String, Object>> getPageRegRel(Map<String, List<Map<String, Object>>> pageConfig) {
        HashSet rowSet = new HashSet(16);
        for (Map.Entry<String, List<Map<String, Object>>> entry : pageConfig.entrySet()) {
            List<Map<String, Object>> entryEntityData = entry.getValue();
            Set rowIdSet = entryEntityData.stream().map(rowData -> HRJSONUtils.getLongValOfCustomParam(rowData.get("pageregid"))).collect(Collectors.toSet());
            rowSet.addAll(rowIdSet);
        }
        HRBaseServiceHelper pageRegHelper = new HRBaseServiceHelper("sitbs_pagereg");
        DynamicObject[] pageRegDyArr = pageRegHelper.query(QUERY_PAGEREG_FIELD, new QFilter[]{new QFilter("id", "in", rowSet)});
        HashMap<String, Map<String, Object>> pageRegRel = new HashMap<String, Map<String, Object>>(pageRegDyArr.length);
        for (DynamicObject pageRegInfo : pageRegDyArr) {
            String pageRegId = pageRegInfo.getString("id");
            HashMap<String, Object> pageInfo = new HashMap<String, Object>(16);
            pageInfo.put("number", pageRegInfo.getString("number"));
            pageInfo.put("name", pageRegInfo.get("name"));
            pageInfo.put("belongcountry", pageRegInfo.getString("belongcountry.id"));
            pageInfo.put("page", pageRegInfo.getString("page.number"));
            pageInfo.put("pagetype", pageRegInfo.getString("pagetype"));
            pageInfo.put("area", pageRegInfo.getString("area"));
            pageRegRel.put(pageRegId, pageInfo);
        }
        return pageRegRel;
    }

    public static Set<Long> getAlreadyUsedBelongCountries() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_combinepagecfg");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject[] dys = helper.query("id,number,belongcountry", new QFilter[]{enableFilter, auditFilter});
        HashSet<Long> belongCountryIds = new HashSet<Long>(16);
        for (DynamicObject dy : dys) {
            long belongCountryId = dy.getDynamicObject("belongcountry").getLong("id");
            belongCountryIds.add(belongCountryId);
        }
        return belongCountryIds;
    }

    public static Map<String, List<String>> getUsedPageRegIds(Set<String> pageRegIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_combinepagecfg");
        DynamicObject[] dynamicObjects = helper.query("id,number,toppage,mainentry,mainpagereg,tabentry,tabpagereg,siderentry,siderpagereg", new QFilter[]{new QFilter("id", "in", pageRegIds.stream().map(Long::valueOf).collect(Collectors.toSet()))});
        HashMap<String, List<String>> checkMap = new HashMap<String, List<String>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String number = dynamicObject.getString("number");
            String topPageId = dynamicObject.getString("toppage");
            DynamicObjectCollection mainEntryDys = dynamicObject.getDynamicObjectCollection("mainentry");
            DynamicObjectCollection tabEntryDys = dynamicObject.getDynamicObjectCollection("tabentry");
            DynamicObjectCollection siderEntryDys = dynamicObject.getDynamicObjectCollection("siderentry");
            CombinePageCfgHelper.putInCheckMap(checkMap, topPageId, number);
            for (DynamicObject mainEntryDy : mainEntryDys) {
                String mainPageRegId = mainEntryDy.getString("mainpagereg");
                CombinePageCfgHelper.putInCheckMap(checkMap, mainPageRegId, number);
            }
            for (DynamicObject tabEntryDy : tabEntryDys) {
                String tabPageRegId = tabEntryDy.getString("tabpagereg");
                CombinePageCfgHelper.putInCheckMap(checkMap, tabPageRegId, number);
            }
            for (DynamicObject siderEntryDy : siderEntryDys) {
                String siderPageRegId = siderEntryDy.getString("mainpagereg");
                CombinePageCfgHelper.putInCheckMap(checkMap, siderPageRegId, number);
            }
        }
        return checkMap;
    }

    private static void putInCheckMap(Map<String, List<String>> checkMap, String pageRegId, String number) {
        if (!checkMap.containsKey(pageRegId)) {
            ArrayList<String> list = new ArrayList<String>(16);
            list.add(number);
            checkMap.put(pageRegId, list);
        } else {
            checkMap.get(pageRegId).add(number);
        }
    }

    public static Long getPageCfgIdByBelongCountryId(Long belongCountryId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_combinepagecfg");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter belongCountryFilter = new QFilter("belongcountry", "=", (Object)belongCountryId);
        DynamicObject dy = helper.queryOne("id,number,belongcountry.id", new QFilter[]{enableFilter, auditFilter, belongCountryFilter});
        if (!HRObjectUtils.isEmpty((Object)dy) && HRStringUtils.isNotEmpty((String)dy.getString("belongcountry.id"))) {
            CombinePageCfgCacheService.getInstance().getCfg(dy.getLong("id"));
            return dy.getLong("id");
        }
        return null;
    }

    public static boolean checkSameBelongCountry(List<String> selectedRowsId, String opKey) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_combinepagecfg");
        QFilter auditFilter = null;
        QFilter enableFilter = null;
        switch (opKey) {
            case "audit": {
                auditFilter = new QFilter("status", "=", (Object)"B");
                enableFilter = new QFilter("enable", "=", (Object)"1");
                break;
            }
            case "enable": {
                auditFilter = new QFilter("status", "=", (Object)"C");
                enableFilter = new QFilter("enable", "=", (Object)"0");
                break;
            }
        }
        QFilter idFilter = new QFilter("id", "in", selectedRowsId.stream().map(Long::valueOf).collect(Collectors.toList()));
        DynamicObject[] dynamicObjects = helper.query("id,number,belongcountry.id", new QFilter[]{enableFilter, auditFilter, idFilter});
        HashSet<Long> belongCountryIds = new HashSet<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long belongCountryId = dynamicObject.getLong("belongcountry.id");
            if (belongCountryIds.add(belongCountryId)) continue;
            return true;
        }
        return false;
    }
}

