/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.multiview;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.control.HRAdvConAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.sit.sitbp.business.multiview.CombinePageCfgCacheService;

public class PageFrameLoadMetaHelper {
    private static final Log logger = LogFactory.getLog(PageFrameLoadMetaHelper.class);
    private static final PageFrameLoadMetaHelper PAGE_FRAME_LOAD_META_HELPER = new PageFrameLoadMetaHelper();

    public static PageFrameLoadMetaHelper getInstance() {
        return PAGE_FRAME_LOAD_META_HELPER;
    }

    private PageFrameLoadMetaHelper() {
    }

    public FlexPanelAp createDynamicPanelAp(Long cfgId) {
        Map<String, Object> dyFileAllCfg = CombinePageCfgCacheService.getInstance().getCfg(cfgId);
        FlexPanelAp dynGlobalPanel = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("dynglobalpanel").setWrap(false).setDirection("row").setGrow(1).setShrink(1).setAlignItems("stretch").setMarginBottom("10px")).build();
        dynGlobalPanel.getItems().add(this.buildLeftPanel(dyFileAllCfg));
        String cfgNumber = String.valueOf(dyFileAllCfg.get("pageframereg"));
        if (!"hcsi_filebase".equals(cfgNumber) && this.hasTabPage(dyFileAllCfg)) {
            dynGlobalPanel.getItems().add(this.buildRightPanel(dyFileAllCfg));
        }
        return dynGlobalPanel;
    }

    private FlexPanelAp buildRightPanel(Map<String, Object> dyFileAllCfg) {
        String pageConfigJson = (String)dyFileAllCfg.get("PageJson");
        Map pageConfig = (Map)SerializationUtils.fromJsonString((String)pageConfigJson, Map.class);
        List tabEntryList = (List)pageConfig.get("tabentry");
        List siderEntryList = (List)pageConfig.get("siderentry");
        TabAp tabAp = new TabAp();
        tabAp.setKey("tabap");
        tabAp.setTabStyle(2);
        List sortRowList = tabEntryList.stream().sorted(Comparator.comparingInt(map -> Integer.parseInt(String.valueOf(map.get("seq"))))).collect(Collectors.toList());
        for (Map tabPageInfo : sortRowList) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(String.valueOf(tabPageInfo.get("number")));
            tabPageAp.setName(LocaleString.fromMap((Map)((Map)tabPageInfo.get("name"))));
            tabPageAp.setBackColor("#ffffff");
            tabPageAp.setFontSize(14);
            if (siderEntryList != null && 1 == (Integer)tabPageInfo.get("seq") && siderEntryList.size() > 0) {
                tabPageAp.getItems().add(this.buildSiderPanel(pageConfig));
            }
            tabAp.getItems().add(tabPageAp);
        }
        FlexPanelAp rightPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("rightpanelap").setWidth("318px").setBackColor("#ffffff").setGrow(0).setShrink(0).setOverflow("hidden").setMarginRight("10px")).setMarginTop("8px")).setWrap(true).setDirection("column").setAlignItems("center").setJustifyContent("center").build();
        rightPanelAp.getItems().add(tabAp);
        return rightPanelAp;
    }

    private FlexPanelAp buildSiderPanel(Map<String, List<Map<String, Object>>> pageConfig) {
        FlexPanelAp siderPanel = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("flexpanelsiderinfo").setWidth("80%").setFontSize(14).setForeColor("#333333").setMarginLeft("20px")).setPaddingTop("12px")).setGrow(0).setShrink(0).setWrap(true).setDirection("column").build();
        siderPanel.getItems().add(this.createSiderPageInfoPanelAp(pageConfig));
        return siderPanel;
    }

    public FlexPanelAp createSiderPageInfoPanelAp(Map<String, List<Map<String, Object>>> pageConfig) {
        String customStyle = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQgPiBkaXZ7XG5cdGhlaWdodDo0MXB4O1xufVxuJCA+IGRpdjpob3Zlcntcblx0Y29sb3I6J3RoZW1lQ29sb3InIWltcG9ydGFudDtcbn1cbiQgPiBkaXYgPiBkaXZ7XG5cdG1hcmdpbi1ib3R0b206MHB4IWltcG9ydGFudDtcbn1cbiJ9";
        FlexPanelAp siderPanelAp = new HRFlexPanelAp.Builder("siderpageflexpanellistap").setWrap(true).setDirection("column").setJustifyContent("flex-start").setAlignItems("flex-start").build();
        siderPanelAp.setCustomeStyles(customStyle);
        List<Map<String, Object>> siderEntryList = pageConfig.get("siderentry");
        if (null == siderEntryList || siderEntryList.size() == 0) {
            return siderPanelAp;
        }
        List sortRowList = siderEntryList.stream().sorted(Comparator.comparingInt(map -> Integer.parseInt(String.valueOf(map.get("seq"))))).collect(Collectors.toList());
        for (Map siderItem : sortRowList) {
            String index = String.valueOf(siderItem.get("seq"));
            FlexPanelAp itemPanelAp = new HRFlexPanelAp.Builder("itempanelap" + index).setWrap(true).setDirection("row").setAlignItems("flex-start").setAlignItems("flex-start").setHeight("40px").build();
            String labelKey = String.valueOf(siderItem.get("number"));
            LabelAp itemLabel = ((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(labelKey).setId(labelKey).setName(LocaleString.fromMap((Map)((Map)siderItem.get("name"))).toString()).setFontSize(14).setClickable(true).setPaddingLeft("20px")).setMarginTop("10px")).build();
            itemPanelAp.getItems().add(itemLabel);
            siderPanelAp.getItems().add(itemPanelAp);
        }
        return siderPanelAp;
    }

    private boolean hasTabPage(Map<String, Object> dyFileAllCfg) {
        String pageConfigJson = (String)dyFileAllCfg.get("PageJson");
        Map pageConfig = (Map)SerializationUtils.fromJsonString((String)pageConfigJson, Map.class);
        List tabEntryList = (List)pageConfig.get("tabentry");
        return tabEntryList != null && tabEntryList.size() > 0;
    }

    private FlexPanelAp buildLeftPanel(Map<String, Object> dyFileAllCfg) {
        String pageConfigJson = (String)dyFileAllCfg.get("PageJson");
        Map pageConfig = (Map)SerializationUtils.fromJsonString((String)pageConfigJson, Map.class);
        FlexPanelAp leftpanelap = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("leftpanelap").setMarginTop("10px")).setMarginLeft("10px")).setMarginRight("10px")).setShrink(1).setGrow(1).setOverflow("hidden").setWrap(false).setDirection("row").setAlignItems("stretch").build();
        leftpanelap.getItems().add(this.buildMainPagePanel(pageConfig));
        return leftpanelap;
    }

    private FlexPanelAp buildMainPagePanel(Map<String, List<Map<String, Object>>> pageConfig) {
        List<Map<String, Object>> topPageList = pageConfig.get("toppage");
        List<Map<String, Object>> mainEntryList = pageConfig.get("mainentry");
        FlexPanelAp leftMainInfoPanelAp = new HRFlexPanelAp.Builder("leftmaininfopanel").setWidth("100%").setGrow(1).setShrink(1).setWrap(false).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").build();
        FlexPanelAp bodyPanel = null;
        if (null != topPageList && topPageList.size() > 0) {
            bodyPanel = this.buildTopPanel(topPageList);
            leftMainInfoPanelAp.getItems().add(bodyPanel);
        }
        if (null != mainEntryList && mainEntryList.size() > 0) {
            if (bodyPanel == null) {
                leftMainInfoPanelAp.getItems().add(this.buildMulEntityPanel(null, mainEntryList));
            } else {
                this.buildMulEntityPanel(bodyPanel, mainEntryList);
            }
        }
        return leftMainInfoPanelAp;
    }

    private FlexPanelAp buildMulEntityPanel(FlexPanelAp bodyPanel, List<Map<String, Object>> mainEntryList) {
        if (bodyPanel == null) {
            bodyPanel = new HRFlexPanelAp.Builder("mulentitypanelap").setGrow(1).setShrink(1).setWrap(false).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").build();
        }
        List sortRowList = mainEntryList.stream().sorted(Comparator.comparingInt(map -> Integer.parseInt(String.valueOf(map.get("seq"))))).collect(Collectors.toList());
        for (Map entityInfo : sortRowList) {
            String index = String.valueOf(entityInfo.get("seq"));
            String pageName = LocaleString.fromMap((Map)((Map)entityInfo.get("name"))).toString();
            String pageType = String.valueOf(entityInfo.get("pagetype"));
            String pageKey = String.valueOf(entityInfo.get("number"));
            if ("1".equals(pageType)) {
                FlexPanelAp entityFlexPanel = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(pageKey).setName(pageName).setShrink(0).setGrow(0).setWrap(false).setDirection("column").setAlignItems("stretch").setBackColor("#ffffff").setOverflow("visible").setCollapsible(true).setMarginBottom("10px")).build();
                logger.info("starting loading entityFlexPanel:Name:" + pageName + ", pageKey:" + pageKey + ", pageType:" + pageType);
                bodyPanel.getItems().add(entityFlexPanel);
                continue;
            }
            AdvConAp entityAdvconAp = ((HRAdvConAp.Builder)((HRAdvConAp.Builder)new HRAdvConAp.Builder("entityadvconap" + index).setName(pageName).setWidth("100%").setShrink(0).setGrow(0).setPaddingBottom("10px")).setPaddingTop("10px")).setBackColor("#ffffff").setCollapsible(true).build();
            AdvConChildPanelAp childPanelAp = this.buildAdvConChildPanel(pageKey, pageType);
            entityAdvconAp.getItems().add(childPanelAp);
            bodyPanel.getItems().add(entityAdvconAp);
        }
        return bodyPanel;
    }

    private AdvConChildPanelAp buildAdvConChildPanel(String pageKey, String pageType) {
        AdvConChildPanelAp childPanelAp = new AdvConChildPanelAp();
        childPanelAp.setKey(pageKey + "child");
        childPanelAp.setGrow(1);
        childPanelAp.setShrink(1);
        childPanelAp.setWidth(new LocaleString("100%"));
        childPanelAp.setWrap(false);
        if ("2".equals(pageType)) {
            childPanelAp.setDirection("column");
            childPanelAp.setAlignItems("stretch");
            childPanelAp.setOverflow("hidden");
            FlexPanelAp implantPanel = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(pageKey).setWidth("100%").setBackColor("#ffffff").setMarginLeft("-10px")).setGrow(1).setShrink(0).setOverflow("hidden").build();
            childPanelAp.getItems().add(implantPanel);
        } else {
            childPanelAp.setDirection("row");
            FlexPanelAp implantPanel = new HRFlexPanelAp.Builder(pageKey).setWidth("100%").setShrink(0).build();
            childPanelAp.getItems().add(implantPanel);
        }
        return childPanelAp;
    }

    private FlexPanelAp buildTopPanel(List<Map<String, Object>> topPageList) {
        Map<String, Object> topPageInfo = topPageList.get(0);
        FlexPanelAp headPanelAp = new HRFlexPanelAp.Builder("mulentitypanelap").setGrow(1).setShrink(1).setWrap(false).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").build();
        FlexPanelAp implantPanel = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(String.valueOf(topPageInfo.get("number"))).setBackColor("#ffffff").setGrow(0).setShrink(0).setZIndex(0).setWrap(true).setDirection("row").setAlignItems("stretch").setMarginBottom("10px")).build();
        headPanelAp.getItems().add(implantPanel);
        return headPanelAp;
    }

    public FlexPanelAp createRelatePagePanelAp(FormShowParameter showParameter) {
        String siderInfo = (String)showParameter.getCustomParam("siderentry");
        List siderPageList = (List)SerializationUtils.fromJsonString((String)siderInfo, List.class);
        FlexPanelAp relatePanelAp = new HRFlexPanelAp.Builder("relatepageflexpanellistap").setWrap(true).setDirection("row").setAlignItems("flex-start").setJustifyContent("flex-start").setHeight("34px").build();
        if (siderPageList != null && siderPageList.size() > 0) {
            this.buildRelatePageSiderPanel(siderPageList, relatePanelAp);
        }
        return relatePanelAp;
    }

    private void buildRelatePageSiderPanel(List<Map<String, Object>> siderPageList, FlexPanelAp relatePanelAp) {
        for (Map<String, Object> siderItem : siderPageList) {
            String number = String.valueOf(siderItem.get("number"));
            String pageName = LocaleString.fromMap((Map)((Map)siderItem.get("name"))).toString();
            FlexPanelAp relateLabelPanelAp = new HRFlexPanelAp.Builder(number + "panel").setWrap(true).setDirection("row").setJustifyContent("flex-start").setAlignItems("flex-start").setHeight("40px").build();
            LabelAp lblRelatePageAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(number).setId(number).setName(pageName).setFontSize(14).setClickable(true).setPaddingLeft("20px")).setMarginTop("10px")).build();
            relateLabelPanelAp.getItems().add(lblRelatePageAp);
            relatePanelAp.getItems().add(relateLabelPanelAp);
        }
    }

    public void setSelectStyle(String currRegNumber, IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String siderInfo = (String)formShowParameter.getCustomParam("siderentry");
        List siderPageList = (List)SerializationUtils.fromJsonString((String)siderInfo, List.class);
        Map currentSider = null;
        for (Map siderMap : siderPageList) {
            String number = String.valueOf(siderMap.get("number"));
            if (currRegNumber.equals(number)) {
                currentSider = siderMap;
                continue;
            }
            LabelAp lblRelatePageAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(number).setId(number).setName(LocaleString.fromMap((Map)((Map)siderMap.get("name"))).toString()).setFontSize(14).setClickable(true).setPaddingLeft("20px")).setMarginTop("10px")).build();
            view.updateControlMetadata(lblRelatePageAp.getKey(), lblRelatePageAp.createControl());
            FlexPanelAp relateLabelPanelAp = new HRFlexPanelAp.Builder(number + "panel").setWrap(true).setDirection("row").setJustifyContent("flex-start").setAlignItems("flex-start").setHeight("40px").build();
            relateLabelPanelAp.getItems().add(lblRelatePageAp);
            view.updateControlMetadata(relateLabelPanelAp.getKey(), relateLabelPanelAp.createControl());
        }
        if (currentSider == null) {
            return;
        }
        LabelAp selectLabelAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(currRegNumber).setId(currRegNumber).setName(LocaleString.fromMap((Map)((Map)currentSider.get("name"))).toString()).setFontSize(14).setClickable(true).setForeColor("themeColor").setPaddingLeft("16px")).setMarginTop("10px")).build();
        view.updateControlMetadata(selectLabelAp.getKey(), selectLabelAp.createControl());
        String borderStyle = "4px_solid_themeColor";
        FlexPanelAp selectFlexPanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(currRegNumber + "panel").setWrap(true).setDirection("row").setAlignItems("flex-start").setJustifyContent("flex-start").setHeight("40px").setBorderLeft(borderStyle)).build();
        selectFlexPanelAp.getItems().add(selectLabelAp);
        view.updateControlMetadata(selectFlexPanelAp.getKey(), selectFlexPanelAp.createControl());
    }
}

