/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.multiview;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class PageFrameShowFormUtils {
    private static final Log logger = LogFactory.getLog(PageFrameShowFormUtils.class);

    public static void showBaseForm(Map<String, String> name, String pageKey, String pageNumber, IFormView view, Map<String, String> pageIds) {
        int editStatus;
        logger.info("\u4f20\u5165showBaseForm\u65b9\u6cd5\u4e2d\u7684pageKey: {}", (Object)pageKey);
        Map customParams = view.getFormShowParameter().getCustomParams();
        Map relateFileIds = (Map)customParams.get("relateFileIds");
        customParams.put("pageNumber", pageNumber);
        customParams.put("pageKey", pageKey);
        if ("true".equals(customParams.get("isOnlyView"))) {
            editStatus = DataEditStatusEnum.READ_ONLY.getCode();
        } else {
            Object obj = customParams.get(pageNumber + ".editStatus");
            int n = editStatus = null != obj ? ((Integer)obj).intValue() : DataEditStatusEnum.CAN_WRITE.getCode();
        }
        if (null != relateFileIds.get(pageNumber) && (Long)BaseDataConverter.convert(relateFileIds.get(pageNumber), Long.class) > 0L) {
            PageFrameShowFormUtils.setParentAdvUnCollapsible(view, pageKey);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setPkId(relateFileIds.get(pageNumber));
            baseShowParameter.getOpenStyle().setTargetKey(pageKey);
            baseShowParameter.setFormId(pageNumber);
            baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            baseShowParameter.setCustomParams(customParams);
            baseShowParameter.setCustomParam("pageName", name);
            if ("iit_person".equals(pageNumber)) {
                baseShowParameter.setHasRight(true);
            }
            StyleCss cssValue = new StyleCss();
            cssValue.setWidth("100%");
            cssValue.setHeight("100%");
            baseShowParameter.getOpenStyle().setInlineStyleCss(cssValue);
            baseShowParameter.setStatus(OperationStatus.VIEW);
            if (DataEditStatusEnum.WRITE.getCode() == editStatus) {
                baseShowParameter.setCustomParam("iscopy", (Object)Boolean.TRUE);
                baseShowParameter.setCustomParam("isCopyRelateEntity", (Object)Boolean.FALSE);
                baseShowParameter.setStatus(OperationStatus.ADDNEW);
            }
            if (DataEditStatusEnum.CAN_WRITE.getCode() == editStatus || DataEditStatusEnum.READ_ONLY.getCode() == editStatus) {
                baseShowParameter.setStatus(OperationStatus.VIEW);
            }
            view.showForm((FormShowParameter)baseShowParameter);
            String pageId = baseShowParameter.getPageId();
            pageIds.put(pageNumber, pageId);
        } else if (DataEditStatusEnum.READ_ONLY.getCode() == editStatus) {
            PageFrameShowFormUtils.embedNullPage(name, pageKey, "sitbp_simplenullpage", view, customParams);
        } else {
            PageFrameShowFormUtils.embedNullPage(name, pageKey, "sitbp_nullpage", view, customParams);
        }
    }

    private static void embedNullPage(Map<String, String> name, String pageKey, String pageNumber, IFormView view, Map<String, Object> customParams) {
        PageFrameShowFormUtils.setParentAdvCollapsible(view, pageKey);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(pageKey);
        showParameter.setFormId(pageNumber);
        showParameter.setSendToClient(true);
        if (customParams != null) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.setCustomParam("pageName", name);
        view.showForm(showParameter);
    }

    private static void setParentAdvCollapsible(IFormView formView, String flexKey) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("collapsible", Boolean.TRUE);
        formView.updateControlMetadata(flexKey, map);
    }

    private static void setParentAdvUnCollapsible(IFormView formView, String flexKey) {
        logger.info("\u4f20\u5165setParentAdvUnCollapsible\u65b9\u6cd5\u4e2d\u7684pageKey: {}", (Object)flexKey);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("collapsible", Boolean.FALSE);
        formView.updateControlMetadata(flexKey, map);
    }

    public static void showList(Map<String, String> name, String pageKey, String pageNumber, IFormView view, Map<String, String> pageIds) {
        ListShowParameter listShowParameter = new ListShowParameter();
        Map customParams = view.getFormShowParameter().getCustomParams();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(pageKey);
        listShowParameter.setFormId("hr_list");
        listShowParameter.setBillFormId(pageNumber);
        listShowParameter.setSendToClient(true);
        listShowParameter.setLookUp(false);
        listShowParameter.setCustomParam("type", (Object)"list");
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setCustomParam("pageName", name);
        view.showForm((FormShowParameter)listShowParameter);
        String pageId = listShowParameter.getPageId();
        pageIds.put(pageNumber, pageId);
    }

    public static void showForm(Map<String, String> name, String pageKey, String pageNumber, IFormView view, Map<String, String> pageIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        Map customParams = view.getFormShowParameter().getCustomParams();
        formShowParameter.getOpenStyle().setTargetKey(pageKey);
        formShowParameter.setSendToClient(true);
        formShowParameter.setFormId(pageNumber);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCustomParam("pageName", name);
        view.showForm(formShowParameter);
        String pageId = formShowParameter.getPageId();
        pageIds.put(pageNumber, pageId);
    }
}

