/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.TaxFileInfoService;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class BaseTaxFileInfoService
implements TaxFileInfoService {
    private static final Log LOGGER = LogFactory.getLog(BaseTaxFileInfoService.class);
    private final Set<String> keyProps;
    private final Set<String> originalKeyProps;
    private final Map<String, String> propMappings;

    protected BaseTaxFileInfoService(Set<String> keyProps, Map<String, String> propMappings) {
        this.originalKeyProps = keyProps;
        this.propMappings = propMappings;
        this.keyProps = Sets.newHashSetWithExpectedSize((int)keyProps.size());
        keyProps.forEach(ele -> this.keyProps.add((String)propMappings.get(ele)));
    }

    public DynamicObject[] findInfo(Map<Long, DynamicObject> map, TaxFileOpContext taxFileOpContext) {
        PropertiesQueryInfo queryInfo = new PropertiesQueryInfo(this.entityNumber());
        String sourceFrom = taxFileOpContext.getOptionPara("sourceFrom");
        if (CollectionUtils.isEmpty((Map)((Map)taxFileOpContext.getExtraInfo().get(this.entityNumber()))) && StringUtils.isNotEmpty((String)sourceFrom) && "save".equals(sourceFrom)) {
            return new DynamicObject[0];
        }
        ArrayList filters = Lists.newArrayListWithCapacity((int)10);
        filters.add(new QFilter("taxfile.id", "in", map.keySet()));
        filters.add(new QFilter("status", "!=", (Object)"E"));
        this.decorateFilterForFindInfo(filters, map, taxFileOpContext);
        return SitDataServiceHelper.commonQuery(queryInfo, filters.toArray(new QFilter[0]));
    }

    protected void decorateFilterForFindInfo(List<QFilter> filters, Map<Long, DynamicObject> map, TaxFileOpContext taxFileOpContext) {
    }

    public OperationResult validate(Map<Long, DynamicObject> extraInfoMap, Map<Long, DynamicObject> taxFileMap, TaxFileOpContext taxFileOpContext) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("taxfile_save", "true");
        option.setVariableValue("action", "1");
        option.setVariableValue("status", taxFileOpContext.getOptionPara("status"));
        option.setVariableValue("src", taxFileOpContext.getOptionPara("src"));
        option.setVariableValue("validate", "1");
        option.setVariableValue("relateFileKeyInfo", SerializationUtils.toJsonString((Object)taxFileOpContext.computeKeyInfoIfAbsent(0)));
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckDataPermission", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        return OperationServiceHelper.executeOperate((String)taxFileOpContext.getOpKey(), (String)this.entityNumber(), (DynamicObject[])extraInfoMap.values().toArray(new DynamicObject[0]), (OperateOption)option);
    }

    public OperationResult operate(Map<Long, DynamicObject> extraInfoMap, DynamicObject[] taxFiles, TaxFileOpContext taxFileOpContext) {
        List allErrorOrValidateInfo;
        ArrayList saveList = Lists.newArrayListWithExpectedSize((int)taxFiles.length);
        ArrayList updateAndNewVersionList = Lists.newArrayListWithExpectedSize((int)taxFiles.length);
        ArrayList newAndAuditList = Lists.newArrayListWithExpectedSize((int)taxFiles.length);
        String entityNumber = this.entityNumber();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        boolean isSaveAfterAudit = "saveafteraudit".equals(taxFileOpContext.getOpKey());
        for (DynamicObject taxFile : taxFiles) {
            boolean saveOrNoChange;
            long fileId = taxFile.getLong("boid");
            DynamicObject object = extraInfoMap.get(fileId);
            boolean bl = saveOrNoChange = isSaveAfterAudit && object.getLastDirty().isEmpty();
            if (object == null || saveOrNoChange) continue;
            if (!taxFile.getBoolean("iscurrentversion")) {
                if (object.getDataEntityState().getFromDatabase()) {
                    DynamicObject hisDyn = serviceHelper.generateEmptyDynamicObject();
                    SITBaseDataHelper.transferDynamicObject(object, hisDyn, null, null);
                    hisDyn.set("status", (Object)"C");
                    hisDyn.set("boid", (Object)object.getLong("id"));
                    updateAndNewVersionList.add(hisDyn);
                    continue;
                }
                newAndAuditList.add(object);
                continue;
            }
            saveList.add(object);
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption option = OperateOption.create();
        option.setVariableValue("action", "2");
        option.setVariableValue("ITCFILE_ACTIONWAY", taxFileOpContext.getOptionPara("ITCFILE_ACTIONWAY"));
        option.setVariableValue("status", taxFileOpContext.getOptionPara("status"));
        option.setVariableValue("validate", "2");
        option.setVariableValue("relateFileKeyInfo", SerializationUtils.toJsonString((Object)taxFileOpContext.computeKeyInfoIfAbsent(0)));
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckDataPermission", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            LOGGER.info("by cyh operate saveList : {}    {}  entityNumber = {}", new Object[]{saveList.size(), taxFileOpContext.getOpKey(), entityNumber});
            OperationResult saveResult = opImpl.localInvokeOperation(taxFileOpContext.getOpKey(), saveList.toArray(new DynamicObject[0]), option);
            allErrorOrValidateInfo = saveResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                allErrorOrValidateInfo.forEach(obj -> LOGGER.info("by cyh save error : entityNumber = {} id = {} msg = {}", new Object[]{entityNumber, obj.getPkValue(), obj.getMessage()}));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)updateAndNewVersionList)) {
            LOGGER.info("by cyh operate updateAndNewVersionList : {}    {}  entityNumber = {}", new Object[]{updateAndNewVersionList.size(), taxFileOpContext.getOpKey(), entityNumber});
            OperationResult auditResult = opImpl.localInvokeOperation("saveafteraudit", updateAndNewVersionList.toArray(new DynamicObject[0]), option);
            allErrorOrValidateInfo = auditResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                allErrorOrValidateInfo.forEach(obj -> LOGGER.info("by cyh save error : entityNumber = {} id = {} msg = {}", new Object[]{entityNumber, obj.getPkValue(), obj.getMessage()}));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)newAndAuditList)) {
            LOGGER.info("by cyh operate newAndAuditList : {}    {}  entityNumber = {}", new Object[]{newAndAuditList.size(), taxFileOpContext.getOpKey(), entityNumber});
            option.setVariableValue("status", "C");
            OperationResult auditResult = opImpl.localInvokeOperation("save", newAndAuditList.toArray(new DynamicObject[0]), option);
            allErrorOrValidateInfo = auditResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                allErrorOrValidateInfo.forEach(obj -> LOGGER.info("by cyh save error : entityNumber = {} id = {} msg = {}", new Object[]{entityNumber, obj.getPkValue(), obj.getMessage()}));
            }
        }
        return new OperationResult();
    }

    public Map<String, Object> findKeyInfoByFileBoId(DynamicObject taxFile) {
        long fileBoId = taxFile.getLong("boid");
        boolean isCurrent = taxFile.getBoolean("iscurrentversion");
        DateRange dateRange = null;
        if (!isCurrent) {
            dateRange = new DateRange(taxFile.getDate("bsed"), taxFile.getDate("bsled"));
        }
        return this.findKeyInfoByFileBoId(fileBoId, isCurrent, dateRange);
    }

    public Map<Long, Long> findLatestVersionByFileBoIdsAndDate(List<Long> taxFileBoids, Date start, Date end) {
        DateRange dateRange = new DateRange(start, end);
        return this.findLatestVersionByFileBoIdsAndDate(taxFileBoids, dateRange);
    }

    public DynamicObject findInfoByVid(long vid, Set<String> props) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])props.toArray(new String[0]));
        return SitDataServiceHelper.commonQueryOne(info, new QFilter[]{new QFilter("id", "=", (Object)vid)});
    }

    public Map<String, Object> findMapByVid(long vid, Set<String> props) {
        return this.dynamicObjectToMap(this.findInfoByVid(vid, props), props);
    }

    public Map<Long, Map<String, Object>> findInfoByVidSet(Set<Long> vidSet, Set<String> props) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])props.toArray(new String[0]));
        DynamicObject[] objects = SitDataServiceHelper.commonQuery(info, new QFilter[]{new QFilter("id", "in", vidSet)});
        HashMap res = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)props.size());
            for (String prop : props) {
                result.put(prop, object.get(prop));
            }
            res.put(object.getLong("id"), result);
        }
        return res;
    }

    public Map<Long, Map<String, Object>> findInfoByVidSetResultByFile(Set<Long> vidSet, Set<String> props) {
        props.add("taxfile");
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])props.toArray(new String[0]));
        DynamicObject[] objects = SitDataServiceHelper.commonQuery(info, new QFilter[]{new QFilter("id", "in", vidSet)});
        HashMap res = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)props.size());
            for (String prop : props) {
                result.put(prop, object.get(prop));
            }
            res.put(object.getLong("taxfile.id"), result);
        }
        return res;
    }

    public BaseResult<?> abandonByFiles(Map<Long, DynamicObject> map) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityNumber());
        Object[] query = serviceHelper.query("id,status,enable", new QFilter[]{new QFilter("taxfile.id", "in", map.keySet())});
        if (ArrayUtils.isEmpty((Object[])query)) {
            return BaseResult.success(null);
        }
        for (Object entry : query) {
            entry.set("status", (Object)"E");
        }
        serviceHelper.save((DynamicObject[])query);
        return BaseResult.success((Object)query);
    }

    public BaseResult<?> deleteByFiles(Map<Long, DynamicObject> map) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityNumber());
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("taxfile.id", "in", map.keySet())});
        return BaseResult.success(null);
    }

    public void gatherInfoFrom(TaxFileOpContext taxFileOpContext, DynamicObject[] taxFiles, Map<Long, DynamicObject> extraInfos, boolean usePlainProp) {
        if (CollectionUtils.isEmpty(extraInfos)) {
            return;
        }
        for (Map.Entry<Long, DynamicObject> entry : extraInfos.entrySet()) {
            Map map = taxFileOpContext.computeKeyInfoOfTaxFileIfAbsent(entry.getKey().longValue());
            DynamicObject value = entry.getValue();
            DataEntityPropertyCollection properties = value.getDynamicObjectType().getProperties();
            for (String prop : this.originalKeyProps) {
                String realProp = this.realProp(prop);
                if (!properties.containsKey((Object)realProp)) continue;
                if (usePlainProp) {
                    map.put(prop, value.get(realProp));
                    continue;
                }
                map.put(this.fullPropKey(realProp), value.get(realProp));
            }
        }
    }

    protected String realProp(String prop) {
        String second;
        String first;
        int index = prop.indexOf(46);
        if (index > 0) {
            first = prop.substring(0, index);
            second = prop.substring(index);
        } else {
            first = prop;
            second = "";
        }
        String realProp = this.propMappings().get(first);
        return realProp == null ? null : realProp + second;
    }

    public Map<String, String> propMappings() {
        return this.propMappings;
    }

    public Set<String> keyProps() {
        return this.keyProps;
    }

    protected Map<String, Object> dynamicObjectToMap(DynamicObject object, Set<String> props) {
        if (object == null) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)props.size());
        for (String prop : props) {
            String realProp = this.realProp(prop);
            realProp = realProp == null ? prop : realProp;
            result.put(prop, object.get(realProp));
        }
        return result;
    }

    protected abstract Map<String, Object> findKeyInfoByFileBoId(long var1, boolean var3, DateRange var4);

    protected abstract Map<Long, Long> findLatestVersionByFileBoIdsAndDate(List<Long> var1, DateRange var2);
}

