/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.sit.sitbp.business.service.BaseTaxFileInfoService;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;

public abstract class NonHisTaxFileInfoService
extends BaseTaxFileInfoService {
    protected NonHisTaxFileInfoService(Set<String> keyProps, Map<String, String> propMapping) {
        super(keyProps, propMapping);
    }

    @Override
    public Map<String, Object> findKeyInfoByFileBoId(long fileBoId, boolean isCurrent, DateRange dateRange) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])this.keyProps().toArray(new String[0]));
        DynamicObject object = SitDataServiceHelper.commonQueryOne(info, new QFilter[]{new QFilter("taxfile.id", "=", (Object)fileBoId), new QFilter("status", "!=", (Object)"E")});
        return this.dynamicObjectToMap(object, this.keyProps());
    }

    public void gatherInfoOf(Map<Long, Map<String, Object>> map, Map<Long, List<DynamicObject>> taxFiles, Map<String, String> props, TaxPeriodEntity dateRange, boolean useBoId) {
        DynamicObject[] query;
        Set propsTemp = Sets.newConcurrentHashSet(props.values());
        propsTemp.add("taxfile");
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])propsTemp.toArray(new String[0]));
        Set<Long> fileBoId = taxFiles.keySet();
        for (DynamicObject object : query = SitDataServiceHelper.commonQuery(info, new QFilter[]{new QFilter("taxfile.id", "in", fileBoId)})) {
            long taxFileBoId = object.getLong("taxfile.id");
            if (useBoId) {
                Map<String, Object> objectMap = map.get(taxFileBoId);
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    objectMap.put(entry.getKey(), object.get(this.realProp(entry.getKey())));
                }
                continue;
            }
            List<DynamicObject> files = taxFiles.get(taxFileBoId);
            if (files == null) continue;
            for (DynamicObject file : files) {
                Map<String, Object> objectMap = map.get(file.getLong("id"));
                if (objectMap == null) continue;
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    objectMap.put(entry.getKey(), object.get(this.realProp(entry.getKey())));
                }
            }
        }
    }

    @Override
    protected Map<Long, Long> findLatestVersionByFileBoIdsAndDate(List<Long> taxFileBoids, DateRange dateRange) {
        return Maps.newHashMapWithExpectedSize((int)0);
    }
}

