/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.service.BaseTaxFileInfoService;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileOpContext;

public abstract class NonTimeSeqTaxFileInfoService
extends BaseTaxFileInfoService {
    protected NonTimeSeqTaxFileInfoService(Set<String> keyProps, Map<String, String> propMapping) {
        super(keyProps, propMapping);
    }

    @Override
    protected void decorateFilterForFindInfo(List<QFilter> filters, Map<Long, DynamicObject> map, TaxFileOpContext taxFileOpContext) {
        filters.add(new QFilter("datastatus", "not in", (Object)new String[]{DataStatusEnum.DELETE.getCode(), DataStatusEnum.INVALID.getCode()}));
    }

    @Override
    public Map<String, Object> findKeyInfoByFileBoId(long fileBoId, boolean isCurrent, DateRange dateRange) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])this.keyProps().toArray(new String[0]));
        DynamicObject object = SitDataServiceHelper.commonQueryOne(info, new QFilter[]{new QFilter("taxfile.id", "=", (Object)fileBoId), new QFilter("status", "!=", (Object)"E"), new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode()), new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.DRAFT.getCode()}).or(new QFilter("datastatus", "=", (Object)" "))});
        return this.dynamicObjectToMap(object, this.keyProps());
    }

    @Override
    protected Map<Long, Long> findLatestVersionByFileBoIdsAndDate(List<Long> taxFileBoids, DateRange dateRange) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])this.keyProps().toArray(new String[0]));
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter boidFilter = new QFilter("taxfile.id", "in", taxFileBoids);
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{filter, statusFilter, dataStatusFilter, boidFilter});
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NonTimeSeqTaxFileInfoService.class.getName(), (String)this.entityNumber(), (String)"id,taxfile.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");){
            HashMap result = Maps.newHashMapWithExpectedSize((int)taxFileBoids.size());
            for (Row row : dataSet) {
                Long taxFileId = row.getLong("taxfile.id");
                Long id = row.getLong("id");
                result.putIfAbsent(taxFileId, id);
            }
            HashMap hashMap = result;
            return hashMap;
        }
    }

    public void gatherInfoOf(Map<Long, Map<String, Object>> map, Map<Long, List<DynamicObject>> taxFiles, Map<String, String> props, TaxPeriodEntity dateRange, boolean useBoId) {
        DynamicObject[] query;
        Set propsTemp = Sets.newConcurrentHashSet(props.values());
        propsTemp.add("taxfile");
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])propsTemp.toArray(new String[0]));
        Set<Long> fileBoId = taxFiles.keySet();
        for (DynamicObject object : query = SitDataServiceHelper.commonQuery(info, new QFilter[]{new QFilter("taxfile.id", "in", fileBoId), new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode()), new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.DRAFT.getCode()}).or(new QFilter("datastatus", "=", (Object)" "))})) {
            long taxFileBoId = object.getLong("taxfile.id");
            if (useBoId) {
                Map<String, Object> objectMap = map.get(taxFileBoId);
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    objectMap.put(entry.getKey(), object.get(this.realProp(entry.getKey())));
                }
                continue;
            }
            List<DynamicObject> files = taxFiles.get(taxFileBoId);
            if (files == null) continue;
            for (DynamicObject file : files) {
                Map<String, Object> objectMap = map.get(file.getLong("id"));
                if (objectMap == null) continue;
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    objectMap.put(entry.getKey(), object.get(this.realProp(entry.getKey())));
                }
            }
        }
    }

    public Map<Long, DynamicObject> getRelatedInfo(Set<Long> taxFileBoIds, Map<Long, Date> taxFileBoIdAndBsed, Set<String> props) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)"-2");
        QFilter boIdFilter = new QFilter("taxfile.id", "in", taxFileBoIds);
        QFilter[] qFilters = new QFilter[]{filter, statusFilter, dataStatusFilter, boIdFilter};
        if (CollectionUtils.isEmpty(props)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityNumber());
        DynamicObject[] dys = serviceHelper.query(props.toString(), qFilters);
        if (null == dys || dys.length == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return Arrays.stream(dys).collect(Collectors.toMap(ele -> ele.getLong("taxfile.id"), ele -> ele));
    }
}

