/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.service.NonHisTaxFileInfoService;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public abstract class PersonInfoServiceImpl
extends NonHisTaxFileInfoService {
    protected PersonInfoServiceImpl(Set<String> keyProps, Map<String, String> propMapping) {
        super(keyProps, propMapping);
    }

    public String generaName() {
        return "person";
    }

    public boolean isSubInfo() {
        return false;
    }

    public long getFileId(DynamicObject dynamicObject) {
        return 0L;
    }

    public void setFile(DynamicObject extraInfo, DynamicObject taxFile) {
    }

    public String subPropName() {
        return "person";
    }

    @Override
    public DynamicObject[] findInfo(Map<Long, DynamicObject> map, TaxFileOpContext taxFileOpContext) {
        List personList;
        if ("audit".equals(taxFileOpContext.getOpKey())) {
            personList = this.getPersonInForAudit(map);
        } else {
            Set personIds = map.values().stream().map(ele -> ele.getLong("person.id")).collect(Collectors.toSet());
            personList = (List)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findByIdList", (Object[])new Object[]{Lists.newArrayList(personIds), null});
        }
        return personList.toArray(new DynamicObject[0]);
    }

    @Override
    public OperationResult validate(Map<Long, DynamicObject> extraInfoMap, Map<Long, DynamicObject> taxFileMap, TaxFileOpContext taxFileOpContext) {
        return new OperationResult();
    }

    @Override
    public OperationResult operate(Map<Long, DynamicObject> extraInfoMap, DynamicObject[] taxFiles, TaxFileOpContext taxFileOpContext) {
        return new OperationResult();
    }

    @Override
    public Map<String, Object> findKeyInfoByFileBoId(long fileBoId, boolean isCurrent, DateRange dateRange) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxfile");
        QFilter filter = new QFilter("boid", "=", (Object)fileBoId);
        filter.and("iscurrentversion", "=", (Object)isCurrent);
        filter.and("bsed", "<", (Object)dateRange.getTo());
        filter.and("bsled", ">", (Object)dateRange.getFrom());
        DynamicObject[] queryFiles = helper.query(new QFilter[]{filter}, "bsed desc");
        return this.dynamicObjectToMap(this.findInfoByFileFromIit(queryFiles[0], isCurrent, dateRange, this.keyProps()), this.keyProps());
    }

    @Override
    public Map<String, Object> findKeyInfoByFileBoId(DynamicObject taxFile) {
        boolean isCurrent = taxFile.getBoolean("iscurrentversion");
        DateRange dateRange = null;
        if (!isCurrent) {
            dateRange = new DateRange(taxFile.getDate("bsed"), taxFile.getDate("bsled"));
        }
        return this.dynamicObjectToMap(this.findInfoByFileFromIit(taxFile, isCurrent, dateRange, this.keyProps()), this.keyProps());
    }

    @Override
    public void gatherInfoOf(Map<Long, Map<String, Object>> map, Map<Long, List<DynamicObject>> taxFiles, Map<String, String> props, TaxPeriodEntity dateRange, boolean useBoId) {
        HashMap fileIdsOfPerson = Maps.newHashMapWithExpectedSize((int)taxFiles.size());
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)taxFiles.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : taxFiles.entrySet()) {
            List<DynamicObject> taxFileList = entry.getValue();
            long personId = taxFileList.get(0).getLong("person.id");
            personIds.add(personId);
            List fileIds = fileIdsOfPerson.computeIfAbsent(personId, ky -> Lists.newArrayListWithExpectedSize((int)2));
            if (useBoId) {
                fileIds.add(entry.getKey());
                continue;
            }
            for (DynamicObject taxFile : taxFileList) {
                long fileId = taxFile.getLong("id");
                fileIds.add(fileId);
            }
        }
        List personList = (List)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findByIdList", (Object[])new Object[]{Lists.newArrayList((Iterable)personIds), Sets.newHashSet(props.values())});
        if (CollectionUtils.isEmpty((Collection)personList)) {
            return;
        }
        for (DynamicObject object : personList) {
            List fileIds = (List)fileIdsOfPerson.get(object.getLong("id"));
            if (CollectionUtils.isEmpty((Collection)fileIds)) continue;
            for (Long fileId : fileIds) {
                Map objectMap = map.computeIfAbsent(fileId, ky -> Maps.newHashMapWithExpectedSize((int)props.size()));
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    objectMap.put(entry.getKey(), object.get(this.realProp(entry.getKey())));
                }
            }
        }
    }

    @Override
    public DynamicObject findInfoByVid(long vid, Set<String> props) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxfile");
        QFilter filter = new QFilter("id", "=", (Object)vid);
        DynamicObject taxFile = helper.queryOne(new QFilter[]{filter});
        boolean isCurrent = taxFile.getBoolean("iscurrentversion");
        DateRange dateRange = null;
        if (!isCurrent) {
            dateRange = new DateRange(taxFile.getDate("bsed"), taxFile.getDate("bsled"));
        }
        return this.findInfoByFileFromIit(taxFile, isCurrent, dateRange, props);
    }

    @Override
    public Map<String, Object> findMapByVid(long vid, Set<String> props) {
        DynamicObject infoByVid = this.findInfoByVid(vid, props);
        return this.dynamicObjectToMap(infoByVid, props);
    }

    @Override
    public Map<Long, Map<String, Object>> findInfoByVidSet(Set<Long> vidSet, Set<String> props) {
        return Maps.newHashMap();
    }

    @Override
    public BaseResult<?> abandonByFiles(Map<Long, DynamicObject> map) {
        return BaseResult.success(null);
    }

    @Override
    public BaseResult<?> deleteByFiles(Map<Long, DynamicObject> map) {
        return BaseResult.success(null);
    }

    public String entityNumber() {
        return "iit_person";
    }

    private DynamicObject findInfoByFileFromIit(DynamicObject taxFile, boolean isCurrent, DateRange dateRange, Set<String> props) {
        DynamicObject infoObject = isCurrent ? (DynamicObject)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findById", (Object[])new Object[]{taxFile.getLong("person.id"), props}) : (DynamicObject)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findByIdAndDate", (Object[])new Object[]{taxFile.getLong("person.id"), dateRange, props});
        return infoObject;
    }

    private List<DynamicObject> getPersonInForAudit(Map<Long, DynamicObject> map) {
        ArrayList personList = Lists.newArrayListWithCapacity((int)map.size());
        for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
            DynamicObject taxFile = entry.getValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"iit_person");
            dynamicObject.set("id", (Object)taxFile.getString("person.id"));
            dynamicObject.set("number", (Object)taxFile.getString("personversion.number"));
            dynamicObject.set("name", (Object)taxFile.getString("personversion.name"));
            dynamicObject.set("taxcrdltype", taxFile.get("taxcrdltype"));
            dynamicObject.set("credentialsnum", (Object)taxFile.getString("percre.number"));
            dynamicObject.set("nationality", taxFile.get("pernontsprop.nationality"));
            dynamicObject.set("birthday", taxFile.get("pernontsprop.birthday"));
            dynamicObject.set("gender", taxFile.get("pernontsprop.gender"));
            dynamicObject.set("education", taxFile.get("pereduexp.education"));
            dynamicObject.set("marriagestatus", taxFile.get("pertsprop.marriagestatus"));
            dynamicObject.set("credentialstype", taxFile.get("percre.credentialstype"));
            personList.add(dynamicObject);
        }
        return personList;
    }
}

