/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.service;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.api.SitAppReportService;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.enums.CalOpTypeEnum;
import kd.sit.sitbp.common.model.TaxRawDataBatch;
import kd.sit.sitbp.common.util.SitBaseUtil;

public class SitAppReportServiceImpl
implements SitAppReportService {
    @Override
    public void generateTaxCalReport(TaxRawDataBatch dataBatch, CalOpTypeEnum calOpType) {
        String appId = dataBatch.getAppId();
        String recordEntityName = appId + "_taxtaskrecord";
        HRBaseServiceHelper recordServiceHelper = new HRBaseServiceHelper(recordEntityName);
        DynamicObject taxTaskOpRecord = recordServiceHelper.generateEmptyDynamicObject();
        taxTaskOpRecord.set("id", (Object)ORM.create().genLongId(recordEntityName));
        taxTaskOpRecord.set("optype", (Object)calOpType.getOpType());
        taxTaskOpRecord.set("result", (Object)calOpType.getResult());
        if (calOpType == CalOpTypeEnum.CALCULATE) {
            taxTaskOpRecord.set("showtime", (Object)new Date());
        }
        recordServiceHelper.saveOne(taxTaskOpRecord);
        dataBatch.addFixParam("calculateOpId", (Object)taxTaskOpRecord.getLong("id"));
        DynamicObject referRecord = this.cloneTaxTaskRecord(taxTaskOpRecord, calOpType == CalOpTypeEnum.CALCULATE ? TaxTaskGuideOpEnum.REFER_ALL_SRC_DATA : TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_PERSON);
        dataBatch.addFixParam("referOpId", (Object)referRecord.getLong("id"));
    }

    @Override
    public DynamicObject cloneTaxTaskRecord(DynamicObject original, TaxTaskGuideOpEnum opEnum) {
        String name = original.getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(name);
        DynamicObject taxTaskRecordNew = serviceHelper.generateEmptyDynamicObject();
        taxTaskRecordNew.set("id", (Object)ORM.create().genLongId(name));
        taxTaskRecordNew.set("optype", (Object)opEnum.getCode());
        taxTaskRecordNew.set("result", (Object)(opEnum.name().startsWith("ROLLBACK") ? "0" : "1"));
        taxTaskRecordNew.set("taxtask", original.get("taxtask"));
        taxTaskRecordNew.set("step", original.get("step"));
        taxTaskRecordNew.set("taxgroup", original.get("taxgroup"));
        taxTaskRecordNew.set("taxcategory", original.get("taxcategory"));
        String description = original.getString("description");
        HashMap<String, Long> param = !StringUtils.isEmpty((CharSequence)description) ? (HashMap<String, Long>)SerializationUtils.fromJsonString((String)description, HashMap.class) : new HashMap<String, Long>(2);
        param.put("from", original.getLong("id"));
        taxTaskRecordNew.set("description", (Object)SerializationUtils.toJsonString(param));
        if (TaxTaskGuideOpEnum.isYes(opEnum.getCode())) {
            taxTaskRecordNew.set("showtime", (Object)new Date());
        }
        SitBaseUtil.initSystemProp((DynamicObject)taxTaskRecordNew);
        serviceHelper.saveOne(taxTaskRecordNew);
        return taxTaskRecordNew;
    }
}

