/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.service.TimeSeqTaxFileInfoService;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class TaxFileInfoServiceImpl
extends TimeSeqTaxFileInfoService {
    protected TaxFileInfoServiceImpl(Set<String> keyProps, Map<String, String> propMapping) {
        super(keyProps, propMapping);
    }

    public String generaName() {
        return "taxfile";
    }

    public long getFileId(DynamicObject taxFile) {
        return taxFile.getLong("id");
    }

    public void setFile(DynamicObject extraInfo, DynamicObject taxFile) {
    }

    @Override
    public DynamicObject[] findInfo(Map<Long, DynamicObject> map, TaxFileOpContext taxFileOpContext) {
        return map.values().toArray(new DynamicObject[0]);
    }

    @Override
    public OperationResult validate(Map<Long, DynamicObject> extraInfoMap, Map<Long, DynamicObject> taxFileMap, TaxFileOpContext taxFileOpContext) {
        return new OperationResult();
    }

    @Override
    public OperationResult operate(Map<Long, DynamicObject> extraInfoMap, DynamicObject[] taxFiles, TaxFileOpContext taxFileOpContext) {
        return new OperationResult();
    }

    @Override
    public Map<String, Object> findKeyInfoByFileBoId(DynamicObject taxFile) {
        Set<String> keyProps = this.keyProps();
        HashMap result = Maps.newHashMapWithExpectedSize((int)keyProps.size());
        for (String keyProp : keyProps) {
            result.put(keyProp, taxFile.get(keyProp));
        }
        return result;
    }

    @Override
    public Map<Long, Map<String, Object>> findInfoByVidSetResultByFile(Set<Long> vidSet, Set<String> props) {
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])props.toArray(new String[0]));
        DynamicObject[] objects = SitDataServiceHelper.commonQuery(info, new QFilter[]{new QFilter("id", "in", vidSet)});
        HashMap res = Maps.newHashMapWithExpectedSize((int)objects.length);
        for (DynamicObject object : objects) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)props.size());
            for (String prop : props) {
                result.put(prop, object.get(prop));
            }
            res.put(object.getLong("boid"), result);
        }
        return res;
    }

    @Override
    public void gatherInfoOf(Map<Long, Map<String, Object>> result, Map<Long, List<DynamicObject>> taxFiles, Map<String, String> props, TaxPeriodEntity dateRange, boolean useBoId) {
        for (Map.Entry<Long, List<DynamicObject>> entry : taxFiles.entrySet()) {
            List<DynamicObject> dynamicObjects = entry.getValue();
            if (useBoId) {
                DynamicObject dynamicObject = dynamicObjects.get(0);
                Map<String, Object> map = result.get(entry.getKey());
                for (Map.Entry<String, String> propEntry : props.entrySet()) {
                    map.put(propEntry.getKey(), dynamicObject.get(this.realProp(propEntry.getKey())));
                }
                continue;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                Map<String, Object> map = result.get(dynamicObject.getLong("id"));
                for (Map.Entry<String, String> propEntry : props.entrySet()) {
                    map.put(propEntry.getKey(), dynamicObject.get(this.realProp(propEntry.getKey())));
                }
            }
        }
    }

    @Override
    public BaseResult<?> abandonByFiles(Map<Long, DynamicObject> map) {
        DynamicObject[] query;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityNumber());
        for (DynamicObject value : query = serviceHelper.query("id,status,bsled,datastatus", new QFilter[]{new QFilter("boid", "in", map.keySet())})) {
            value.set("status", (Object)"E");
        }
        serviceHelper.save(query);
        return BaseResult.success(null);
    }

    @Override
    public BaseResult<?> deleteByFiles(Map<Long, DynamicObject> map) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityNumber());
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("boid", "in", map.keySet())});
        return BaseResult.success(null);
    }

    public int priority() {
        return Integer.MIN_VALUE;
    }

    public String fullPropKey(String propKey) {
        return propKey;
    }
}

