/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.service.BaseTaxFileInfoService;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.SitDateUtil;

public abstract class TimeSeqTaxFileInfoService
extends BaseTaxFileInfoService {
    protected TimeSeqTaxFileInfoService(Set<String> keyProps, Map<String, String> propMapping) {
        super(keyProps, propMapping);
    }

    @Override
    protected void decorateFilterForFindInfo(List<QFilter> filters, Map<Long, DynamicObject> map, TaxFileOpContext taxFileOpContext) {
        filters.add(new QFilter("datastatus", "not in", (Object)new String[]{DataStatusEnum.DELETE.getCode(), DataStatusEnum.INVALID.getCode()}));
    }

    @Override
    public DynamicObject[] findInfo(Map<Long, DynamicObject> fileMap, TaxFileOpContext taxFileOpContext) {
        DynamicObject[] multiVersionRes = super.findInfo(fileMap, taxFileOpContext);
        HashMap finalRes = Maps.newHashMapWithExpectedSize((int)fileMap.size());
        for (DynamicObject subInfo : multiVersionRes) {
            DynamicObject previousSubInfo;
            long fileId = this.getFileId(subInfo);
            DynamicObject taxFile = fileMap.get(fileId);
            Date bsledDate = subInfo.getDate("bsled");
            if (bsledDate == null) {
                bsledDate = DateUtils.parseDate((Object)"2999-12-30");
            }
            if (!SitDateUtil.isDateRangeOverlap((Date)taxFile.getDate("bsed"), (Date)taxFile.getDate("bsled"), (Date)subInfo.getDate("bsed"), (Date)bsledDate) || (previousSubInfo = (DynamicObject)finalRes.get(fileId)) != null && previousSubInfo.getDate("bsled") != null && !bsledDate.after(previousSubInfo.getDate("bsled"))) continue;
            finalRes.put(fileId, subInfo);
        }
        return new ArrayList(finalRes.values()).toArray(new DynamicObject[0]);
    }

    @Override
    public Map<String, Object> findKeyInfoByFileBoId(long fileBoId, boolean isCurrent, DateRange dateRange) {
        Object object = null;
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])this.keyProps().toArray(new String[0]));
        if (isCurrent) {
            object = SitDataServiceHelper.commonQueryOne(info, new QFilter[]{new QFilter("taxfile.id", "=", (Object)fileBoId), new QFilter("status", "!=", (Object)"E"), new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode()), new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.DRAFT.getCode(), DataStatusEnum.TO_EFFECT.getCode()})});
        } else {
            Object[] dynamicObjects;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
            filters.add(new QFilter("taxfile.id", "=", (Object)fileBoId));
            filters.add(new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode()));
            filters.add(new QFilter("status", "!=", (Object)"E"));
            filters.add(new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.EXPIRED.getCode(), DataStatusEnum.TO_EFFECT.getCode()}));
            if (dateRange.getFrom() != null) {
                filters.add(new QFilter("bsled", ">=", (Object)dateRange.getFrom()).or(new QFilter("bsled", "is null", null)));
            }
            if (dateRange.getTo() != null) {
                filters.add(new QFilter("bsed", "<=", (Object)dateRange.getTo()));
            }
            if (!ArrayUtils.isEmpty((Object[])(dynamicObjects = SitDataServiceHelper.commonQuery(info, filters.toArray(new QFilter[0]), "bsed desc")))) {
                object = dynamicObjects[0];
            }
        }
        return this.dynamicObjectToMap((DynamicObject)object, this.keyProps());
    }

    public void gatherInfoOf(Map<Long, Map<String, Object>> map, Map<Long, List<DynamicObject>> taxFiles, Map<String, String> props, TaxPeriodEntity dateRange, boolean useBoId) {
        DynamicObject[] query;
        Set<Long> fileBoId = taxFiles.keySet();
        ArrayList filters = Lists.newArrayListWithCapacity((int)(dateRange == null ? 2 : 4));
        if (dateRange != null) {
            boolean calSense;
            filters.add(new QFilter("bsed", "<=", (Object)dateRange.getEndDate()));
            filters.add(new QFilter("bsled", ">=", (Object)dateRange.getStartDate()).or("bsled", "is null", null));
            boolean bl = calSense = !dateRange.getStartDate().equals(dateRange.getEndDate());
            if (calSense) {
                filters.add(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
            } else {
                filters.add(new QFilter("datastatus", "not in", (Object)new String[]{"-1", "-2"}));
            }
        }
        filters.add(new QFilter("taxfile.id", "in", fileBoId));
        HashSet propsTemp = Sets.newHashSet(props.values());
        propsTemp.add("taxfile");
        propsTemp.add("datastatus");
        propsTemp.add("iscurrentversion");
        propsTemp.add("bsed");
        propsTemp.add("bsled");
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)this.entityNumber(), (String[])propsTemp.toArray(new String[0]));
        for (DynamicObject object : query = SitDataServiceHelper.commonQuery(info, filters.toArray(new QFilter[0]), "bsed desc")) {
            Map<String, Object> objectMap;
            long taxFileId = object.getLong("taxfile.id");
            DynamicObject taxFile = this.matchTaxFile(taxFiles.get(taxFileId), object);
            if (taxFile == null || (objectMap = map.get(useBoId ? taxFile.get("boid") : Long.valueOf(taxFile.getLong("id")))) == null) continue;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                objectMap.put(entry.getKey(), object.get(this.realProp(entry.getKey())));
            }
        }
    }

    private DynamicObject matchTaxFile(List<DynamicObject> taxFiles, DynamicObject object) {
        for (DynamicObject taxFile : taxFiles) {
            boolean isCurrentVersion;
            boolean bl = isCurrentVersion = taxFile.getBoolean("iscurrentversion") && object.getBoolean("iscurrentversion");
            if (!isCurrentVersion && !SitDateUtil.isDateRangeOverlap((Date)taxFile.getDate("bsed"), (Date)taxFile.getDate("bsled"), (Date)object.getDate("bsed"), (Date)object.getDate("bsled"))) continue;
            return taxFile;
        }
        return null;
    }

    @Override
    protected Map<Long, Long> findLatestVersionByFileBoIdsAndDate(List<Long> taxFileBoids, DateRange dateRange) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter bsedFilter = new QFilter("bsed", "<", (Object)dateRange.getTo());
        QFilter bsledFilter = new QFilter("bsled", ">", (Object)dateRange.getFrom());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"});
        QFilter boidFilter = new QFilter("taxfile.id", "in", taxFileBoids);
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{filter, bsedFilter, bsledFilter, statusFilter, dataStatusFilter, boidFilter});
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)TimeSeqTaxFileInfoService.class.getName(), (String)this.entityNumber(), (String)"id,taxfile.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"bsed desc");){
            HashMap result = Maps.newHashMapWithExpectedSize((int)taxFileBoids.size());
            for (Row row : dataSet) {
                Long taxFileId = row.getLong("taxfile.id");
                Long id = row.getLong("id");
                result.putIfAbsent(taxFileId, id);
            }
            HashMap hashMap = result;
            return hashMap;
        }
    }

    public Map<Long, DynamicObject> getRelatedInfo(Set<Long> taxFileBoIds, Map<Long, Date> taxFileBoIdAndBsed, Set<String> props) {
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.EXPIRED.getCode(), DataStatusEnum.TO_EFFECT.getCode(), DataStatusEnum.DRAFT.getCode()});
        QFilter boIdFilter = new QFilter("taxfile.id", "in", taxFileBoIds);
        QFilter[] qFilters = new QFilter[]{statusFilter, dataStatusFilter, boIdFilter};
        if (CollectionUtils.isEmpty(props)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityNumber());
        DynamicObject[] dys = serviceHelper.query(String.join((CharSequence)",", props), qFilters);
        if (null == dys || dys.length == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        ArrayList infos = Lists.newArrayListWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            if (dy.getLong("id") == dy.getLong("boid") && !"A".equals(dy.getString("status")) && !"B".equals(dy.getString("status"))) continue;
            infos.add(dy);
        }
        if (CollectionUtils.isEmpty((Collection)infos)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<Long, List<DynamicObject>> map = infos.stream().collect(Collectors.groupingBy(ele -> ele.getLong("taxfile.id")));
        HashMap result = Maps.newHashMapWithExpectedSize((int)taxFileBoIds.size());
        map.forEach((taxFileBoId, list) -> {
            for (DynamicObject dy : list) {
                Date bsled;
                Date bsed;
                Date date = (Date)taxFileBoIdAndBsed.get(taxFileBoId);
                if (!SitDateUtil.isCover((Date)date, (Date)(bsed = dy.getDate("bsed")), (Date)(bsled = dy.getDate("bsled")))) continue;
                result.put(taxFileBoId, dy);
            }
        });
        return result;
    }
}

