/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.servicehelper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.Encrypters;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class EncodeUpdateServiceHelper {
    String primaryKey;
    String tableName;
    List<Map<String, String>> fieldList;

    public EncodeUpdateServiceHelper(String primaryKey, String tableName, List<Map<String, String>> fieldList) {
        this.primaryKey = primaryKey;
        this.tableName = tableName;
        this.fieldList = fieldList;
    }

    public void updateData() {
        List<Object[]> paramsList;
        int batchIndex = 0;
        StringBuilder setSql = new StringBuilder();
        for (int index = 0; index < this.fieldList.size(); ++index) {
            Map<String, String> field = this.fieldList.get(index);
            if (setSql.length() > 0) {
                setSql.append(',');
            }
            setSql.append(field.get("encodeField")).append(" = ? ").append(", ").append(field.get("decodeField")).append(" = ? ");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(this.tableName);
        sql.append(" set ").append((CharSequence)setSql);
        sql.append("where ").append(this.primaryKey).append(" = ?");
        while (batchIndex < 100000 && !CollectionUtils.isEmpty(paramsList = this.getUpdateParamsList())) {
            SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)sql.toString(), paramsList);
            ++batchIndex;
        }
    }

    private List<Object[]> getUpdateParamsList() {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(12);
        StringBuilder fieldsSql = new StringBuilder();
        fieldsSql.append(this.primaryKey);
        StringBuilder whereSql = new StringBuilder();
        for (Map<String, String> fieldMap : this.fieldList) {
            String encodeField = fieldMap.get("encodeField");
            fieldsSql.append(',').append(encodeField);
            if (whereSql.length() > 0) {
                whereSql.append(" or ");
            }
            whereSql.append(encodeField).append(" is not null ");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select top 10000 ").append((CharSequence)fieldsSql).append(" from ").append(this.tableName).append(" where ").append(this.primaryKey).append(" is not null ").append("and (").append((CharSequence)whereSql).append(')');
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"queryEncodeUpdateEntryDataService", (DBRoute)SITConstants.SIT_ROUTE, (String)sql.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Object id = row.get(this.primaryKey);
                Object[] params = new Object[2 * this.fieldList.size() + 1];
                int index = 0;
                int paramIndex = 0;
                while (index < this.fieldList.size()) {
                    Object value;
                    Map<String, String> fieldMap = this.fieldList.get(index);
                    String valueEnp = row.getString(fieldMap.get("encodeField"));
                    String dataType = fieldMap.get("dataType");
                    if (SITStringUtils.equals((String)"String", (String)dataType)) {
                        value = Encrypters.decode((String)valueEnp);
                    } else {
                        try {
                            value = new BigDecimal(Encrypters.decode((String)valueEnp));
                        }
                        catch (Exception exception) {
                            value = BigDecimal.ZERO;
                        }
                    }
                    params[paramIndex] = null;
                    params[++paramIndex] = value;
                    ++index;
                    ++paramIndex;
                }
                params[params.length - 1] = id;
                paramsList.add(params);
            }
        }
        return paramsList;
    }

    public static Map<String, Map<String, Object>> createTableInfoMap(String paramStr) {
        String[] tableParamStrs = paramStr.split(";");
        HashMap<String, Map<String, Object>> tableInfoMap = new HashMap<String, Map<String, Object>>(tableParamStrs.length);
        for (String tableParamStr : tableParamStrs) {
            HashMap<String, Object> tableInfo = new HashMap<String, Object>(3);
            String[] params = tableParamStr.split(":");
            tableInfoMap.put(params[0], tableInfo);
            tableInfo.put("tableName", params[1]);
            tableInfo.put("primaryKey", params[2]);
            String[] fields = params[3].split(",");
            ArrayList fieldList = new ArrayList(fields.length);
            tableInfo.put("fieldList", fieldList);
            for (String field : fields) {
                String[] fieldParam = field.split("#");
                HashMap<String, String> fieldMap = new HashMap<String, String>(2);
                fieldMap.put("decodeField", fieldParam[0]);
                fieldMap.put("encodeField", fieldParam[0] + "_enp");
                if (fieldParam.length == 2) {
                    fieldMap.put("dataType", fieldParam[1]);
                }
                fieldList.add(fieldMap);
            }
        }
        return tableInfoMap;
    }
}

