/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.servicehelper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sit.sitbp.business.servicehelper.task.MultithreadedQueryTask;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.util.SITListUtil;
import org.apache.commons.lang.ArrayUtils;

public class SITMultithreadedQueryHelper {
    protected static final Log logger = LogFactory.getLog(SITMultithreadedQueryHelper.class);

    public static SITMultithreadedQueryHelper getInstance() {
        return SITMultithreadedQueryHelperHolder.SERVICE;
    }

    public DynamicObject[] getData(String entityName, String selectProperties, List<Long> pkIds, QFilter filter, String orderBy) throws InterruptedException {
        Object[] coll = null;
        List splitIds = SITListUtil.split(pkIds, (int)500);
        int num = splitIds.size();
        CountDownLatch latch = new CountDownLatch(num);
        ArrayList<Future> futureList = new ArrayList<Future>(num);
        for (List splitIdList : splitIds) {
            QFilter subFilter = new QFilter("id", "in", (Object)splitIdList);
            subFilter.and(filter);
            MultithreadedQueryTask task = new MultithreadedQueryTask(entityName, selectProperties, new QFilter[]{subFilter}, orderBy, latch);
            Future future = SITThreadPoolFactory.getMultithreadedQueryThreadpool().submit((Callable)task);
            futureList.add(future);
        }
        try {
            boolean flag = latch.await(10L, TimeUnit.MINUTES);
            if (!flag) {
                return new DynamicObject[0];
            }
            for (Future future : futureList) {
                if (coll == null) {
                    coll = (DynamicObject[])future.get();
                    continue;
                }
                coll = (DynamicObject[])ArrayUtils.addAll((Object[])coll, (Object[])((Object[])future.get()));
            }
        }
        catch (ExecutionException e) {
            logger.error((Throwable)e);
        }
        return coll == null ? new DynamicObject[]{} : coll;
    }

    public DynamicObject[] getData(String entityName, String selectProperties, List<Long> pkIds, String orderBy) throws InterruptedException {
        return this.getData(entityName, selectProperties, pkIds, null, orderBy);
    }

    private static class SITMultithreadedQueryHelperHolder {
        private static final SITMultithreadedQueryHelper SERVICE = new SITMultithreadedQueryHelper();

        private SITMultithreadedQueryHelperHolder() {
        }
    }
}

