/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.servicehelper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.DimValueResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public class SITPermissionServiceHelper {
    private static Log logger = LogFactory.getLog(SITPermissionServiceHelper.class);
    public static final String ITC = "30";
    public static final String HCSI = "31";

    public static boolean isSuperUser() {
        return SuperUserCache.isSuperUser((long)RequestContext.get().getCurrUserId());
    }

    public static boolean hasPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"11", (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            return true;
        }
        List orgIds = result.getHasPermOrgs();
        return orgIds.contains(orgId);
    }

    public static HasPermOrgResult getPermOrgs(String appId, String entityNum, String permItemId) {
        return PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)ITC, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static Optional<List<Long>> getPermOrgsOpt(String orgViewType, String appId, String entityNum, String permItemId) {
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs(orgViewType, appId, entityNum, permItemId);
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List<Long> hasPermOrgs = permOrgs.getHasPermOrgs();
            logger.info("SITPermissionServiceHelper.getPermOrgsOpt: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            if (hasPermOrgs == null || hasPermOrgs.isEmpty()) {
                hasPermOrgs = Collections.singletonList(0L);
            }
            return Optional.ofNullable(hasPermOrgs);
        }
        return Optional.empty();
    }

    public static HasPermOrgResult getPermOrgs(String orgViewType, String appId, String entityNum, String permItemId) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static HasPermOrgResult getPermOrgs(String appId, String entityNum) {
        return PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)ITC, (String)appId, (String)entityNum, (String)"47150e89000000ac");
    }

    public static HasPermOrgResult getPermOrgs(Long userId, String appId, String entityNum) {
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)ITC, (String)appId, (String)entityNum, (String)"47150e89000000ac");
    }

    public static List<Long> getUserHasPermOrgs(Long userId) {
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (result.hasAllOrgPerm()) {
            return Collections.emptyList();
        }
        return result.getHasPermOrgs();
    }

    public static boolean hasPermByPermItemNum(long userId, String entityName, String permItemNum) {
        return SITPermissionServiceHelper.hasPermItemOfEntity(userId, entityName, permItemNum, SITPermissionServiceHelper.getBizAppId(entityName));
    }

    private static boolean hasPermItemOfEntity(long userId, String entityName, String permItemNum, String bizAppId) {
        String permItemId = "";
        QFilter[] permItemFilters = new QFilter[]{new QFilter("number", "=", (Object)permItemNum)};
        DynamicObject permItemDy = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_permitem", (String)"id", (QFilter[])permItemFilters);
        if (permItemDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u6743\u9650\u9879\u4e0d\u5b58\u5728\uff01", (String)"SITPermissionServiceHelper_1", (String)"sit-sitbp-business", (Object[])new Object[]{permItemNum}));
        }
        permItemId = permItemDy.getString("id");
        return SITPermissionServiceHelper.hasPerm(userId, bizAppId, entityName, permItemId);
    }

    private static String getBizAppId(String entityName) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)entityName)};
        DynamicObject formDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,bizappid", (QFilter[])filters);
        if (formDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u9875\u9762\u4e0d\u5b58\u5728\uff01", (String)"SITPermissionServiceHelper_0", (String)"sit-sitbp-business", (Object[])new Object[]{entityName}));
        }
        String formId = formDy.getString("id");
        String bizAppId = formDy.getString("bizappid");
        if (HRStringUtils.isEmpty((String)bizAppId)) {
            bizAppId = SITPermissionServiceHelper.getAppIdByFormId(formId);
        }
        return bizAppId;
    }

    public static boolean hasPerm(long userId, String entityName, String permItemId) {
        return SITPermissionServiceHelper.hasPerm(userId, SITPermissionServiceHelper.getBizAppId(entityName), entityName, permItemId);
    }

    public static boolean hasPermByPermItemNum(long userId, String appId, String entityName, String permItemNum) {
        return SITPermissionServiceHelper.hasPermItemOfEntity(userId, entityName, permItemNum, appId);
    }

    public static boolean hasPerm(long userId, String appId, String entityName, String permItemId) {
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)permItemId);
    }

    public static boolean hasPerm(String appId, String entityName, String permItemId) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityName, (String)permItemId);
    }

    public static String getNoPermTips(String opName) {
        if (HRStringUtils.isEmpty((String)opName)) {
            return ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"SITPermissionServiceHelper_2", (String)"sit-sitbp-business", (Object[])new Object[0]);
        }
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0[%s]\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"SITPermissionServiceHelper_3", (String)"sit-sitbp-business", (Object[])new Object[0]), opName);
    }

    public static boolean hasViewPermission(String appId, String entityNum) {
        return PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityNum);
    }

    public static Set<Long> getAdminOrgSetByPermItem(String appId, String entityNumber, String permItemId, String propKey) {
        return SITPermissionServiceHelper.getAdminOrgSetByPermItem(RequestContext.get().getCurrUserId(), appId, entityNumber, permItemId, propKey);
    }

    public static Set<Long> getEmpgrpSetByPermItemAndApp(String appNumber, String appId, String entityNumber) {
        List<Long> appEmpGroupIdList = SITPermissionServiceHelper.getEmpgroupByAppNumber(appNumber);
        if (CollectionUtils.isEmpty(appEmpGroupIdList)) {
            return null;
        }
        HashSet appEmpGroupIdSet = Sets.newHashSet(appEmpGroupIdList);
        Set<Long> empGroupSet = SITPermissionServiceHelper.getEmpgrpSetByPermItem(appId, entityNumber, "47150e89000000ac");
        if (empGroupSet == null) {
            return appEmpGroupIdSet;
        }
        return empGroupSet.stream().filter(id -> appEmpGroupIdSet.contains(id)).collect(Collectors.toSet());
    }

    public static Set<Long> getEmpgrpSetByPermItem(String appId, String entityNumber) {
        return SITPermissionServiceHelper.getEmpgrpSetByPermItem(appId, entityNumber, "47150e89000000ac");
    }

    public static Set<Long> getEmpgrpSetByPermItem(String appId, String entityNumber, String permItemId) {
        return SITPermissionServiceHelper.getEmpgrpSetByPermItem(RequestContext.get().getCurrUserId(), appId, entityNumber, permItemId);
    }

    public static QFilter getBaseDataFilter(String entityID, Long orgID) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)orgID);
    }

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgID, boolean isRemoveDup) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, orgID, (boolean)isRemoveDup);
    }

    public static Set<Long> getValidBaseDataEntityIds(Collection<DynamicObject> inputEntityDies, String orgFieldId, String refField, String entryEntity) {
        boolean isValid;
        if (inputEntityDies == null || inputEntityDies.size() == 0) {
            return new HashSet<Long>(0);
        }
        boolean isEntryEntity = HRStringUtils.isNotEmpty((String)entryEntity);
        DynamicObject entityDy = inputEntityDies.iterator().next();
        DataEntityPropertyCollection properties = entityDy.getDynamicObjectType().getProperties();
        boolean bl = isValid = properties.containsKey((Object)orgFieldId) && (!isEntryEntity || properties.containsKey((Object)entryEntity));
        if (!isValid) {
            return new HashSet<Long>(0);
        }
        Map<Long, List<DynamicObject>> inputEntityDyGroupByOrg = inputEntityDies.stream().collect(Collectors.groupingBy(inputEntityDy -> inputEntityDy.getLong(orgFieldId + ".id")));
        HashSet<Long> validBaseDataIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<DynamicObject>> inputEntityDyGroupByOrgEntry : inputEntityDyGroupByOrg.entrySet()) {
            Set<Long> subValidBaseDataIds = SITPermissionServiceHelper.getSubValidBaseDataIds(isEntryEntity, inputEntityDyGroupByOrgEntry.getKey(), inputEntityDyGroupByOrgEntry.getValue(), refField, entryEntity);
            validBaseDataIds.addAll(subValidBaseDataIds);
        }
        return validBaseDataIds;
    }

    private static Set<Long> getSubValidBaseDataIds(boolean isEntryEntity, Long orgId, List<DynamicObject> subInputEntityDies, String refField, String entryEntity) {
        if (orgId == null || subInputEntityDies == null || subInputEntityDies.isEmpty()) {
            return new HashSet<Long>(0);
        }
        List refEntities = isEntryEntity ? subInputEntityDies.stream().flatMap(inputEntityDy -> inputEntityDy.getDynamicObjectCollection(entryEntity).stream()).filter(entityEntityDy -> entityEntityDy.getDynamicObject(refField) != null && entityEntityDy.getLong(refField + ".id") != 0L).map(tmpEntityDy -> tmpEntityDy.getDynamicObject(refField)).collect(Collectors.toList()) : subInputEntityDies.stream().filter(tmpEntityDy -> tmpEntityDy.getDynamicObject(refField) != null && tmpEntityDy.getLong(refField + ".id") != 0L).map(tmpEntityDy -> tmpEntityDy.getDynamicObject(refField)).collect(Collectors.toList());
        if (refEntities.size() == 0) {
            return new HashSet<Long>(0);
        }
        String refEntityName = ((DynamicObject)refEntities.get(0)).getDynamicObjectType().getName();
        List refEntityIds = refEntities.stream().map(refEntity -> refEntity.getLong("id")).collect(Collectors.toList());
        QFilter orgBaseDataFilter = SITPermissionServiceHelper.getBaseDataFilter(refEntityName, orgId);
        QFilter entityFilter = new QFilter("id", "in", refEntityIds);
        entityFilter.and(orgBaseDataFilter);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(refEntityName);
        DynamicObjectCollection entityDys = helper.queryOriginalCollection("id", entityFilter.toArray());
        if (entityDys == null || entityDys.size() == 0) {
            return new HashSet<Long>(0);
        }
        return entityDys.stream().map(tmpEntityDy -> tmpEntityDy.getLong("id")).collect(Collectors.toSet());
    }

    public static QFilter getOrgFilterByOrgPerm(String appId, String permEntityNumber, String permItemId, String baseDataEntity) {
        HasPermOrgResult permOrgResult = SITPermissionServiceHelper.getPermOrgs(appId, permEntityNumber, permItemId);
        if (permOrgResult.hasAllOrgPerm()) {
            return null;
        }
        List orgIDList = permOrgResult.getHasPermOrgs();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseDataEntity);
        String mainOrg = type.getMainOrg();
        return new QFilter(mainOrg, "in", (Object)orgIDList);
    }

    public static String getPermissionOfDataEntityOperate(String entityNumber, String opKey) {
        if (HRStringUtils.isEmpty((String)opKey)) {
            return null;
        }
        try {
            Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)opKey);
            String permissionItemId = null;
            if (operateMetaMap != null) {
                permissionItemId = (String)operateMetaMap.get("permission");
            }
            return permissionItemId;
        }
        catch (Exception ex) {
            logger.error("SITPermissionServiceHelper.getPermissionOfDataEntityOperate, error info is: ", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    public static List<QFilter> getAuthorizedDataRuleQFilterByOpKey(String appId, String entityNumber, String opKey) {
        String permissionItemIdOfOpKey = null;
        try {
            permissionItemIdOfOpKey = SITPermissionServiceHelper.getPermissionOfDataEntityOperate(entityNumber, opKey);
        }
        catch (Exception ex) {
            logger.error("SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey, error info is: ", (Throwable)ex);
        }
        if (HRStringUtils.isEmpty((String)permissionItemIdOfOpKey)) {
            permissionItemIdOfOpKey = "47150e89000000ac";
        }
        return SITPermissionServiceHelper.getAuthorizedDataRuleQFilter(RequestContext.get().getCurrUserId(), appId, entityNumber, permissionItemIdOfOpKey);
    }

    public static List<QFilter> getAuthorizedDataRuleQFilter(String appId, String entityNumber, String permItemId) {
        return SITPermissionServiceHelper.getAuthorizedDataRuleQFilter(RequestContext.get().getCurrUserId(), appId, entityNumber, permItemId);
    }

    public static List<QFilter> getAuthorizedDataRuleQFilter(long userId, String appId, String entityNumber, String permItemId) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)10);
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            logger.info("SITPermissionServiceHelper.getAuthorizedDataRuleQFilter: the current user is supper user.");
            qFilters.add(new QFilter("1", "=", (Object)1));
            return qFilters;
        }
        if (!SITPermissionServiceHelper.hasPerm(userId, appId, entityNumber, permItemId)) {
            logger.info("SITPermissionServiceHelper.getAuthorizedDataRuleQFilter: the current user does not have any permission.");
            return null;
        }
        QFilter qFilter = (QFilter)SITMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, appId, entityNumber, permItemId, new HashMap(16)});
        if (qFilter == null) {
            logger.info("SITPermissionServiceHelper.getAuthorizedDataRuleQFilter: the current user has all permissions.");
            qFilters.add(new QFilter("1", "=", (Object)1));
            return qFilters;
        }
        logger.info("SITPermissionServiceHelper.getAuthorizedDataRuleQFilter: the filter info is [{}]", (Object)qFilter.toString());
        return Collections.singletonList(qFilter);
    }

    private static String getAppIdByFormId(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp", (QFilter[])filters);
        return unitRelForm.getString("bizapp");
    }

    public static Set<Long> getAllPermAdminOrgs(String appId, String entityId, String permItemId, String propKey) {
        Long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResult result = (AuthorizedOrgResult)SITMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, entityId, permItemId, propKey});
        List hasPermOrgs = result.getHasPermOrgs();
        if (hasPermOrgs != null) {
            return new HashSet<Long>(hasPermOrgs);
        }
        return null;
    }

    public static HasPermOrgResult getAllPermOrgs(String appId, String entityNum) {
        return SITPermissionServiceHelper.getAllPermOrgs(appId, entityNum, "47150e89000000ac");
    }

    public static HasPermOrgResult getAllPermOrgs(String appId, String entityNum, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static Set<Long> getAdminOrgSetByPermItem(Long userId, String appId, String entityNumber, String permItemId, String propKey) {
        AuthorizedOrgResult result = (AuthorizedOrgResult)SITMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, entityNumber, permItemId, propKey});
        if (result.isHasAllOrgPerm()) {
            return null;
        }
        List hasPermOrgs = result.getHasPermOrgs();
        if (hasPermOrgs != null) {
            return new HashSet<Long>(hasPermOrgs);
        }
        return Sets.newHashSet();
    }

    public static Set<Long> getEmpgrpSetByPermItem(Long userId, String appId, String entityNumber, String permItemId) {
        DimValueResult dimValueResult = SITPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "empgroup");
        return SITPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getTaxUnitSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        return SITPermissionServiceHelper.getTaxUnitSetByPermItem(userId, appId, entityNumber, permItemId);
    }

    public static Set<Long> getTaxUnitSetByPermItem(Long userId, String appId, String entityNumber, String permItemId) {
        DimValueResult dimValueResult = SITPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "taxunit");
        return SITPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static DimValueResult getDimValueResult(Long userId, String appId, String entityNumber, String permItemId, String dimNumber) {
        return (DimValueResult)SITMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getEntityDimValue", (Object[])new Object[]{userId, appId, entityNumber, permItemId, dimNumber});
    }

    public static List<Long> getEmpgroupByAppNumber(String appNumber) {
        return (List)SITMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{appNumber});
    }

    public static Set<Long> getAllCompanyByDpt(String appId, String entityNumber, String permItemId, String propKey) {
        Set<Long> adminOrgIds = SITPermissionServiceHelper.getAdminOrgSetByPermItem(appId, entityNumber, permItemId, propKey);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_adminorg");
        QFilter filter = new QFilter("id", "in", adminOrgIds);
        DynamicObjectCollection dyColl = helper.queryOriginalCollection("company", new QFilter[]{filter});
        HashSet companyIds = Sets.newHashSet();
        for (DynamicObject dynamicObject : dyColl) {
            long companyId = dynamicObject.getLong("company");
            if (companyId == 0L) continue;
            companyIds.add(companyId);
        }
        return companyIds;
    }

    private static Set<Long> getSetFromDimValue(DimValueResult dimValueResult) {
        if (dimValueResult != null) {
            if (dimValueResult.isAll()) {
                return null;
            }
            Set dimValueIds = dimValueResult.getDimValueIds();
            if (dimValueIds == null || dimValueIds.isEmpty()) {
                return new HashSet<Long>();
            }
            return dimValueIds.stream().filter(Objects::nonNull).map(ele -> Long.parseLong(ele.trim())).collect(Collectors.toSet());
        }
        logger.error("call IHRCSBizDataPermissionService.getEntityDimValue API error!");
        return new HashSet<Long>();
    }

    public static Set<Long> getCountrySetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SITPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "country");
        return SITPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getWelfarePayerSetByPermItem(Long userId, String appId, String entityNumber, String permItemId) {
        DimValueResult dimValueResult = SITPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "welfarepayer");
        return SITPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getWelfarePayerSetByPermItem(String appId, String entityNumber) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SITPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, "47150e89000000ac", "welfarepayer");
        return SITPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static QFilter getDataRuleForBdProp(String appId, String parentEntityNumber, String propFullKey) {
        return SITPermissionServiceHelper.getDataRuleForBdProp(RequestContext.get().getCurrUserId(), appId, parentEntityNumber, propFullKey, "47156aff000000ac");
    }

    public static QFilter getDataRuleForBdProp(long userId, String appId, String parentEntityNumber, String propFullKey, String permItemId) {
        return (QFilter)SITMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{userId, appId, parentEntityNumber, propFullKey, permItemId, new HashMap(16)});
    }

    public static boolean checkCancelDataAndFunctionRight(IFormView iFormView, boolean fillEntityName) {
        return SITPermissionServiceHelper.checkCancelDataRight(iFormView) || SITPermissionServiceHelper.checkCancelFunctionRight(iFormView, fillEntityName);
    }

    public static boolean checkCancelDataRight(IFormView iFormView) {
        FormShowParameter parentViewParameter;
        if (iFormView != null && (parentViewParameter = SessionManager.getCurrent().getFormShowParameter(iFormView.getFormShowParameter().getParentPageId())) != null && parentViewParameter.isCancelDataRight()) {
            iFormView.getFormShowParameter().setCancelDataRight(true);
            iFormView.showConfirm(SInsuranceInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(SInsuranceInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrCode()));
            return true;
        }
        return false;
    }

    public static boolean checkCancelFunctionRight(IFormView iFormView, boolean fillEntityName) {
        FormShowParameter formShowParameter;
        if (iFormView != null && (formShowParameter = iFormView.getFormShowParameter()) != null && formShowParameter.getCancelRight() != 0) {
            FormConfig config = formShowParameter.getFormConfig();
            String formName = fillEntityName ? "\"" + config.getCaption().toString() + "\"" : "";
            iFormView.showConfirm(SInsuranceInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrInfo(new Object[]{formName}), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(SInsuranceInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrCode()));
            return true;
        }
        return false;
    }

    public static Set<Long> getOrgSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SITPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "adminorg");
        return SITPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static boolean hasOrgPermission(Long orgId, String appId, String entityNumber, String permItemId) {
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs(appId, entityNumber, permItemId);
        if (permOrgs.hasAllOrgPerm()) {
            return true;
        }
        List hasPermOrgs = permOrgs.getHasPermOrgs();
        if (hasPermOrgs == null) {
            return false;
        }
        return hasPermOrgs.contains(orgId);
    }

    public static List<QFilter> getBaseOrgFilters(HasPermOrgResult permOrgResult, String entityName) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!permOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            QFilter baseDataFilter = SITPermissionServiceHelper.getBaseDataFilter(entityName, hasPermOrgs, true);
            qFilters.add(baseDataFilter);
        }
        return qFilters;
    }

    public static Long getCurUserHasPermOrg(String orgViewType, String appId, String entityNum, String permItemId) {
        List hasPermOrgs;
        long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs(orgViewType, appId, entityNum, permItemId);
        if (!(permOrgs.hasAllOrgPerm() || (hasPermOrgs = permOrgs.getHasPermOrgs()) != null && !hasPermOrgs.isEmpty() && hasPermOrgs.contains(orgId))) {
            return 0L;
        }
        Long viewID = PermCommonUtil.getViewIdByNumber((String)orgViewType);
        DynamicObjectCollection orgsCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)viewID)});
        for (DynamicObject orgDy : orgsCol) {
            if (orgId != orgDy.getLong("org")) continue;
            return orgId;
        }
        return 0L;
    }
}

