/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.servicehelper;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.api.DataFilter;
import kd.sit.sitbp.common.entity.CurrencyEntity;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.SitBaseUtil;
import kd.sit.sitbp.common.util.StringMapKeyValue;

public class SitDataServiceHelper {
    public static final DataFilter<String> DEFAULT_FILTER = prop -> !prop.contains("_") && !"multilanguagetext".equalsIgnoreCase((String)prop);

    private SitDataServiceHelper() {
    }

    public static int count(String entityName, List<QFilter> qFilters, String ... props) {
        if (ArrayUtils.isEmpty((Object[])props)) {
            props = new String[]{"id"};
        }
        StringBuilder query = new StringBuilder(props[0]);
        for (int i = 1; i < props.length; ++i) {
            query.append(',').append(props[i]);
        }
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)entityName, (String)query.toString(), (QFilter[])qFilters.toArray(new QFilter[0]));
        return ids.length;
    }

    public static String toQueryProperties(PropertiesQueryInfo info, DataFilter<String> filter) {
        StringBuilder query = new StringBuilder();
        if (info.isAll()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)info.getEntityName());
            DataEntityPropertyCollection properties = mainEntityType.getProperties();
            for (IDataEntityProperty prop : properties) {
                String propName = prop.getName();
                if (filter != null && !filter.accept((Object)propName)) continue;
                List subProps = info.popSubProps(propName);
                if (CollectionUtils.isEmpty((Collection)subProps)) {
                    if (subProps != null || prop.getName().endsWith("_id")) continue;
                    query.append(prop.getName()).append(',');
                    continue;
                }
                for (String subProp : subProps) {
                    query.append(propName).append('.').append(subProp).append(',');
                }
            }
        }
        if (!info.isSubPropsEmpty()) {
            Map specialMap = info.getSpecialMap();
            for (Map.Entry entry : specialMap.entrySet()) {
                if (entry.getValue() == null) {
                    query.append((String)entry.getKey()).append(',');
                    continue;
                }
                if (((List)entry.getValue()).isEmpty()) continue;
                for (String subProp : (List)entry.getValue()) {
                    query.append((String)entry.getKey()).append('.').append(subProp).append(',');
                }
            }
        }
        if (query.length() <= 0) {
            return "id";
        }
        query.deleteCharAt(query.length() - 1);
        return query.toString();
    }

    public static DynamicObject[] commonQuery(PropertiesQueryInfo info, QFilter[] qFilters) {
        return SitDataServiceHelper.commonQuery(info, qFilters, "");
    }

    public static DynamicObject[] commonQuery(PropertiesQueryInfo info, QFilter[] qFilters, String orderBy) {
        String props = SitDataServiceHelper.toQueryProperties(info, null);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(info.getEntityName());
        return serviceHelper.query(props, qFilters, orderBy);
    }

    public static DynamicObject commonQueryOne(PropertiesQueryInfo info, QFilter[] qFilters) {
        String props = SitDataServiceHelper.toQueryProperties(info, null);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(info.getEntityName());
        return serviceHelper.queryOne(props, qFilters);
    }

    public static Map<String, Map<String, String>> resolveCombValues(String entityName, List<String> props) {
        return SitDataServiceHelper.resolveCombAndBooleanValues(entityName, props, false);
    }

    public static Map<String, Map<String, String>> resolveCombAndBooleanValues(String entityName, List<String> props, boolean containBoolean) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (CollectionUtils.isEmpty(props)) {
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(mainEntityType.getProperties().size());
            for (IDataEntityProperty property : mainEntityType.getProperties()) {
                SitDataServiceHelper.setCombResult(containBoolean, result, property, property.getName());
            }
            return result;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(props.size());
        for (String prop : props) {
            String[] ps = StringUtils.split((String)prop, (String)".");
            DynamicProperty property = mainEntityType.getProperty(ps[0]);
            for (int i = 1; i < ps.length && property instanceof BasedataProp; ++i) {
                property = ((BasedataProp)property).getDynamicComplexPropertyType().getProperty(ps[i]);
            }
            SitDataServiceHelper.setCombResult(containBoolean, result, (IDataEntityProperty)property, prop);
        }
        return result;
    }

    private static void setCombResult(boolean containBoolean, Map<String, Map<String, String>> result, IDataEntityProperty property, String propName) {
        if (property instanceof ComboProp) {
            List comboItems = ((ComboProp)property).getComboItems();
            HashMap<String, String> valueMap = new HashMap<String, String>(comboItems.size());
            result.put(propName, valueMap);
            for (ValueMapItem item : comboItems) {
                valueMap.put(item.getValue(), item.getName().getLocaleValue());
            }
        } else if (containBoolean && property instanceof BooleanProp) {
            HashMap<String, String> valueMap = new HashMap<String, String>(2);
            result.put(propName, valueMap);
            valueMap.put(Boolean.FALSE.toString(), SInsuranceInfoEnum.COMMON_NO.getErrInfo());
            valueMap.put(Boolean.TRUE.toString(), SInsuranceInfoEnum.COMMON_YES.getErrInfo());
        }
    }

    public static StringMapKeyValue loadCountry(Long countryId) {
        if (countryId == null || Long.valueOf(0L).equals(countryId)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bd_country");
        DynamicObject dynamicObject = serviceHelper.queryOne((Object)countryId);
        return SitBaseUtil.fromDynamicObject((DynamicObject)dynamicObject);
    }

    public static StringMapKeyValue loadOperator(Long operatorId) {
        if (operatorId == null || Long.valueOf(0L).equals(operatorId)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject dynamicObject = serviceHelper.queryOne((Object)operatorId);
        return SitBaseUtil.fromDynamicObject((DynamicObject)dynamicObject);
    }

    public static StringMapKeyValue loadCurrency(Long currencyId) {
        if (currencyId == null || Long.valueOf(0L).equals(currencyId)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bd_currency");
        DynamicObject dynamicObject = serviceHelper.queryOne((Object)currencyId);
        return SitBaseUtil.fromDynamicObject((DynamicObject)dynamicObject);
    }

    public static BaseResult<String> findAppInfo(long regionId) {
        Map appInfo = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getAppInfoOfRegion", (Object[])new Object[]{Collections.singletonList(regionId)});
        if (CollectionUtils.isEmpty((Map)appInfo)) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230{0}\u5bf9\u5e94\u7684\u5e94\u7528\uff0c\u8bf7\u68c0\u67e5", (String)"BaseTaxFileInfoService_0", (String)"sit-itc-business", (Object[])new Object[]{regionId}));
        }
        return BaseResult.success((Object)((DynamicObject)appInfo.get(regionId)).getString("app.number"));
    }

    public static BaseResult<Map<Long, String>> findAppInfoOfRegions(Collection<Long> regionIds) {
        Map appInfo = CollectionUtils.isEmpty(regionIds) ? (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getAppInfoOfAllRegions", (Object[])new Object[0]) : (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getAppInfoOfRegion", (Object[])new Object[]{regionIds});
        if (CollectionUtils.isEmpty((Map)appInfo)) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5e94\u7528\uff0c\u8bf7\u68c0\u67e5", (String)"BaseTaxFileInfoService_0", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        HashMap resultInfo = Maps.newHashMapWithExpectedSize((int)appInfo.size());
        appInfo.forEach((key, value) -> resultInfo.put(key, value.getString("app.number")));
        return BaseResult.success((Object)resultInfo);
    }

    public static Map<Long, CurrencyEntity> loadCurrencyEntity(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bd_currency");
        PropertiesQueryInfo propertiesQueryInfo = new PropertiesQueryInfo("bd_currency");
        String fields = SitDataServiceHelper.toQueryProperties(propertiesQueryInfo, DEFAULT_FILTER);
        Object[] currencyObjs = serviceHelper.query(fields, new QFilter[]{new QFilter("id", "in", ids)});
        if (ArrayUtils.isEmpty((Object[])currencyObjs)) {
            return Maps.newHashMap();
        }
        HashMap currencyEntityMap = Maps.newHashMapWithExpectedSize((int)currencyObjs.length);
        for (Object currencyObj : currencyObjs) {
            CurrencyEntity currencyEntity = CurrencyEntity.fromDynamicObject((DynamicObject)currencyObj);
            currencyEntityMap.put(currencyEntity.getId(), currencyEntity);
        }
        return currencyEntityMap;
    }

    public static Map<String, IDataEntityProperty> generateDesensitizeMap(EntityType entityType, Collection<String> props) {
        HashMap<String, IDataEntityProperty> desensitizeMap = new HashMap<String, IDataEntityProperty>(16);
        for (String prop : props) {
            String[] split = prop.split("\\.");
            EntityType tempType = entityType;
            for (int i = 0; i < split.length; ++i) {
                DynamicProperty property = tempType.getProperty(split[i]);
                if (PrivacyCenterServiceHelper.isDesensitizeField((String)tempType.getName(), (String)split[i], (String)Lang.get().toString(), (String)"EXPORT", null)) {
                    desensitizeMap.put(prop, (IDataEntityProperty)property);
                    continue;
                }
                if (!(property instanceof BasedataProp)) continue;
                tempType = (EntityType)((BasedataProp)property).getComplexType();
            }
        }
        return desensitizeMap;
    }

    public static Map<Object, Boolean> queryHaveDataByGroup(String algoKey, String entityName, String groupProp, QFilter[] filters) {
        HashMap groupResult = Maps.newHashMap();
        try (DataSet copy4group = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)groupProp, (QFilter[])filters, (String)"");
             DataSet groupCount = copy4group.distinct().groupBy(new String[]{groupProp}).finish();){
            for (Row row : groupCount) {
                if (!StringUtils.isNotBlank((Object)row.get(groupProp))) continue;
                groupResult.put(row.get(groupProp), Boolean.TRUE);
            }
        }
        return groupResult;
    }
}

