/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.taxtaskhandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.business.api.SitAppReportService;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.api.TaxTaskGuideHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;

public abstract class AbstractTaxTaskGuideHandler
implements TaxTaskGuideHandler {
    private static final Log LOGGER = LogFactory.getLog(AbstractTaxTaskGuideHandler.class);

    public List<DynamicObject> handleBatch(TaxTaskEntity taxTask, BatchResult<DynamicObject> taxDataList, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskRecord) {
        LOGGER.info("by cyh: AbstractTaxTaskGuideHandler handleBatch, {}", (Object)this.getClass().getSimpleName());
        List successResult = taxDataList.successResult();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(successResult.size() * 3);
        for (DynamicObject taxData : successResult) {
            long taxFileId = taxData.getLong("id");
            LOGGER.info("by cyh: AbstractTaxTaskGuideHandler taxDataid: {} - {}", (Object)taxFileId, (Object)this.getClass().getSimpleName());
            List<DynamicObject> srcDataTemp = srcDataMap.get(taxFileId);
            StringBuilder stringBuilder = new StringBuilder();
            srcDataTemp.forEach(obj -> stringBuilder.append(obj.getString("id")).append(','));
            LOGGER.info("by cyh: AbstractTaxTaskGuideHandler handleBatch taxDataId : {}", (Object)taxData.getString("id"));
            LOGGER.info("by cyh: AbstractTaxTaskGuideHandler handleBatch taxSrcDataId {} - {}: ", (Object)stringBuilder, (Object)this.getClass().getSimpleName());
            BaseResult<?> handle = this.handle(taxTask, taxData, srcDataTemp, taxTaskRecord);
            if (!handle.isSuccess()) {
                LOGGER.info("by cyh: AbstractTaxTaskGuideHandler successItemToFail, {}, {}", (Object)this.getClass().getSimpleName(), (Object)handle.getMessage());
                taxDataList.successItemToFail((Object)taxData, handle.getStatus(), handle.getMessage());
                continue;
            }
            if (CollectionUtils.isEmpty(srcDataTemp)) continue;
            LOGGER.info("by cyh: AbstractTaxTaskGuideHandler add srcDataTemp, {}", (Object)this.getClass().getSimpleName());
            result.addAll(srcDataTemp);
        }
        return result;
    }

    public void initStatus(DynamicObject taxData) {
        taxData.set(this.getRecordFieldName(), (Object)this.defaultTaxTaskRecordId());
    }

    public BaseResult<?> handle(TaxTaskEntity taxTask, DynamicObject taxData, Collection<DynamicObject> taxSrcData, DynamicObject taxTaskRecord) {
        this.setOpRecord(this.getRecordFieldName(), taxData, taxSrcData, taxTaskRecord, taxTask);
        return BaseResult.success(null);
    }

    protected DynamicObject cloneTaxTaskRecord(TaxTaskEntity taxTask, DynamicObject original, TaxTaskGuideOpEnum opEnum) {
        SitAppReportService sitAppService = SitAppReportService.lookUpSitAppReportService(taxTask.getFromAppId());
        return sitAppService.cloneTaxTaskRecord(original, opEnum);
    }

    protected void setOpRecord(String recordFieldName, DynamicObject taxData, Collection<DynamicObject> taxSrcData, DynamicObject taxTaskRecord, TaxTaskEntity taxTask) {
        String option = (String)GlobalParam.get((String)"feedbackRollback_option");
        if (!StringUtils.equals((CharSequence)"2", (CharSequence)option)) {
            taxData.set(recordFieldName, (Object)taxTaskRecord);
        }
        TaxDataBizStatusEnum statusEnum = TaxDataBizStatusEnum.getStatusEnum(taxData);
        taxData.set("bizstatus", (Object)statusEnum.getCode());
        if (taxSrcData != null) {
            for (DynamicObject srcData : taxSrcData) {
                if (!this.srcStatusMatch(srcData, taxTask)) continue;
                srcData.set(recordFieldName, (Object)taxTaskRecord);
                srcData.set("bizstatus", (Object)statusEnum.getCode());
            }
        }
    }

    protected abstract boolean srcStatusMatch(DynamicObject var1, TaxTaskEntity var2);

    protected abstract String getRecordFieldName();
}

