/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.taxtaskhandler;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.taxtaskhandler.AbstractTaxTaskGuideHandler;
import kd.sit.sitbp.business.taxtaskhandler.TaxTaskGuideImportRollbackHandler;
import kd.sit.sitbp.business.taxtaskhandler.TaxTaskGuideLockRollbackHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;

public class TaxTaskGuideExportRollbackHandler
extends AbstractTaxTaskGuideHandler {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideExportRollbackHandler.class);
    public static final TaxTaskGuideExportRollbackHandler INSTANCE = new TaxTaskGuideExportRollbackHandler();

    @Override
    public List<DynamicObject> handleBatch(TaxTaskEntity taxTask, BatchResult<DynamicObject> taxDataList, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskRecord) {
        super.handleBatch(taxTask, taxDataList, srcDataMap, taxTaskRecord);
        BatchResult delImportTaxDataDys = (BatchResult)GlobalParam.get((String)"delImportTaxDataDys");
        Map delSrcDataMap = (Map)GlobalParam.get((String)"delSrcDataMap");
        if (delImportTaxDataDys != null && delImportTaxDataDys.successResult().size() != 0 && delSrcDataMap != null && delSrcDataMap.size() != 0) {
            LOGGER.info("by cyh: AbstractTaxTaskGuideHandler need ROLLBACK_IMPORT, {}", (Object)this.getClass().getSimpleName());
            DynamicObject importRollbackTaxTaskRecord = this.cloneTaxTaskRecord(taxTask, taxTaskRecord, TaxTaskGuideOpEnum.ROLLBACK_IMPORT);
            TaxTaskGuideImportRollbackHandler.INSTANCE.handleBatch(taxTask, (BatchResult<DynamicObject>)delImportTaxDataDys, delSrcDataMap, importRollbackTaxTaskRecord);
            this.filterTaxDataList(taxDataList, (BatchResult<DynamicObject>)delImportTaxDataDys);
        }
        DynamicObject lockRollbackTaxTaskRecord = this.cloneTaxTaskRecord(taxTask, taxTaskRecord, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON);
        LOGGER.info("by cyh: AbstractTaxTaskGuideHandler need ROLLBACK_LOCK_BY_PERSON, {}", (Object)this.getClass().getSimpleName());
        return TaxTaskGuideLockRollbackHandler.INSTANCE.handleBatch(taxTask, taxDataList, srcDataMap, lockRollbackTaxTaskRecord);
    }

    private void filterTaxDataList(BatchResult<DynamicObject> taxDataList, BatchResult<DynamicObject> delImportTaxDataDys) {
        delImportTaxDataDys.getFailResultOriginal().forEach(obj -> taxDataList.successItemToFail(obj.getData(), obj.getMessage()));
    }

    @Override
    protected boolean srcStatusMatch(DynamicObject srcData, TaxTaskEntity taxTask) {
        Long rawCalTaskId = (Long)GlobalParam.get((String)"feedbackRollback_rawCalTaskId");
        return (rawCalTaskId == null || rawCalTaskId == 0L || rawCalTaskId.longValue() == srcData.getLong("taxdatabasic.rawcaltask.id")) && TaxTaskGuideOpEnum.isYes(srcData.getString("exportoprecord.optype")) && !TaxTaskGuideOpEnum.isYes(srcData.getString("reportoprecord.optype"));
    }

    public long defaultTaxTaskRecordId() {
        return 1004L;
    }

    @Override
    protected String getRecordFieldName() {
        return "exportoprecord";
    }
}

