/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.taxtaskhandler;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.taxtaskhandler.AbstractTaxTaskGuideHandler;
import kd.sit.sitbp.business.taxtaskhandler.TaxTaskGuideExportRollbackHandler;
import kd.sit.sitbp.business.taxtaskhandler.TaxTaskGuideImportRollbackHandler;
import kd.sit.sitbp.business.taxtaskhandler.TaxTaskGuideReferRollbackHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;

public class TaxTaskGuideFeedbackRollbackHandler
extends AbstractTaxTaskGuideHandler {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideFeedbackRollbackHandler.class);
    public static final TaxTaskGuideFeedbackRollbackHandler INSTANCE = new TaxTaskGuideFeedbackRollbackHandler();

    @Override
    public List<DynamicObject> handleBatch(TaxTaskEntity taxTask, BatchResult<DynamicObject> taxDataList, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskRecord) {
        LOGGER.info(" by cyh TaxDataRollbackFeedbackTask begin TaxTaskGuideFeedbackRollbackHandler handleBatch");
        super.handleBatch(taxTask, taxDataList, srcDataMap, taxTaskRecord);
        String option = (String)GlobalParam.get((String)"feedbackRollback_option");
        DynamicObject importRollbackTaxTaskRecord = this.cloneTaxTaskRecord(taxTask, taxTaskRecord, TaxTaskGuideOpEnum.ROLLBACK_IMPORT);
        List<DynamicObject> result = TaxTaskGuideImportRollbackHandler.INSTANCE.handleBatch(taxTask, taxDataList, srcDataMap, importRollbackTaxTaskRecord);
        if (StringUtils.equals((CharSequence)"2", (CharSequence)option)) {
            DynamicObject exportRollbackTaxTaskRecord = this.cloneTaxTaskRecord(taxTask, taxTaskRecord, TaxTaskGuideOpEnum.ROLLBACK_EXPORT_REPORT);
            TaxTaskGuideExportRollbackHandler.INSTANCE.handleBatch(taxTask, taxDataList, srcDataMap, exportRollbackTaxTaskRecord);
            DynamicObject referRollbackTaxTaskRecord = this.cloneTaxTaskRecord(taxTask, taxTaskRecord, TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_TASK);
            result = TaxTaskGuideReferRollbackHandler.INSTANCE.handleBatch(taxTask, taxDataList, srcDataMap, referRollbackTaxTaskRecord);
        }
        return result;
    }

    @Override
    protected boolean srcStatusMatch(DynamicObject srcData, TaxTaskEntity taxTask) {
        Long rawCalTaskId = (Long)GlobalParam.get((String)"feedbackRollback_rawCalTaskId");
        LOGGER.info(" by cyh: TaxTaskGuideFeedbackRollbackHandler srcStatusMatch rawCalTaskId: {}", (Object)rawCalTaskId);
        if (rawCalTaskId == null || rawCalTaskId == 0L) {
            return false;
        }
        return rawCalTaskId.longValue() == srcData.getLong("taxdatabasic.rawcaltask.id") && TaxTaskGuideOpEnum.isYes(srcData.getString("feedbackoprecord.optype")) && !TaxTaskGuideOpEnum.isYes(srcData.getString("reportoprecord.optype"));
    }

    public long defaultTaxTaskRecordId() {
        return 1010L;
    }

    @Override
    protected String getRecordFieldName() {
        return "feedbackoprecord";
    }
}

