/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.taxtaskhandler;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.algo.TaxDataAlgoServiceHelper;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.taxtaskhandler.AbstractTaxTaskGuideHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.AlgoHandlerEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.util.BaseResult;

public class TaxTaskGuideImportRollbackHandler
extends AbstractTaxTaskGuideHandler {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideImportRollbackHandler.class);
    public static final TaxTaskGuideImportRollbackHandler INSTANCE = new TaxTaskGuideImportRollbackHandler();

    @Override
    public BaseResult<?> handle(TaxTaskEntity taxTask, DynamicObject taxData, Collection<DynamicObject> taxSrcData, DynamicObject taxTaskRecord) {
        BaseResult<DynamicObject> result = this.doDelete(taxTask, taxData, (List)taxSrcData);
        if (!result.isSuccess()) {
            return result;
        }
        return super.handle(taxTask, taxData, taxSrcData, taxTaskRecord);
    }

    @Override
    protected boolean srcStatusMatch(DynamicObject srcData, TaxTaskEntity taxTask) {
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTask.getTaxTaskType())) {
            return TaxTaskGuideOpEnum.isYes(srcData.getString("importoprecord.optype")) && !TaxTaskGuideOpEnum.isYes(srcData.getString("reportoprecord.optype"));
        }
        return TaxTaskGuideOpEnum.isYes(srcData.getString("importoprecord.optype")) && !TaxTaskGuideOpEnum.isYes(srcData.getString("feedbackoprecord.optype"));
    }

    public long defaultTaxTaskRecordId() {
        return 1008L;
    }

    @Override
    protected String getRecordFieldName() {
        return "importoprecord";
    }

    private BaseResult<DynamicObject> doDelete(TaxTaskEntity taxTask, DynamicObject taxData, List<DynamicObject> taxSrcData) {
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTask.getTaxTaskType())) {
            return TaxDataAlgoServiceHelper.dealTaxDataAndSrc(taxTask, taxData, taxSrcData, AlgoHandlerEnum.LOCAL_CAL_DELETE_TAX);
        }
        return TaxDataAlgoServiceHelper.dealTaxDataAndSrc(taxTask, taxData, taxSrcData, AlgoHandlerEnum.DELETE_TAX_MERGER);
    }
}

