/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.taxtaskhandler;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.taxtaskhandler.AbstractTaxTaskGuideHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;

public class TaxTaskGuideReferHandler
extends AbstractTaxTaskGuideHandler {
    public static final TaxTaskGuideReferHandler INSTANCE = new TaxTaskGuideReferHandler();

    @Override
    public BaseResult<?> handle(TaxTaskEntity taxTask, DynamicObject taxData, Collection<DynamicObject> taxSrcData, DynamicObject taxTaskRecord) {
        for (DynamicObject srcData : taxSrcData) {
            if (!this.srcStatusMatch(srcData, taxTask)) continue;
            TaxTaskGuideOpEnum.initStatus(srcData);
            srcData.set(this.getRecordFieldName(), (Object)taxTaskRecord);
            srcData.set("bizstatus", (Object)TaxDataBizStatusEnum.REFER.getCode());
        }
        return super.handle(taxTask, taxData, taxSrcData, taxTaskRecord);
    }

    @Override
    protected boolean srcStatusMatch(DynamicObject srcData, TaxTaskEntity taxTask) {
        return !TaxTaskGuideOpEnum.isYes(srcData.getString("lockoprecord.optype"));
    }

    @Override
    public void initStatus(DynamicObject taxData) {
        if ("itc_taxdata".equals(taxData.getDataEntityType().getName())) {
            return;
        }
        taxData.set(this.getRecordFieldName(), (Object)this.defaultTaxTaskRecordId());
    }

    public long defaultTaxTaskRecordId() {
        return 1001L;
    }

    @Override
    protected String getRecordFieldName() {
        return "refoprecord";
    }
}

