/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.taxtaskhandler;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.taxtaskhandler.AbstractTaxTaskGuideHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.GlobalParam;

public class TaxTaskGuideReferRollbackHandler
extends AbstractTaxTaskGuideHandler {
    public static final TaxTaskGuideReferRollbackHandler INSTANCE = new TaxTaskGuideReferRollbackHandler();

    @Override
    protected void setOpRecord(String recordFieldName, DynamicObject taxData, Collection<DynamicObject> taxSrcData, DynamicObject taxTaskRecord, TaxTaskEntity taxTask) {
        boolean delete = true;
        if (!CollectionUtils.isEmpty(taxSrcData)) {
            for (DynamicObject srcData : taxSrcData) {
                if (this.srcStatusMatch(srcData, taxTask)) {
                    TaxTaskGuideOpEnum.initStatus(srcData);
                    srcData.set(recordFieldName, (Object)taxTaskRecord);
                    srcData.set("taxdata", (Object)0L);
                    srcData.set("bizstatus", (Object)TaxDataBizStatusEnum.BACK.getCode());
                    srcData.set("status", (Object)"E");
                    continue;
                }
                delete = false;
            }
        }
        if (delete) {
            taxData.set("bizstatus", (Object)TaxDataBizStatusEnum.DO_DEL.getCode());
        }
    }

    @Override
    protected boolean srcStatusMatch(DynamicObject srcData, TaxTaskEntity taxTask) {
        Long rawCalTaskId = (Long)GlobalParam.get((String)"feedbackRollback_rawCalTaskId");
        return (rawCalTaskId == null || rawCalTaskId == 0L || rawCalTaskId.longValue() == srcData.getLong("taxdatabasic.rawcaltask.id")) && !TaxTaskGuideOpEnum.isYes(srcData.getString("lockoprecord.optype"));
    }

    @Override
    public void initStatus(DynamicObject taxData) {
        if ("itc_taxdata".equals(taxData.getDataEntityType().getName())) {
            return;
        }
        taxData.set(this.getRecordFieldName(), (Object)this.defaultTaxTaskRecordId());
    }

    public long defaultTaxTaskRecordId() {
        return 1002L;
    }

    @Override
    protected String getRecordFieldName() {
        return "refoprecord";
    }
}

