/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.threadpool;

import java.util.ArrayList;
import java.util.List;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.policy.AbortPolicy;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.sit.sitbp.common.enums.SITUnifiedTaskTypeEnum;

public class SITUnifiedThreadPoolFactory {
    private static final int NUM_MINTHREAD = 50;
    private static final int NUM_MAXTHREAD = 150;
    private static final int NUM_OVERFLOWTHREAD = 20;
    public static final ThreadExecutorService SERVICE = ThreadPoolFactory.create((String)"sit", (String)"sit-threadpool", (ThreadPoolStrategy)SITUnifiedThreadPoolFactory.getDefaultThreadPoolStrategy());

    private static ThreadPoolStrategy getDefaultThreadPoolStrategy() {
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        int sumThreadNum = SITUnifiedThreadPoolFactory.getSumThreadNum();
        int minThreadNum = sumThreadNum <= 50 ? sumThreadNum : 50;
        int maxThreadNum = sumThreadNum <= 150 ? sumThreadNum : 150;
        int overflowThreadNum = sumThreadNum - 150;
        overflowThreadNum = overflowThreadNum < 0 ? 0 : overflowThreadNum;
        overflowThreadNum = overflowThreadNum < 20 ? overflowThreadNum : 20;
        strategy.setMinThreadNum(minThreadNum).setMaxThreadNum(maxThreadNum).setOverflowThreadNum(overflowThreadNum).setThreadIdeMinutes(1L);
        strategy.setRejectedExecutionHandler((PoolRejectedExecutionHandler)new AbortPolicy());
        strategy.register(SITUnifiedThreadPoolFactory.getTaskType());
        return strategy;
    }

    private static int getSumThreadNum() {
        int num = 0;
        for (SITUnifiedTaskTypeEnum taskTypeEnum : SITUnifiedTaskTypeEnum.values()) {
            num += taskTypeEnum.getThreadLimitedValue();
        }
        return num;
    }

    private static List<TaskType> getTaskType() {
        ArrayList<TaskType> taskTypeList = new ArrayList<TaskType>(SITUnifiedTaskTypeEnum.values().length);
        for (SITUnifiedTaskTypeEnum taskTypeEnum : SITUnifiedTaskTypeEnum.values()) {
            TaskType taskType = new TaskType(taskTypeEnum.getKey(), taskTypeEnum.getPriority(), taskTypeEnum.getThreadLimitedModel(), (Object)taskTypeEnum.getThreadLimitedValue(), taskTypeEnum.getTaskQueueMaxSize());
            taskTypeList.add(taskType);
        }
        return taskTypeList;
    }

    private static void main(String[] args) {
        SERVICE.execute(() -> {}, SITUnifiedTaskTypeEnum.SIT_COMMONASYNCTHREADPOOL.getKey(), null, null);
    }
}

