/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.upgrade;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.util.BaseResult;

public class TaxDataUpgradeHelper {
    private static final Map<String, Set<String>> FIELDS_MAP = Maps.newHashMap();

    public static BaseResult<Set<String>> checkEncryptFields() {
        if (CollectionUtils.isEmpty(FIELDS_MAP)) {
            return BaseResult.fail((String)"");
        }
        for (Map.Entry<String, Set<String>> entry : FIELDS_MAP.entrySet()) {
            String table = entry.getKey();
            HashSet checkFields = Sets.newHashSet((Iterable)entry.getValue());
            Set encryptFields = PrivacyCenterUtils.getEncryptFields((String)table);
            if (CollectionUtils.isEmpty((Collection)checkFields)) {
                if (CollectionUtils.isEmpty((Collection)encryptFields)) continue;
                return BaseResult.success((Object)encryptFields).ofMessage(table);
            }
            checkFields.retainAll(encryptFields);
            if (CollectionUtils.isEmpty((Collection)checkFields)) continue;
            return BaseResult.success((Object)checkFields).ofMessage(table);
        }
        return BaseResult.fail((String)"");
    }

    static {
        FIELDS_MAP.put("t_hrpi_empposorgrel", Sets.newHashSet((Object[])new String[]{"fsourcevid", "fpersonid", "fiscurrentversion", "fdatastatus", "fbusinessstatus", "fisprimary"}));
        FIELDS_MAP.put("t_hrpi_pertsprop", Sets.newHashSet((Object[])new String[]{"fsourcevid", "fpersonid", "fiscurrentversion", "fdatastatus"}));
        FIELDS_MAP.put("t_hrpi_pereduexp", Sets.newHashSet((Object[])new String[]{"fsourcevid", "fpersonid", "fiscurrentversion", "fdatastatus", "fishighestdegree"}));
        FIELDS_MAP.put("t_hrpi_pernontsprop", Sets.newHashSet((Object[])new String[]{"fsourcevid", "fpersonid", "fiscurrentversion", "fdatastatus"}));
        FIELDS_MAP.put("t_hrpi_percre", Sets.newHashSet((Object[])new String[]{"fsourcevid", "fpersonid", "fiscurrentversion", "fdatastatus", "fismajor"}));
        FIELDS_MAP.put("t_hrpi_person", Sets.newHashSet((Object[])new String[]{"fboid", "fsourcevid", "fiscurrentversion", "fdatastatus"}));
        FIELDS_MAP.put("t_sitbs_taxperiodprg", Sets.newHashSet((Object[])new String[]{"fcountryid"}));
        FIELDS_MAP.put("t_sitbs_taxperiod", Sets.newHashSet((Object[])new String[]{"fenddate", "fdeclareenddate"}));
        FIELDS_MAP.put("t_itc_taxtask", Sets.newHashSet((Object[])new String[]{"ftaxenddate", "fdeclareenddate", "ftaxperiodid"}));
        FIELDS_MAP.put("t_itc_taxfile", Collections.emptySet());
        FIELDS_MAP.put("t_itc_taxfile_a", Collections.emptySet());
        FIELDS_MAP.put("t_itc_taxperson", Collections.emptySet());
        FIELDS_MAP.put("t_itc_taxcontact", Collections.emptySet());
        FIELDS_MAP.put("t_itc_employment", Collections.emptySet());
        FIELDS_MAP.put("t_itc_bankcard", Collections.emptySet());
        FIELDS_MAP.put("t_itc_investor", Collections.emptySet());
        FIELDS_MAP.put("t_itc_overseasperson", Collections.emptySet());
        FIELDS_MAP.put("t_itc_specialinfo", Collections.emptySet());
        FIELDS_MAP.put("t_itc_perdeclrecord", Collections.emptySet());
        FIELDS_MAP.put("t_itc_taxrawdatabasic", Collections.emptySet());
        FIELDS_MAP.put("t_itc_taxrawdata", Collections.emptySet());
        FIELDS_MAP.put("t_itc_taxdata", Collections.emptySet());
        FIELDS_MAP.put("t_itc_taxdatabasic", Collections.emptySet());
        FIELDS_MAP.put("t_hrpi_perbankcard", Collections.emptySet());
    }
}

