/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.business.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.util.MultiLangHelper;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;
import kd.sit.sitbp.common.util.SITStringUtils;

public class ModifyNotAllowedHelper {
    private ModifyNotAllowedHelper() {
    }

    public static Map<DynamicObject, String> checkFieldNotAllowedModify(Collection<DynamicObject> entityDys, List<String> unModifiedFields) {
        if (entityDys == null || entityDys.size() == 0) {
            return new HashMap<DynamicObject, String>(0);
        }
        List<Long> entityIds = entityDys.stream().map(entityDy -> entityDy.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> modifyNotAllowedData = ModifyNotAllowedHelper.getModifyNotAllowedData(entityDys.iterator().next().getDataEntityType().getName(), entityIds);
        HashMap<DynamicObject, String> errEntityMap = new HashMap<DynamicObject, String>(entityDys.size());
        for (DynamicObject entityDy2 : entityDys) {
            long entityId = entityDy2.getLong("id");
            DynamicObject entityDyInDb = modifyNotAllowedData.get(entityId);
            if (entityDyInDb == null) continue;
            DataEntityPropertyCollection properties = entityDyInDb.getDataEntityType().getProperties();
            StringJoiner unModifiedFieldSj = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            for (String unModifiedField : unModifiedFields) {
                boolean isInvalid = false;
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unModifiedField);
                LocaleString displayName = iDataEntityProperty.getDisplayName();
                if (iDataEntityProperty instanceof BasedataProp) {
                    isInvalid = entityDyInDb.getLong(unModifiedField + ".id") != entityDy2.getLong(unModifiedField + ".id");
                } else if (iDataEntityProperty instanceof BigIntProp) {
                    isInvalid = entityDy2.getLong(unModifiedField) != entityDyInDb.getLong(unModifiedField);
                } else if (iDataEntityProperty instanceof IntegerProp) {
                    isInvalid = entityDy2.getLong(unModifiedField) != entityDyInDb.getLong(unModifiedField);
                } else if (iDataEntityProperty instanceof DecimalProp) {
                    BigDecimal newVal = entityDy2.getBigDecimal(unModifiedField);
                    BigDecimal oldVal = entityDyInDb.getBigDecimal(unModifiedField);
                    isInvalid = newVal == null && oldVal != null || newVal != null && oldVal == null || newVal != null && oldVal != null && newVal.compareTo(oldVal) != 0;
                } else if (iDataEntityProperty instanceof TextProp || iDataEntityProperty instanceof ComboProp) {
                    boolean bl = isInvalid = !SITStringUtils.equals((String)entityDy2.getString(unModifiedField), (String)entityDyInDb.getString(unModifiedField));
                }
                if (!isInvalid) continue;
                unModifiedFieldSj.add(SInsuranceInfoEnum.COMMON_QUOTES.getErrInfo(new Object[]{displayName.getLocaleValue()}));
            }
            if (unModifiedFieldSj.length() <= 0) continue;
            errEntityMap.put(entityDy2, SInsuranceInfoEnum.COMMON_DATA_MODIFY_NOT_ALLOWED.getErrInfo(new Object[]{unModifiedFieldSj.toString()}));
        }
        return errEntityMap;
    }

    private static Map<Long, DynamicObject> getModifyNotAllowedData(String entityNumber, List<Long> entityIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter filter = new QFilter("id", "in", entityIds);
        DynamicObject[] cfgData = helper.loadDynamicObjectArray(filter.toArray());
        if (cfgData == null) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(cfgData).collect(Collectors.toMap(cfgDy -> cfgDy.getLong("id"), cfgDy -> cfgDy, (oldVal, newVal) -> oldVal));
    }
}

