/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.api;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.common.api.MergeAlgorithmParamInitializer;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.CalFailTypeEnum;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.util.BaseResult;

public interface MergeAlgorithm {
    public static final Log LOG = LogFactory.getLog(MergeAlgorithm.class);
    public static final String MERGE_VALUE_HANDLER = "MERGE_VALUE_HANDLER";
    public static final String MERGE_LATEST_BY = "MERGE_LATEST_BY";
    public static final String APPEND_SPLIT = "APPEND_SPLIT";
    public static final String DEFAULT_APPEND_SPLIT = ";";
    public static final ExtensionFactory<MergeAlgorithm> ALGORITHM_MAP = ExtensionFactory.getExtensionFacotry(MergeAlgorithm.class);

    public static BaseResult<MergeAlgorithm> genAlgorithm(String algorithmCode) {
        try {
            return BaseResult.success(ALGORITHM_MAP.getExtension(algorithmCode));
        }
        catch (Exception e) {
            return BaseResult.fail("Algorithm[" + algorithmCode + "] not supported");
        }
    }

    public static BaseResult<MergeAlgorithm> genMergeAlgorithm(TaxTaskEntity taxTaskEntity, String dataDirect, long catId, long itemId, Map<String, Object> params) {
        String mergeAlgorithm;
        TaxItemEntity taxItem = taxTaskEntity.getTaxItem(itemId);
        LOG.info("Trace By Quinn: genMergeAlgorithm {} - {}", (Object)itemId, (Object)SerializationUtils.toJsonString((Object)taxItem));
        if (taxItem == null) {
            BaseResult<MergeAlgorithm> fail = BaseResult.fail(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u4e0d\u5b58\u5728\u4e2a\u7a0e\u9879\u76ee\u3010{0}\u3011", (String)"MergeAlgorithm_0", (String)"sit-sitbp-common", (Object[])new Object[]{itemId}));
            fail.ofStatus(CalFailTypeEnum.ITEM_NOT_EXIST.getCode());
            return fail;
        }
        long dataTypeId = taxItem.getDatatypeId();
        SitDataTypeEnum dataTypeEnum = SitDataTypeEnum.getEnumById(dataTypeId);
        if (SitDataTypeEnum.isDecimal(dataTypeId)) {
            params.put("scale", taxItem.getDataPrecisionScale());
            String dataRound = DataRoundEnum.nameById(taxItem.getDataRoundId());
            params.put("dataRound", dataRound);
        }
        if ("sumMerge".equals(mergeAlgorithm = dataTypeEnum.getDefMergeAlgo()) && !CalTaxTypeEnum.SUBMIT.getCode().equals(dataDirect)) {
            Map<Long, String> taxItemSplitEntityMap = taxTaskEntity.getTaxItemSplitEntityMap(catId);
            if (taxItemSplitEntityMap == null) {
                mergeAlgorithm = "latestMerge";
            } else {
                String taxItemSplit = taxItemSplitEntityMap.get(itemId);
                if (StringUtils.isEmpty((CharSequence)taxItemSplit) || !"bySrcProportion".equals(taxItemSplit)) {
                    mergeAlgorithm = "latestMerge";
                }
            }
        }
        return MergeAlgorithm.genAlgorithm(mergeAlgorithm);
    }

    public <T> BaseResult<T> merge(T var1, T var2, Map<String, Object> var3);

    public <T> void genParams(T var1, T var2, Map<String, Object> var3, MergeAlgorithmParamInitializer var4);
}

