/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.api;

import kd.bos.extension.ExtensionFactory;
import kd.bos.ksql.util.StringUtil;
import kd.sit.sitbp.common.cal.impl.unicode.DefaultUniCodeResolver;
import kd.sit.sitbp.common.model.Pair;

public interface TaxCalItemUniCodeResolver {
    public static final TaxCalItemUniCodeResolver DEFAULT = new TaxCalItemUniCodeResolver(){

        @Override
        public String prefix() {
            return TaxCalItemUniCodeResolver.DEFAULT_TYPE;
        }
    };
    public static final String SPLIT = "_$_";
    public static final String DEFAULT_TYPE = "$";
    public static final String PREFIX_TAX_FILE = "TF";
    public static final String PREFIX_TAX_ITEM = "TI";
    public static final String PREFIX_TAX_ACCUMULATOR = "AC";
    public static final String PREFIX_TAX_TASK = "TK";

    public static TaxCalItemUniCodeResolver getResolverBy(String prefix) {
        if (StringUtil.isEmpty((String)prefix)) {
            return DEFAULT;
        }
        if (DEFAULT_TYPE.equals(prefix)) {
            return DefaultUniCodeResolver.INSTANCE;
        }
        ExtensionFactory factory = ExtensionFactory.getExtensionFacotry(TaxCalItemUniCodeResolver.class);
        return (TaxCalItemUniCodeResolver)factory.getExtension(prefix);
    }

    public static Pair<String, String> bizCode(String uniCode) {
        String bizCode;
        String type;
        int index = uniCode.indexOf(SPLIT);
        if (index <= 0) {
            type = DEFAULT_TYPE;
            bizCode = uniCode;
        } else {
            type = uniCode.substring(0, index);
            bizCode = uniCode.substring(index + SPLIT.length());
        }
        bizCode = TaxCalItemUniCodeResolver.getResolverBy(type).decode(bizCode);
        return new Pair<String, String>(type, bizCode);
    }

    default public String uniCode(String bizCode) {
        return this.prefix() + SPLIT + this.encode(bizCode);
    }

    default public String encode(String bizCode) {
        return bizCode;
    }

    default public String decode(String bizCode) {
        return bizCode;
    }

    public String prefix();
}

