/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.StringUtils;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public interface TaxFileInfoService {
    public String generaName();

    public String entityNumber();

    public Map<String, Set<String>> relatedEntityNumber();

    public String supportAppId();

    public Map<String, Object> findKeyInfoByFileBoId(DynamicObject var1);

    public Map<Long, Long> findLatestVersionByFileBoIdsAndDate(List<Long> var1, Date var2, Date var3);

    public DynamicObject findInfoByVid(long var1, Set<String> var3);

    public Map<String, Object> findMapByVid(long var1, Set<String> var3);

    public Map<Long, Map<String, Object>> findInfoByVidSet(Set<Long> var1, Set<String> var2);

    public Map<Long, Map<String, Object>> findInfoByVidSetResultByFile(Set<Long> var1, Set<String> var2);

    public DynamicObject[] findInfo(Map<Long, DynamicObject> var1, TaxFileOpContext var2);

    public OperationResult validate(Map<Long, DynamicObject> var1, Map<Long, DynamicObject> var2, TaxFileOpContext var3);

    public OperationResult operate(Map<Long, DynamicObject> var1, DynamicObject[] var2, TaxFileOpContext var3);

    public BaseResult<?> abandonByFiles(Map<Long, DynamicObject> var1);

    public BaseResult<?> deleteByFiles(Map<Long, DynamicObject> var1);

    public void gatherInfoOf(Map<Long, Map<String, Object>> var1, Map<Long, List<DynamicObject>> var2, Map<String, String> var3, TaxPeriodEntity var4, boolean var5);

    default public void gatherInfoFrom(TaxFileOpContext taxFileOpContext, DynamicObject[] taxFiles, Map<Long, DynamicObject> extraInfos) {
        this.gatherInfoFrom(taxFileOpContext, taxFiles, extraInfos, false);
    }

    public void gatherInfoFrom(TaxFileOpContext var1, DynamicObject[] var2, Map<Long, DynamicObject> var3, boolean var4);

    public Set<String> keyProps();

    public Map<String, String> propMappings();

    public Map<Long, DynamicObject> getRelatedInfo(Set<Long> var1, Map<Long, Date> var2, Set<String> var3);

    default public int priority() {
        return 100;
    }

    default public String fullPropKey(String propKey) {
        return this.entityNumber() + "." + propKey;
    }

    default public boolean isSubInfo() {
        return true;
    }

    default public void setFile(DynamicObject extraInfo, DynamicObject taxFile) {
        extraInfo.set("taxFile", (Object)taxFile);
    }

    default public long getFileId(DynamicObject extraInfo) {
        Object taxFile = extraInfo.get("taxfile");
        if (taxFile instanceof DynamicObject) {
            return ((DynamicObject)taxFile).getLong("id");
        }
        return BaseDataConverter.convert(taxFile, Long.class);
    }

    default public String subPropName() {
        return null;
    }

    default public Map<Long, List<Long>> subIdToFile(Collection<DynamicObject> taxFiles) {
        String propName = this.subPropName();
        if (StringUtils.isEmpty((Object)propName)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)taxFiles.size());
        for (DynamicObject taxFile : taxFiles) {
            Object sub = taxFile.get(propName);
            if (sub == null) continue;
            long subId = sub instanceof DynamicObject ? ((DynamicObject)sub).getLong("id") : BaseDataConverter.convert(sub, Long.class).longValue();
            List fileIds = result.computeIfAbsent(subId, ky -> Lists.newArrayListWithExpectedSize((int)4));
            fileIds.add(taxFile.getLong("id"));
        }
        return result;
    }
}

